/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.entities.part_entities;

import com.wenxin2.marioverse.entities.PiranhaPlantEntity;
import com.wenxin2.marioverse.registries.DamageSourceRegistry;
import com.wenxin2.marioverse.registries.SoundRegistry;
import com.wenxin2.marioverse.registries.TagRegistry;
import com.wenxin2.marioverse.utils.ServerParticleUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.protocol.game.ServerboundInteractPacket;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.entity.PartEntity;
import org.jetbrains.annotations.NotNull;

public class PiranhaPlantPart
extends PartEntity<PiranhaPlantEntity>
implements Leashable {
    public final PiranhaPlantEntity parentMob;
    public final String name;
    private EntityDimensions size;
    private Leashable.LeashData leashData;

    public PiranhaPlantPart(PiranhaPlantEntity parentMob, String name, float width, float height) {
        super((Entity)parentMob);
        this.size = EntityDimensions.scalable((float)width, (float)height);
        this.parentMob = parentMob;
        this.name = name;
        this.refreshDimensions();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        this.leashData = this.readLeashData(tag);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        this.writeLeashData(tag, this.leashData);
    }

    public boolean isPickable() {
        return true;
    }

    @Nullable
    public ItemStack getPickResult() {
        return this.parentMob.getPickResult();
    }

    public void tick() {
        super.tick();
        this.biteEntity();
    }

    @NotNull
    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity entity) {
        return new ClientboundAddEntityPacket((Entity)this, entity);
    }

    @NotNull
    public AABB makeBoundingBox() {
        return super.makeBoundingBox();
    }

    @NotNull
    public EntityDimensions getDimensions(Pose pose) {
        return this.size;
    }

    public boolean hurt(DamageSource source, float damageAmount) {
        Entity entity;
        if (this.level().isClientSide && (entity = source.getDirectEntity()) instanceof Player) {
            Player player = (Player)entity;
            this.level().sendPacketToServer((Packet)ServerboundInteractPacket.createAttackPacket((Entity)this.getParent(), (boolean)player.isShiftKeyDown()));
        }
        return !this.isInvulnerableTo(source) && ((PiranhaPlantEntity)this.getParent()).hurt(source, damageAmount);
    }

    public boolean canBeHitByProjectile() {
        return this.isAlive();
    }

    public void push(Entity entity) {
        if (!((PiranhaPlantEntity)this.getParent()).isSleeping() && !((PiranhaPlantEntity)this.getParent()).isHiding()) {
            super.push(entity);
        }
    }

    public boolean isPushable() {
        return false;
    }

    public boolean isPushedByFluid() {
        return false;
    }

    @NotNull
    public InteractionResult interact(Player player, InteractionHand hand) {
        if (this.level().isClientSide) {
            this.level().sendPacketToServer((Packet)ServerboundInteractPacket.createInteractionPacket((Entity)this.getParent(), (boolean)player.isShiftKeyDown(), (InteractionHand)hand));
        }
        return super.interact(player, hand);
    }

    @NotNull
    public InteractionResult interactAt(Player player, Vec3 vec3, InteractionHand hand) {
        if (this.level().isClientSide) {
            this.level().sendPacketToServer((Packet)ServerboundInteractPacket.createInteractionPacket((Entity)this.getParent(), (boolean)player.isShiftKeyDown(), (InteractionHand)hand, (Vec3)vec3));
        }
        return super.interactAt(player, vec3, hand);
    }

    public boolean canRiderInteract() {
        return ((PiranhaPlantEntity)this.getParent()).canRiderInteract();
    }

    @Nullable
    public Leashable.LeashData getLeashData() {
        return this.leashData;
    }

    public void setLeashData(@Nullable Leashable.LeashData leashData) {
        this.leashData = leashData;
    }

    public boolean canBeLeashed() {
        return true;
    }

    public boolean canCollideWith(Entity entity) {
        return !this.isPassengerOfSameVehicle(entity);
    }

    public void biteEntity() {
        if (((PiranhaPlantEntity)this.getParent()).attackCooldown > 0) {
            return;
        }
        List nearbyEntities = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(0.01), entity -> !entity.isSpectator() && entity instanceof LivingEntity && !(entity instanceof PiranhaPlantEntity) && !this.level().isClientSide());
        if (!nearbyEntities.isEmpty() && !((PiranhaPlantEntity)this.getParent()).isHiding()) {
            for (Entity collidingEntity : nearbyEntities) {
                float attackDamage;
                if (collidingEntity instanceof PiranhaPlantEntity || ((PiranhaPlantEntity)this.getParent()).getOwner() != null && ((PiranhaPlantEntity)this.getParent()).getOwner().getUUID().equals(collidingEntity.getUUID()) || ((PiranhaPlantEntity)this.getParent()).getOwner() != null && !(collidingEntity instanceof Monster) && !collidingEntity.getType().is(TagRegistry.PIRANHA_PLANT_CAN_ATTACK) && (!((PiranhaPlantEntity)this.getParent()).isBaby() || !(collidingEntity instanceof Animal)) || ((PiranhaPlantEntity)this.getParent()).getOwner() == null && !collidingEntity.getType().is(TagRegistry.PIRANHA_PLANT_CAN_ATTACK) || ((PiranhaPlantEntity)this.getParent()).getOwner() != null && collidingEntity.getTeam() != null && ((PiranhaPlantEntity)this.getParent()).getOwner().getTeam() != null && collidingEntity.getTeam() == ((PiranhaPlantEntity)this.getParent()).getOwner().getTeam()) continue;
                ((PiranhaPlantEntity)this.getParent()).swing(InteractionHand.MAIN_HAND);
                float f = attackDamage = ((PiranhaPlantEntity)this.getParent()).isBaby() ? (float)((PiranhaPlantEntity)this.getParent()).getAttributeValue(Attributes.ATTACK_DAMAGE) / 2.0f : (float)((PiranhaPlantEntity)this.getParent()).getAttributeValue(Attributes.ATTACK_DAMAGE);
                if (((PiranhaPlantEntity)this.getParent()).getOwner() != null) {
                    collidingEntity.hurt(DamageSourceRegistry.piranhaChomp(collidingEntity, ((PiranhaPlantEntity)this.getParent()).getOwner()), attackDamage);
                } else {
                    collidingEntity.hurt(DamageSourceRegistry.piranhaChomp(null, (Entity)this), attackDamage);
                }
                if (collidingEntity instanceof NeutralMob) {
                    NeutralMob neutralMob = (NeutralMob)collidingEntity;
                    neutralMob.isAngryAt((LivingEntity)this.getParent());
                    neutralMob.setTarget((LivingEntity)this.getParent());
                    neutralMob.setPersistentAngerTarget(((PiranhaPlantEntity)this.getParent()).getUUID());
                }
                int age = ((PiranhaPlantEntity)this.getParent()).getAge();
                if (((PiranhaPlantEntity)this.getParent()).isBaby()) {
                    ((PiranhaPlantEntity)this.getParent()).ageUp(PiranhaPlantEntity.getSpeedUpSecondsWhenFeeding(-age), 20, true);
                    Level level = ((PiranhaPlantEntity)this.getParent()).level();
                    if (level instanceof ServerLevel) {
                        ServerLevel serverWorld = (ServerLevel)level;
                        ServerParticleUtils.spawnParticlesOnEntityRandomly((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, serverWorld, (Entity)this, 5);
                    }
                }
                this.playSound((SoundEvent)SoundRegistry.PIRANHA_PLANT_CHOMP.get(), 1.0f, 1.0f);
                ((PiranhaPlantEntity)this.getParent()).attackCooldown = 20;
                break;
            }
        }
    }
}

