/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.mixin;

import com.wenxin2.marioverse.items.OneUpMushroomItem;
import com.wenxin2.marioverse.registries.ItemRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityClientMixin
extends Entity {
    public LivingEntityClientMixin(EntityType<?> entityType, Level world) {
        super(entityType, world);
    }

    @Inject(method={"handleEntityEvent"}, at={@At(value="HEAD")})
    private void handleEntityEvent(byte id, CallbackInfo info) {
        LivingEntity livingEntity = (LivingEntity)this;
        if (id == 127) {
            if (this.level().isClientSide && livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                Minecraft.getInstance().gameRenderer.displayItemActivation(LivingEntityClientMixin.mv$find1Up(player));
            }
        } else {
            super.handleEntityEvent(id);
        }
    }

    @Unique
    private static ItemStack mv$find1Up(Player player) {
        for (InteractionHand interactionhand : InteractionHand.values()) {
            ItemStack stack = player.getItemInHand(interactionhand);
            if (!(stack.getItem() instanceof OneUpMushroomItem)) continue;
            return stack;
        }
        return new ItemStack((ItemLike)ItemRegistry.ONE_UP_MUSHROOM.get());
    }
}

