/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.wenxin2.marioverse.Marioverse;
import com.wenxin2.marioverse.blocks.CoinBlock;
import com.wenxin2.marioverse.blocks.InvisibleQuestionBlock;
import com.wenxin2.marioverse.blocks.QuestionBlock;
import com.wenxin2.marioverse.blocks.StarCoinBlock;
import com.wenxin2.marioverse.blocks.entities.QuestionBlockEntity;
import com.wenxin2.marioverse.entities.KoopaShellEntity;
import com.wenxin2.marioverse.entities.KoopaTroopaEntity;
import com.wenxin2.marioverse.items.OneUpMushroomItem;
import com.wenxin2.marioverse.network.client_bound.data.OneUpPayload;
import com.wenxin2.marioverse.registries.AttributesRegistry;
import com.wenxin2.marioverse.registries.ConfigRegistry;
import com.wenxin2.marioverse.registries.DamageSourceRegistry;
import com.wenxin2.marioverse.registries.DataAttachmentRegistry;
import com.wenxin2.marioverse.registries.ItemRegistry;
import com.wenxin2.marioverse.registries.ParticleRegistry;
import com.wenxin2.marioverse.registries.SoundRegistry;
import com.wenxin2.marioverse.registries.TagRegistry;
import com.wenxin2.marioverse.utils.AbilitiesHandler;
import com.wenxin2.marioverse.utils.BlockWarpEntityHandler;
import com.wenxin2.marioverse.utils.EntityWarpEntityHandler;
import com.wenxin2.marioverse.utils.ServerParticleUtils;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.data.SlotTypeLoader;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DecoratedPotBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.registries.DeferredItem;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity
implements BlockWarpEntityHandler,
EntityWarpEntityHandler,
AbilitiesHandler {
    @Unique
    private static final int MAX_PARTICLE_AMOUNT = 100;
    @Unique
    private boolean mv$playedDamagedSound;
    @Unique
    private double mv$currentEyeHeightScale = 1.0;
    @Unique
    private double mv$currentHeightScale = 1.0;
    @Unique
    private double mv$currentWidthScale = 1.0;
    @Unique
    protected float mv$appliedEyeHeightScale = 1.0f;
    @Unique
    protected float mv$appliedHeightScale = 1.0f;
    @Unique
    protected float mv$appliedWidthScale = 1.0f;
    @Unique
    private boolean mv$hasFireFlower;
    @Unique
    private boolean mv$hasIceFlower;
    @Unique
    private boolean mv$hasMegaMushroom;
    @Unique
    private boolean mv$hasSuperMushroom;
    @Unique
    private boolean mv$hasDashMushroomBoost;
    @Unique
    private boolean mv$hasSuperMushroomOverride;
    @Unique
    private boolean mv$hasSmashedBlock;
    @Unique
    private boolean mv$preventWarp;
    @Unique
    private int mv$checkpointFlagCooldown;
    @Unique
    private int mv$consecutiveBounces;
    @Unique
    private int mv$fireballCooldown;
    @Unique
    private int mv$fireballCount;
    @Unique
    private int mv$freezeImmunityCooldown;
    @Unique
    private int mv$frozenCooldown;
    @Unique
    private int mv$iceBallCooldown;
    @Unique
    private int mv$iceBallCount;
    @Unique
    private int mv$oneUpsRewarded;
    @Unique
    private int mv$preventWarpCooldown;
    @Unique
    private int mv$warpCooldown;
    @Unique
    private static final ResourceLocation SLOWDOWN_MODIFIER = ResourceLocation.fromNamespaceAndPath((String)"marioverse", (String)"mini_goomba_slowdown");

    @Shadow
    public abstract void setSpeed(float var1);

    @Shadow
    public abstract void handleEntityEvent(byte var1);

    public LivingEntityMixin(EntityType<?> entityType, Level world) {
        super(entityType, world);
    }

    @Override
    public boolean mv$getBlockWarpTeleportConfig() {
        return (Boolean)ConfigRegistry.TELEPORT_MOBS.get();
    }

    @Override
    public boolean mv$getEntityWarpTeleportConfig() {
        return (Boolean)ConfigRegistry.TELEPORT_MOBS.get();
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    public void addAdditionalSaveData(CompoundTag tag, CallbackInfo ci) {
        LivingEntity entity = (LivingEntity)this;
        tag.putBoolean("marioverse:has_dash_mushroom_boost", this.mv$hasDashMushroomBoost());
        tag.putBoolean("marioverse:has_fire_flower", this.mv$hasFireFlower());
        tag.putBoolean("marioverse:has_ice_flower", this.mv$hasIceFlower());
        tag.putBoolean("marioverse:has_mega_mushroom", this.mv$hasMegaMushroom());
        tag.putBoolean("marioverse:has_super_mushroom", this.mv$hasSuperMushroom());
        tag.putBoolean("marioverse:has_super_mushroom_override", this.mv$hasSuperMushroomOverride());
        tag.putInt("marioverse:fireball_cooldown", this.mv$getFireballCooldown());
        tag.putInt("marioverse:fireball_count", this.mv$getFireballCount());
        tag.putInt("marioverse:ice_ball_cooldown", this.mv$getIceBallCooldown());
        tag.putInt("marioverse:ice_ball_count", this.mv$getIceBallCount());
        tag.putInt("marioverse:ice_ball_count", this.mv$getIceBallCount());
        if (entity.getType().is(TagRegistry.CAN_STOMP_ENEMIES) && (entity.getType().is(TagRegistry.CAN_CONSUME_ONE_UPS) || ((Boolean)ConfigRegistry.ONE_UP_HEALS_ALL_MOBS.get()).booleanValue())) {
            tag.putInt("marioverse:consecutive_bounces", this.mv$getConsecutiveBounces());
            tag.putInt("marioverse:one_ups_rewarded", this.mv$getOneUpsRewarded());
        }
        if (entity.getType().is(TagRegistry.CAN_SMASH_BLOCKS)) {
            tag.putBoolean("marioverse:has_smashed_block", this.mv$hasSmashedBlock());
        }
        if (entity.getType().is(TagRegistry.CAN_CLAIM_CHECKPOINT_FLAGS)) {
            tag.putInt("marioverse:checkpoint_flag_cooldown", this.mv$getCheckpointFlagCooldown());
        }
        if (!entity.getType().is(TagRegistry.ICE_BALL_IMMUNE) && entity instanceof Player) {
            tag.putInt("marioverse:freeze_immunity_cooldown", this.mv$getFreezeImmunityCooldown());
            tag.putInt("marioverse:frozen_cooldown", this.mv$getFrozenCooldown());
        }
        if (!entity.getType().is(TagRegistry.CANNOT_WARP)) {
            if (entity instanceof Player && ((Boolean)ConfigRegistry.TELEPORT_PLAYERS.get()).booleanValue()) {
                tag.putBoolean("marioverse:prevent_warp", this.mv$doPreventWarp());
                tag.putInt("marioverse:warp_cooldown", this.mv$getWarpCooldown());
            } else if (((Boolean)ConfigRegistry.TELEPORT_MOBS.get()).booleanValue()) {
                tag.putBoolean("marioverse:prevent_warp", this.mv$doPreventWarp());
                tag.putInt("marioverse:warp_cooldown", this.mv$getWarpCooldown());
            }
            if (entity instanceof Player) {
                tag.putInt("marioverse:prevent_warp_cooldown", this.mv$getPreventWarpCooldown());
            }
        }
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    public void readAdditionalSaveData(CompoundTag tag, CallbackInfo ci) {
        LivingEntity entity = (LivingEntity)this;
        this.mv$setDashMushroomBoost(tag.getBoolean("marioverse:has_dash_mushroom_boost"));
        this.mv$setFireFlower(tag.getBoolean("marioverse:has_fire_flower"));
        this.mv$setFireballCooldown(tag.getInt("marioverse:fireball_cooldown"));
        this.mv$setFireballCount(tag.getInt("marioverse:fireball_count"));
        this.mv$setIceBallCooldown(tag.getInt("marioverse:ice_ball_cooldown"));
        this.mv$setIceBallCount(tag.getInt("marioverse:ice_ball_count"));
        this.mv$setIceFlower(tag.getBoolean("marioverse:has_ice_flower"));
        this.mv$setMegaMushroom(tag.getBoolean("marioverse:has_mega_mushroom"));
        this.mv$setMushroomOverride(tag.getBoolean("marioverse:has_super_mushroom_override"));
        this.mv$setSuperMushroom(tag.getBoolean("marioverse:has_super_mushroom"));
        if (entity.getType().is(TagRegistry.CAN_STOMP_ENEMIES) && (entity.getType().is(TagRegistry.CAN_CONSUME_ONE_UPS) || ((Boolean)ConfigRegistry.ONE_UP_HEALS_ALL_MOBS.get()).booleanValue())) {
            this.mv$setConsecutiveBounces(tag.getInt("marioverse:consecutive_bounces"));
            this.mv$setOneUpsRewarded(tag.getInt("marioverse:one_ups_rewarded"));
        }
        if (entity.getType().is(TagRegistry.CAN_SMASH_BLOCKS)) {
            this.mv$setSmashedBlock(tag.getBoolean("marioverse:has_smashed_block"));
        }
        if (entity.getType().is(TagRegistry.CAN_CLAIM_CHECKPOINT_FLAGS)) {
            this.mv$setCheckpointFlagCooldown(tag.getInt("marioverse:checkpoint_flag_cooldown"));
        }
        if (!entity.getType().is(TagRegistry.ICE_BALL_IMMUNE) && entity instanceof Player) {
            this.mv$setFreezeImmunityCooldown(tag.getInt("marioverse:freeze_immunity_cooldown"));
            this.mv$setFrozenCooldown(tag.getInt("marioverse:frozen_cooldown"));
        }
        if (!entity.getType().is(TagRegistry.CANNOT_WARP)) {
            if (entity instanceof Player && ((Boolean)ConfigRegistry.TELEPORT_PLAYERS.get()).booleanValue()) {
                this.mv$setPreventWarp(tag.getBoolean("marioverse:prevent_warp"));
                this.mv$setWarpCooldown(tag.getInt("marioverse:warp_cooldown"));
            } else if (((Boolean)ConfigRegistry.TELEPORT_MOBS.get()).booleanValue()) {
                this.mv$setPreventWarp(tag.getBoolean("marioverse:prevent_warp"));
                this.mv$setWarpCooldown(tag.getInt("marioverse:warp_cooldown"));
            }
            if (entity instanceof Player) {
                this.mv$setPreventWarpCooldown(tag.getInt("marioverse:prevent_warp_cooldown"));
            }
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    public void tick(CallbackInfo ci) {
        float f7;
        float f6;
        float f5;
        LivingEntity entity = (LivingEntity)this;
        Level world = entity.level();
        BlockPos pos = entity.blockPosition();
        BlockPos posAboveEntity = pos.above(Math.round(entity.getBbHeight()));
        BlockPos posNorth = pos.north(Math.round(this.getBbWidth() + 0.1f));
        BlockPos posSouth = pos.south(Math.round(this.getBbWidth() + 0.1f));
        BlockPos posEast = pos.east(Math.round(this.getBbWidth() + 0.1f));
        BlockPos posWest = pos.west(Math.round(this.getBbWidth() + 0.1f));
        BlockState stateAboveEntity = world.getBlockState(posAboveEntity);
        BlockState stateNorth = world.getBlockState(posNorth);
        BlockState stateSouth = world.getBlockState(posSouth);
        BlockState stateEast = world.getBlockState(posEast);
        BlockState stateWest = world.getBlockState(posWest);
        RandomSource rand = RandomSource.create();
        this.mv$characterAbilities(entity);
        this.mv$mushroomScale(entity);
        if (((Boolean)ConfigRegistry.ENABLE_STOMPABLE_ENEMIES.get()).booleanValue() && (entity.getType().is(TagRegistry.CAN_STOMP_ENEMIES) || ((Boolean)ConfigRegistry.ALL_MOBS_CAN_STOMP.get()).booleanValue() || world.getGameRules().getBoolean(Marioverse.ALL_MOBS_CAN_STOMP)) && (entity.fallDistance > 0.0f || entity.isInWaterOrBubble()) && !(entity instanceof Player) && !entity.isSpectator()) {
            this.mv$squashEntity(entity);
        }
        if (((Boolean)ConfigRegistry.ENABLE_STOMPABLE_ENEMIES.get()).booleanValue() && (entity.getType().is(TagRegistry.CAN_STOMP_ENEMIES) || ((Boolean)ConfigRegistry.ALL_MOBS_CAN_STOMP.get()).booleanValue() || world.getGameRules().getBoolean(Marioverse.ALL_MOBS_CAN_STOMP)) && (entity.onGround() || entity.isInWaterOrBubble()) && this.mv$getConsecutiveBounces() > 0 && !((Boolean)entity.getData(DataAttachmentRegistry.HAS_SUPER_STAR)).booleanValue()) {
            this.mv$setConsecutiveBounces(0);
        }
        if ((entity.onGround() || entity.isInWaterOrBubble()) && entity.getDeltaMovement().y <= 0.0 && this.mv$hasSmashedBlock()) {
            this.mv$setSmashedBlock(false);
        }
        double deltaY = entity.getDeltaMovement().y;
        if (stateAboveEntity.is(TagRegistry.SMASHABLE_BLOCKS) && entity.getType().is(TagRegistry.CAN_SMASH_BLOCKS) && !entity.onGround() && deltaY > -0.079 && !entity.isSpectator() && !this.mv$hasSmashedBlock() && (EventHooks.canEntityGrief((Level)world, (Entity)entity) || entity instanceof Player) && !world.isClientSide) {
            this.mv$smashBlock(world, posAboveEntity, stateAboveEntity, entity);
        }
        if ((EventHooks.canEntityGrief((Level)world, (Entity)entity) || entity instanceof Player) && !world.isClientSide) {
            this.mv$shellSmashBlock(stateNorth, entity, world, posNorth, stateSouth, posSouth, stateEast, posEast, stateWest, posWest);
        }
        if (stateAboveEntity.is(TagRegistry.BONKABLE_BLOCKS) && entity.getType().is(TagRegistry.CAN_BONK_BLOCKS) && !entity.onGround() && deltaY > -0.079 && !entity.isSpectator()) {
            if (stateAboveEntity.hasProperty((Property)QuestionBlock.EMPTY) && ((Boolean)stateAboveEntity.getValue((Property)QuestionBlock.EMPTY)).booleanValue()) {
                world.playSound(null, posAboveEntity, (SoundEvent)SoundRegistry.BLOCK_BONK.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            } else {
                world.playSound(null, posAboveEntity, (SoundEvent)SoundRegistry.BLOCK_BONK.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
        this.mv$shellBonkBlock(stateNorth, entity, world, posNorth, stateSouth, posSouth, stateEast, posEast, stateWest, posWest);
        BlockEntity blockEntity = world.getBlockEntity(posAboveEntity);
        if (blockEntity instanceof QuestionBlockEntity) {
            QuestionBlockEntity questionBlockEntity = (QuestionBlockEntity)blockEntity;
            if (entity.getType().is(TagRegistry.CAN_HIT_QUESTION_BLOCKS) && !entity.onGround() && deltaY > -0.079 && !entity.isSpectator() && (EventHooks.canEntityGrief((Level)world, (Entity)entity) || entity instanceof Player) && !world.isClientSide) {
                this.mv$hitQuestionBlock(world, posAboveEntity, questionBlockEntity);
            }
        }
        if ((EventHooks.canEntityGrief((Level)world, (Entity)entity) || entity instanceof Player) && !world.isClientSide) {
            this.mv$shellHitQuestionBlock(world, posNorth, entity, posSouth, posEast, posWest);
        }
        if (this.mv$getCheckpointFlagCooldown() > 0) {
            this.mv$setCheckpointFlagCooldown(this.mv$getCheckpointFlagCooldown() - 1);
        }
        if (this.mv$getFireballCooldown() > 0) {
            this.mv$setFireballCooldown(this.mv$getFireballCooldown() - 1);
        }
        if (this.mv$getIceBallCooldown() > 0) {
            this.mv$setIceBallCooldown(this.mv$getIceBallCooldown() - 1);
        }
        if (this.mv$getFreezeImmunityCooldown() > 0) {
            this.mv$setFreezeImmunityCooldown(this.mv$getFreezeImmunityCooldown() - 1);
        }
        if (this.mv$getFrozenCooldown() > 0) {
            this.mv$setFrozenCooldown(this.mv$getFrozenCooldown() - 1);
        }
        if ((Integer)entity.getData(DataAttachmentRegistry.SUPER_STAR_COOLDOWN) > 0) {
            entity.setData(DataAttachmentRegistry.SUPER_STAR_COOLDOWN, (Object)((Integer)entity.getData(DataAttachmentRegistry.SUPER_STAR_COOLDOWN) - 1));
        }
        if ((Integer)entity.getData(DataAttachmentRegistry.SUPER_STAR_COOLDOWN) == 0 && ((Boolean)entity.getData(DataAttachmentRegistry.HAS_SUPER_STAR)).booleanValue()) {
            entity.setData(DataAttachmentRegistry.HAS_SUPER_STAR, (Object)false);
            entity.setData(DataAttachmentRegistry.PLAYED_SUPER_STAR_THEME, (Object)false);
        }
        if (((Boolean)entity.getData(DataAttachmentRegistry.HAS_SUPER_STAR)).booleanValue()) {
            this.mv$superStarKillEntity(entity);
            blockEntity = this.level();
            if (blockEntity instanceof ServerLevel) {
                ServerLevel serverWorld = (ServerLevel)blockEntity;
                ServerParticleUtils.spawnSingleParticleOnEntityRandomly((ParticleOptions)ParticleRegistry.RAINBOW_GLINT.get(), serverWorld, (Entity)entity);
            }
            ServerParticleUtils.spawnClientParticleTrail((ParticleOptions)ParticleRegistry.RAINBOW_GLINT.get(), (Entity)entity, true, 10, rand.nextDouble() * (double)entity.getBbHeight(), 0.1);
        }
        if (this.mv$hasDashMushroomBoost()) {
            this.mv$boostEntityParticles(entity.getVehicle(), entity);
        }
        if ((f5 = this.mv$getEyeHeightScale()) != this.mv$appliedEyeHeightScale) {
            this.mv$appliedEyeHeightScale = f5;
            this.refreshDimensions();
        }
        if ((f6 = this.mv$getHeightScale()) != this.mv$appliedHeightScale) {
            this.mv$appliedHeightScale = f6;
            entity.refreshDimensions();
        }
        if ((f7 = this.mv$getWidthScale()) != this.mv$appliedWidthScale) {
            this.mv$appliedWidthScale = f6;
            entity.refreshDimensions();
        }
    }

    @Override
    public void mv$clearAllPowerUps() {
        this.mv$setFireFlower(false);
        this.mv$setIceFlower(false);
    }

    @Override
    public boolean mv$hasSuperMushroom() {
        return this.mv$hasSuperMushroom;
    }

    @Override
    public void mv$setSuperMushroom(boolean hasSuperMushroom) {
        this.mv$hasSuperMushroom = hasSuperMushroom;
    }

    @Override
    public boolean mv$hasSuperMushroomOverride() {
        return this.mv$hasSuperMushroomOverride;
    }

    @Override
    public void mv$setMushroomOverride(boolean hasSuperMushroomOverride) {
        this.mv$hasSuperMushroomOverride = hasSuperMushroomOverride;
    }

    @Override
    public boolean mv$hasDashMushroomBoost() {
        return this.mv$hasDashMushroomBoost;
    }

    @Override
    public void mv$setDashMushroomBoost(boolean hasDashMushroomBoost) {
        this.mv$hasDashMushroomBoost = hasDashMushroomBoost;
    }

    @Override
    public boolean mv$hasMegaMushroom() {
        return this.mv$hasMegaMushroom;
    }

    @Override
    public void mv$setMegaMushroom(boolean hasMegaMushroom) {
        this.mv$hasMegaMushroom = hasMegaMushroom;
    }

    @Override
    public boolean mv$hasFireFlower() {
        return this.mv$hasFireFlower;
    }

    @Override
    public void mv$setFireFlower(boolean hasFireFlower) {
        this.mv$hasFireFlower = hasFireFlower;
    }

    @Override
    public boolean mv$hasIceFlower() {
        return this.mv$hasIceFlower;
    }

    @Override
    public void mv$setIceFlower(boolean hasIceFlower) {
        this.mv$hasIceFlower = hasIceFlower;
    }

    @Override
    public boolean mv$hasSmashedBlock() {
        return this.mv$hasSmashedBlock;
    }

    @Override
    public void mv$setSmashedBlock(boolean hasSmashedBlock) {
        this.mv$hasSmashedBlock = hasSmashedBlock;
    }

    @Override
    public int mv$getFireballCooldown() {
        return this.mv$fireballCooldown;
    }

    @Override
    public void mv$setFireballCooldown(int fireballCooldown) {
        this.mv$fireballCooldown = fireballCooldown;
    }

    @Override
    public int mv$getFireballCount() {
        return this.mv$fireballCount;
    }

    @Override
    public void mv$setFireballCount(int fireballCount) {
        this.mv$fireballCount = fireballCount;
    }

    @Override
    public int mv$getIceBallCooldown() {
        return this.mv$iceBallCooldown;
    }

    @Override
    public void mv$setIceBallCooldown(int iceBallCooldown) {
        this.mv$iceBallCooldown = iceBallCooldown;
    }

    @Override
    public int mv$getIceBallCount() {
        return this.mv$iceBallCount;
    }

    @Override
    public void mv$setIceBallCount(int iceBallCount) {
        this.mv$iceBallCount = iceBallCount;
    }

    @Override
    public int mv$getConsecutiveBounces() {
        return this.mv$consecutiveBounces;
    }

    @Override
    public void mv$setConsecutiveBounces(int consecutiveBounces) {
        this.mv$consecutiveBounces = consecutiveBounces;
    }

    @Override
    public int mv$getOneUpsRewarded() {
        return this.mv$oneUpsRewarded;
    }

    @Override
    public void mv$setOneUpsRewarded(int oneUpsRewarded) {
        this.mv$oneUpsRewarded = oneUpsRewarded;
    }

    @Override
    public boolean mv$doPreventWarp() {
        return this.mv$preventWarp;
    }

    @Override
    public void mv$setPreventWarp(boolean preventWarp) {
        this.mv$preventWarp = preventWarp;
    }

    @Override
    public int mv$getPreventWarpCooldown() {
        return this.mv$preventWarpCooldown;
    }

    @Override
    public void mv$setPreventWarpCooldown(int preventWarpCooldown) {
        this.mv$preventWarpCooldown = preventWarpCooldown;
    }

    @Override
    public int mv$getWarpCooldown() {
        return this.mv$warpCooldown;
    }

    @Override
    public void mv$setWarpCooldown(int warpCooldown) {
        this.mv$warpCooldown = warpCooldown;
    }

    @Override
    public int mv$getCheckpointFlagCooldown() {
        return this.mv$checkpointFlagCooldown;
    }

    @Override
    public void mv$setCheckpointFlagCooldown(int checkpointFlagCooldown) {
        this.mv$checkpointFlagCooldown = checkpointFlagCooldown;
    }

    @Override
    public int mv$getFreezeImmunityCooldown() {
        return this.mv$freezeImmunityCooldown;
    }

    @Override
    public void mv$setFreezeImmunityCooldown(int freezeImmunityCooldown) {
        this.mv$freezeImmunityCooldown = freezeImmunityCooldown;
    }

    @Override
    public int mv$getFrozenCooldown() {
        return this.mv$frozenCooldown;
    }

    @Override
    public void mv$setFrozenCooldown(int frozenCooldown) {
        this.mv$frozenCooldown = frozenCooldown;
    }

    @Unique
    private void mv$boostEntityParticles(Entity vehicle, LivingEntity entity) {
        double speed = this.getDeltaMovement().horizontalDistance();
        double minimumBoostSpeed = 0.3;
        if (vehicle != null) {
            ServerLevel serverWorld;
            Level level;
            speed = vehicle.getDeltaMovement().horizontalDistance();
            if (vehicle instanceof Boat && speed > 0.0) {
                level = vehicle.level();
                if (level instanceof ServerLevel) {
                    serverWorld = (ServerLevel)level;
                    ServerParticleUtils.spawnSingleParticleOnEntityRandomly((ParticleOptions)ParticleRegistry.POWERED_UP.get(), serverWorld, vehicle);
                    ServerParticleUtils.spawnParticleTrail((ParticleOptions)ParticleRegistry.SUSPENDED_FIRE.get(), serverWorld, vehicle, true, 10, 0.1);
                }
                if (vehicle.level().isClientSide) {
                    ServerParticleUtils.spawnClientParticleTrail((ParticleOptions)ParticleRegistry.POWERED_UP.get(), vehicle, true, 5, 0.1, 0.0);
                    ServerParticleUtils.spawnClientParticleTrail((ParticleOptions)ParticleRegistry.SUSPENDED_FIRE.get(), vehicle, true, 10, 0.1, 0.0);
                }
            }
            if (speed >= minimumBoostSpeed) {
                if (vehicle.level().isClientSide) {
                    ServerParticleUtils.spawnClientParticleTrail((ParticleOptions)ParticleRegistry.POWERED_UP.get(), vehicle, true, 5, 0.1, 0.0);
                    ServerParticleUtils.spawnClientParticleTrail((ParticleOptions)ParticleRegistry.SUSPENDED_FIRE.get(), vehicle, true, 10, 0.1, 0.0);
                } else {
                    level = vehicle.level();
                    if (level instanceof ServerLevel) {
                        serverWorld = (ServerLevel)level;
                        if (!(entity instanceof Player)) {
                            ServerParticleUtils.spawnSingleParticleOnEntityRandomly((ParticleOptions)ParticleRegistry.POWERED_UP.get(), serverWorld, vehicle);
                            ServerParticleUtils.spawnParticleTrail((ParticleOptions)ParticleRegistry.SUSPENDED_FIRE.get(), serverWorld, vehicle, true, 10, 0.1);
                        }
                    }
                }
            } else {
                this.mv$setDashMushroomBoost(false);
            }
        } else if (speed >= minimumBoostSpeed) {
            if (entity.level().isClientSide) {
                ServerParticleUtils.spawnClientParticleTrail((ParticleOptions)ParticleRegistry.POWERED_UP.get(), (Entity)entity, true, 5, 0.1, 0.0);
                ServerParticleUtils.spawnClientParticleTrail((ParticleOptions)ParticleRegistry.SUSPENDED_FIRE.get(), (Entity)entity, true, 10, 0.1, 0.0);
            } else {
                Level level = entity.level();
                if (level instanceof ServerLevel) {
                    ServerLevel serverWorld = (ServerLevel)level;
                    ServerParticleUtils.spawnSingleParticleOnEntityRandomly((ParticleOptions)ParticleRegistry.POWERED_UP.get(), serverWorld, (Entity)entity);
                    ServerParticleUtils.spawnParticleTrail((ParticleOptions)ParticleRegistry.SUSPENDED_FIRE.get(), serverWorld, (Entity)entity, true, 10, 0.1);
                }
            }
        } else {
            this.mv$setDashMushroomBoost(false);
        }
    }

    @Unique
    private void mv$shellSmashBlock(BlockState stateNorth, LivingEntity entity, Level world, BlockPos posNorth, BlockState stateSouth, BlockPos posSouth, BlockState stateEast, BlockPos posEast, BlockState stateWest, BlockPos posWest) {
        KoopaShellEntity shell;
        if ((stateNorth.is(TagRegistry.SMASHABLE_BLOCKS) || stateNorth.getBlock() instanceof DecoratedPotBlock) && entity.getType().is(TagRegistry.CAN_SMASH_BLOCKS) && entity instanceof KoopaShellEntity) {
            shell = (KoopaShellEntity)entity;
            if (entity.getDeltaMovement().horizontalDistance() > 0.1 && !this.mv$hasSmashedBlock()) {
                this.mv$smashBlock(world, posNorth, stateNorth, entity);
                shell.bounceShell(world, Direction.NORTH);
            }
        }
        if ((stateSouth.is(TagRegistry.SMASHABLE_BLOCKS) || stateSouth.getBlock() instanceof DecoratedPotBlock) && entity.getType().is(TagRegistry.CAN_SMASH_BLOCKS) && entity instanceof KoopaShellEntity) {
            shell = (KoopaShellEntity)entity;
            if (entity.getDeltaMovement().horizontalDistance() > 0.1 && !this.mv$hasSmashedBlock()) {
                this.mv$smashBlock(world, posSouth, stateSouth, entity);
                shell.bounceShell(world, Direction.SOUTH);
            }
        }
        if ((stateEast.is(TagRegistry.SMASHABLE_BLOCKS) || stateEast.getBlock() instanceof DecoratedPotBlock) && entity.getType().is(TagRegistry.CAN_SMASH_BLOCKS) && entity instanceof KoopaShellEntity) {
            shell = (KoopaShellEntity)entity;
            if (entity.getDeltaMovement().horizontalDistance() > 0.1 && !this.mv$hasSmashedBlock()) {
                this.mv$smashBlock(world, posEast, stateEast, entity);
                shell.bounceShell(world, Direction.EAST);
            }
        }
        if ((stateWest.is(TagRegistry.SMASHABLE_BLOCKS) || stateWest.getBlock() instanceof DecoratedPotBlock) && entity.getType().is(TagRegistry.CAN_SMASH_BLOCKS) && entity instanceof KoopaShellEntity) {
            shell = (KoopaShellEntity)entity;
            if (entity.getDeltaMovement().horizontalDistance() > 0.1 && !this.mv$hasSmashedBlock()) {
                this.mv$smashBlock(world, posWest, stateWest, entity);
                shell.bounceShell(world, Direction.WEST);
            }
        }
    }

    @Unique
    private void mv$shellBonkBlock(BlockState stateNorth, LivingEntity entity, Level world, BlockPos posNorth, BlockState stateSouth, BlockPos posSouth, BlockState stateEast, BlockPos posEast, BlockState stateWest, BlockPos posWest) {
        if (stateNorth.is(TagRegistry.BONKABLE_BLOCKS) && entity.getType().is(TagRegistry.CAN_BONK_BLOCKS) && entity instanceof KoopaShellEntity && entity.getDeltaMovement().horizontalDistance() > 0.1) {
            if (stateNorth.hasProperty((Property)QuestionBlock.EMPTY) && ((Boolean)stateNorth.getValue((Property)QuestionBlock.EMPTY)).booleanValue()) {
                world.playSound(null, posNorth, (SoundEvent)SoundRegistry.BLOCK_BONK.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            } else {
                world.playSound(null, posNorth, (SoundEvent)SoundRegistry.BLOCK_BONK.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
        if (stateSouth.is(TagRegistry.BONKABLE_BLOCKS) && entity.getType().is(TagRegistry.CAN_BONK_BLOCKS) && entity instanceof KoopaShellEntity && entity.getDeltaMovement().horizontalDistance() > 0.1) {
            if (stateSouth.hasProperty((Property)QuestionBlock.EMPTY) && ((Boolean)stateSouth.getValue((Property)QuestionBlock.EMPTY)).booleanValue()) {
                world.playSound(null, posSouth, (SoundEvent)SoundRegistry.BLOCK_BONK.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            } else {
                world.playSound(null, posSouth, (SoundEvent)SoundRegistry.BLOCK_BONK.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
        if (stateEast.is(TagRegistry.BONKABLE_BLOCKS) && entity.getType().is(TagRegistry.CAN_BONK_BLOCKS) && entity instanceof KoopaShellEntity && entity.getDeltaMovement().horizontalDistance() > 0.1) {
            if (stateEast.hasProperty((Property)QuestionBlock.EMPTY) && ((Boolean)stateEast.getValue((Property)QuestionBlock.EMPTY)).booleanValue()) {
                world.playSound(null, posEast, (SoundEvent)SoundRegistry.BLOCK_BONK.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            } else {
                world.playSound(null, posEast, (SoundEvent)SoundRegistry.BLOCK_BONK.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
        if (stateWest.is(TagRegistry.BONKABLE_BLOCKS) && entity.getType().is(TagRegistry.CAN_BONK_BLOCKS) && entity instanceof KoopaShellEntity && entity.getDeltaMovement().horizontalDistance() > 0.1) {
            if (stateWest.hasProperty((Property)QuestionBlock.EMPTY) && ((Boolean)stateWest.getValue((Property)QuestionBlock.EMPTY)).booleanValue()) {
                world.playSound(null, posWest, (SoundEvent)SoundRegistry.BLOCK_BONK.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            } else {
                world.playSound(null, posWest, (SoundEvent)SoundRegistry.BLOCK_BONK.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    @Unique
    private void mv$shellHitQuestionBlock(Level world, BlockPos posNorth, LivingEntity entity, BlockPos posSouth, BlockPos posEast, BlockPos posWest) {
        QuestionBlockEntity questionBlockEntity;
        BlockEntity blockEntity = world.getBlockEntity(posNorth);
        if (blockEntity instanceof QuestionBlockEntity) {
            questionBlockEntity = (QuestionBlockEntity)blockEntity;
            if (entity instanceof KoopaShellEntity && entity.getType().is(TagRegistry.CAN_HIT_QUESTION_BLOCKS) && entity.getDeltaMovement().horizontalDistance() > 0.1) {
                this.mv$hitQuestionBlock(world, posNorth, questionBlockEntity);
            }
        }
        if ((blockEntity = world.getBlockEntity(posSouth)) instanceof QuestionBlockEntity) {
            questionBlockEntity = (QuestionBlockEntity)blockEntity;
            if (entity instanceof KoopaShellEntity && entity.getType().is(TagRegistry.CAN_HIT_QUESTION_BLOCKS) && entity.getDeltaMovement().horizontalDistance() > 0.1) {
                this.mv$hitQuestionBlock(world, posSouth, questionBlockEntity);
            }
        }
        if ((blockEntity = world.getBlockEntity(posEast)) instanceof QuestionBlockEntity) {
            questionBlockEntity = (QuestionBlockEntity)blockEntity;
            if (entity instanceof KoopaShellEntity && entity.getType().is(TagRegistry.CAN_HIT_QUESTION_BLOCKS) && entity.getDeltaMovement().horizontalDistance() > 0.1) {
                this.mv$hitQuestionBlock(world, posEast, questionBlockEntity);
            }
        }
        if ((blockEntity = world.getBlockEntity(posWest)) instanceof QuestionBlockEntity) {
            questionBlockEntity = (QuestionBlockEntity)blockEntity;
            if (entity instanceof KoopaShellEntity && entity.getType().is(TagRegistry.CAN_HIT_QUESTION_BLOCKS) && entity.getDeltaMovement().horizontalDistance() > 0.1) {
                this.mv$hitQuestionBlock(world, posWest, questionBlockEntity);
            }
        }
    }

    @Unique
    private void mv$characterAbilities(LivingEntity entity) {
        AttributeInstance jumpAttribute = entity.getAttribute(Attributes.JUMP_STRENGTH);
        AttributeInstance safeFallAttribute = entity.getAttribute(Attributes.SAFE_FALL_DISTANCE);
        if (jumpAttribute != null) {
            double normalJumpBoost = 0.4;
            double runningJumpBoost = 0.5;
            boolean hasJumpModifier = jumpAttribute.getModifier(AttributesRegistry.JUMP_BOOST) != null;
            boolean hasRunningJumpModifier = jumpAttribute.getModifier(AttributesRegistry.RUNNING_JUMP_BOOST) != null;
            boolean isRunning = entity.isSprinting();
            if (this.mv$hasPeachCostume(entity)) {
                normalJumpBoost = 0.3;
                runningJumpBoost = 0.4;
            }
            if (this.mv$hasLuigiCostume(entity)) {
                normalJumpBoost = 0.5;
                runningJumpBoost = 0.6;
            }
            if (!entity.isShiftKeyDown() && (this.mv$hasMarioCostume(entity) || this.mv$hasLuigiCostume(entity) || this.mv$hasPeachCostume(entity))) {
                if (isRunning) {
                    if (!hasRunningJumpModifier) {
                        jumpAttribute.addPermanentModifier(new AttributeModifier(AttributesRegistry.RUNNING_JUMP_BOOST, runningJumpBoost, AttributeModifier.Operation.ADD_VALUE));
                    }
                    if (hasJumpModifier) {
                        jumpAttribute.removeModifier(AttributesRegistry.JUMP_BOOST);
                    }
                } else {
                    if (!hasJumpModifier) {
                        jumpAttribute.addPermanentModifier(new AttributeModifier(AttributesRegistry.JUMP_BOOST, normalJumpBoost, AttributeModifier.Operation.ADD_VALUE));
                    }
                    if (hasRunningJumpModifier) {
                        jumpAttribute.removeModifier(AttributesRegistry.RUNNING_JUMP_BOOST);
                    }
                }
            } else {
                if (hasRunningJumpModifier) {
                    jumpAttribute.removeModifier(AttributesRegistry.RUNNING_JUMP_BOOST);
                }
                if (hasJumpModifier) {
                    jumpAttribute.removeModifier(AttributesRegistry.JUMP_BOOST);
                }
            }
        }
        if (safeFallAttribute != null) {
            if (this.mv$hasMarioCostume(entity) || this.mv$hasLuigiCostume(entity) || this.mv$hasPeachCostume(entity)) {
                boolean hasSafeFallModifier;
                boolean bl = hasSafeFallModifier = safeFallAttribute.getModifier(AttributesRegistry.SAFE_FALL_DISTANCE) != null;
                if (!hasSafeFallModifier) {
                    safeFallAttribute.addPermanentModifier(new AttributeModifier(AttributesRegistry.SAFE_FALL_DISTANCE, 7.0, AttributeModifier.Operation.ADD_VALUE));
                }
            } else {
                safeFallAttribute.removeModifier(AttributesRegistry.SAFE_FALL_DISTANCE);
            }
        }
        if (this.mv$hasPeachCostume(entity)) {
            Vec3 motion = entity.getDeltaMovement();
            if (motion.y < 0.0) {
                entity.setDeltaMovement(motion.x, motion.y * 0.7, motion.z);
            }
        }
    }

    @ModifyReturnValue(method={"getArmorValue"}, at={@At(value="RETURN")})
    private int getArmorValue(int original) {
        LivingEntity entity = (LivingEntity)this;
        AccessoriesCapability capability = AccessoriesCapability.get((LivingEntity)entity);
        if (capability != null) {
            AttributeInstance knockbackAttribute;
            AccessoriesContainer[] accessorySlots = new AccessoriesContainer[]{capability.getContainer(SlotTypeLoader.getSlotType((LivingEntity)entity, (String)"costume_hat")), capability.getContainer(SlotTypeLoader.getSlotType((LivingEntity)entity, (String)"costume_shirt")), capability.getContainer(SlotTypeLoader.getSlotType((LivingEntity)entity, (String)"costume_pants")), capability.getContainer(SlotTypeLoader.getSlotType((LivingEntity)entity, (String)"costume_shoes"))};
            int totalExtraArmor = 0;
            float totalToughness = 0.0f;
            float totalKnockbackResistance = 0.0f;
            for (AccessoriesContainer container : accessorySlots) {
                Item item;
                if (container == null) {
                    return original;
                }
                ItemStack stack = container.getAccessories().getItem(0);
                if (stack.isEmpty() || !((item = stack.getItem()) instanceof ArmorItem)) continue;
                ArmorItem accessoryArmor = (ArmorItem)item;
                ArmorMaterial material = (ArmorMaterial)accessoryArmor.getMaterial().value();
                totalExtraArmor += material.getDefense(accessoryArmor.getType()) / 2;
                totalToughness += material.toughness() / 2.0f;
                totalKnockbackResistance += material.knockbackResistance() / 2.0f;
            }
            AttributeInstance toughnessAttribute = entity.getAttribute(Attributes.ARMOR_TOUGHNESS);
            if (toughnessAttribute != null) {
                boolean hasModifier;
                boolean bl = hasModifier = toughnessAttribute.getModifier(AttributesRegistry.COSTUME_ARMOR_TOUGHNESS) != null;
                if (totalToughness > 0.0f) {
                    AttributeModifier toughnessModifier = new AttributeModifier(AttributesRegistry.COSTUME_ARMOR_TOUGHNESS, (double)totalToughness, AttributeModifier.Operation.ADD_VALUE);
                    if (!hasModifier) {
                        toughnessAttribute.addPermanentModifier(toughnessModifier);
                    }
                } else if (hasModifier) {
                    toughnessAttribute.removeModifier(AttributesRegistry.COSTUME_ARMOR_TOUGHNESS);
                }
            }
            if ((knockbackAttribute = entity.getAttribute(Attributes.KNOCKBACK_RESISTANCE)) != null) {
                boolean hasModifier;
                boolean bl = hasModifier = knockbackAttribute.getModifier(AttributesRegistry.COSTUME_ARMOR_KNOCKBACK_RESISTANCE) != null;
                if (totalKnockbackResistance > 0.0f) {
                    AttributeModifier knockbackModifier = new AttributeModifier(AttributesRegistry.COSTUME_ARMOR_KNOCKBACK_RESISTANCE, (double)totalKnockbackResistance, AttributeModifier.Operation.ADD_VALUE);
                    if (!hasModifier) {
                        knockbackAttribute.addPermanentModifier(knockbackModifier);
                    }
                } else if (hasModifier) {
                    knockbackAttribute.removeModifier(AttributesRegistry.COSTUME_ARMOR_KNOCKBACK_RESISTANCE);
                }
            }
            return original + totalExtraArmor;
        }
        return original;
    }

    @ModifyReturnValue(method={"checkTotemDeathProtection"}, at={@At(value="RETURN")})
    private boolean checkTotemDeathProtection(boolean original, DamageSource source) {
        SoundSource soundSource;
        LivingEntity livingEntity = (LivingEntity)this;
        SoundSource soundSource2 = soundSource = livingEntity instanceof Player ? SoundSource.PLAYERS : SoundSource.NEUTRAL;
        if (!source.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            ItemStack stackCharm2;
            AccessoriesContainer containerCharm;
            AccessoriesCapability capability;
            ItemStack stackInHand;
            ItemStack stack = livingEntity.getOffhandItem();
            for (InteractionHand hand : InteractionHand.values()) {
                stackInHand = livingEntity.getItemInHand(hand);
                if (!(stackInHand.getItem() instanceof OneUpMushroomItem)) continue;
                stack = stackInHand.copy();
                stackInHand.shrink(1);
                break;
            }
            if ((capability = AccessoriesCapability.get((LivingEntity)livingEntity)) != null && (containerCharm = capability.getContainer(SlotTypeLoader.getSlotType((LivingEntity)livingEntity, (String)"charm"))) != null && (stackCharm2 = containerCharm.getAccessories().getItem(0)).getItem() instanceof OneUpMushroomItem) {
                this.level().playSound(null, livingEntity.blockPosition(), (SoundEvent)SoundRegistry.ONE_UP_COLLECTED.get(), soundSource, 1.0f, 1.0f);
                livingEntity.setHealth(1.0f);
                livingEntity.heal(((Double)ConfigRegistry.ONE_UP_HEALTH_HEALED.get()).floatValue());
                stackCharm2.shrink(1);
                stackInHand = livingEntity.level();
                if (stackInHand instanceof ServerLevel) {
                    ServerLevel serverWorld = (ServerLevel)stackInHand;
                    ServerParticleUtils.spawnPoweredUpParticles((ParticleOptions)ParticleRegistry.POWERED_UP.get(), serverWorld, (Entity)livingEntity, 25);
                    ServerParticleUtils.spawnRewardParticle((ParticleOptions)ParticleRegistry.ONE_UP.get(), serverWorld, (Entity)livingEntity, 1.0);
                    if (livingEntity instanceof ServerPlayer) {
                        ServerPlayer player = (ServerPlayer)livingEntity;
                        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new OneUpPayload(true), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    }
                }
                if (livingEntity instanceof ServerPlayer) {
                    ServerPlayer serverplayer = (ServerPlayer)livingEntity;
                    serverplayer.awardStat(Stats.ITEM_USED.get((Object)((Item)ItemRegistry.ONE_UP_MUSHROOM.get())), 1);
                    CriteriaTriggers.USED_TOTEM.trigger(serverplayer, stack);
                    this.gameEvent((Holder)GameEvent.ITEM_INTERACT_FINISH);
                }
                return true;
            }
            if (!stack.isEmpty() && stack.getItem() instanceof OneUpMushroomItem) {
                this.level().playSound(null, livingEntity.blockPosition(), (SoundEvent)SoundRegistry.ONE_UP_COLLECTED.get(), soundSource, 1.0f, 1.0f);
                livingEntity.setHealth(1.0f);
                livingEntity.heal(((Double)ConfigRegistry.ONE_UP_HEALTH_HEALED.get()).floatValue());
                stack.shrink(1);
                Level stackCharm2 = livingEntity.level();
                if (stackCharm2 instanceof ServerLevel) {
                    ServerLevel serverWorld = (ServerLevel)stackCharm2;
                    ServerParticleUtils.spawnPoweredUpParticles((ParticleOptions)ParticleRegistry.POWERED_UP.get(), serverWorld, (Entity)livingEntity, 25);
                    ServerParticleUtils.spawnRewardParticle((ParticleOptions)ParticleRegistry.ONE_UP.get(), serverWorld, (Entity)livingEntity, 1.0);
                    if (livingEntity instanceof ServerPlayer) {
                        ServerPlayer player = (ServerPlayer)livingEntity;
                        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new OneUpPayload(true), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    }
                }
                if (livingEntity instanceof ServerPlayer) {
                    ServerPlayer serverplayer = (ServerPlayer)livingEntity;
                    serverplayer.awardStat(Stats.ITEM_USED.get((Object)((Item)ItemRegistry.ONE_UP_MUSHROOM.get())), 1);
                    CriteriaTriggers.USED_TOTEM.trigger(serverplayer, stack);
                    this.gameEvent((Holder)GameEvent.ITEM_INTERACT_FINISH);
                }
                return true;
            }
        }
        return original;
    }

    @ModifyReturnValue(method={"isDamageSourceBlocked"}, at={@At(value="RETURN")})
    public boolean isDamageSourceBlocked(boolean original, DamageSource source) {
        Vec3 vec32;
        LivingEntity livingEntity = (LivingEntity)this;
        if (source.is(TagRegistry.SHIELD_BLOCKS) && livingEntity.isBlocking() && (vec32 = source.getSourcePosition()) != null) {
            return true;
        }
        return original;
    }

    @ModifyReturnValue(method={"createLivingAttributes"}, at={@At(value="RETURN")})
    private static AttributeSupplier.Builder createLivingAttributes(AttributeSupplier.Builder original) {
        original.add(AttributesRegistry.EYE_HEIGHT_SCALE);
        original.add(AttributesRegistry.HEIGHT_SCALE);
        original.add(AttributesRegistry.WIDTH_SCALE);
        return original;
    }

    @ModifyReturnValue(method={"getDimensions"}, at={@At(value="TAIL")})
    private EntityDimensions getDimensions(EntityDimensions original, Pose pose) {
        float heightScale = this.mv$getHeightScale() > 1.0f ? this.mv$getHeightScale() / 2.0f : (this.mv$getHeightScale() == 1.0f ? this.mv$getHeightScale() : this.mv$getHeightScale());
        float eyeHeightScale = this.mv$getEyeHeightScale() > 1.0f ? original.eyeHeight() * this.mv$getEyeHeightScale() / 2.0f : (this.mv$getEyeHeightScale() == 1.0f ? original.eyeHeight() * this.mv$getEyeHeightScale() : original.eyeHeight() * this.mv$getEyeHeightScale());
        float widthScale = this.mv$getWidthScale() > 1.0f ? this.mv$getWidthScale() / 2.0f : (this.mv$getWidthScale() == 1.0f ? this.mv$getWidthScale() : this.mv$getWidthScale());
        if (pose != Pose.SLEEPING) {
            return original.scale(widthScale, heightScale).withEyeHeight(eyeHeightScale);
        }
        return original;
    }

    @Inject(method={"jumpFromGround"}, at={@At(value="HEAD")})
    private void jumpFromGround(CallbackInfo ci) {
        LivingEntity entity = (LivingEntity)this;
        AttributeInstance speedAttribute = entity.getAttribute(Attributes.MOVEMENT_SPEED);
        if (speedAttribute != null && speedAttribute.hasModifier(SLOWDOWN_MODIFIER)) {
            speedAttribute.removeModifier(SLOWDOWN_MODIFIER);
        }
    }

    @Inject(method={"canFreeze"}, at={@At(value="HEAD")}, cancellable=true)
    private void canFreeze(CallbackInfoReturnable<Boolean> cir) {
        LivingEntity entity = (LivingEntity)this;
        AccessoriesCapability capability = AccessoriesCapability.get((LivingEntity)entity);
        if (capability != null) {
            boolean hasFreezeImmunity;
            AccessoriesContainer containerHat = capability.getContainer(SlotTypeLoader.getSlotType((LivingEntity)entity, (String)"costume_hat"));
            AccessoriesContainer containerShirt = capability.getContainer(SlotTypeLoader.getSlotType((LivingEntity)entity, (String)"costume_shirt"));
            AccessoriesContainer containerPants = capability.getContainer(SlotTypeLoader.getSlotType((LivingEntity)entity, (String)"costume_pants"));
            AccessoriesContainer containerShoes = capability.getContainer(SlotTypeLoader.getSlotType((LivingEntity)entity, (String)"costume_shoes"));
            boolean bl = hasFreezeImmunity = containerHat != null && containerHat.getAccessories().getItem(0).is(ItemTags.FREEZE_IMMUNE_WEARABLES) || containerShirt != null && containerShirt.getAccessories().getItem(0).is(ItemTags.FREEZE_IMMUNE_WEARABLES) || containerPants != null && containerPants.getAccessories().getItem(0).is(ItemTags.FREEZE_IMMUNE_WEARABLES) || containerShoes != null && containerShoes.getAccessories().getItem(0).is(ItemTags.FREEZE_IMMUNE_WEARABLES);
            if (hasFreezeImmunity) {
                cir.setReturnValue((Object)false);
            }
        }
    }

    @Inject(method={"handleEntityEvent"}, at={@At(value="HEAD")})
    private void handleEntityEvent(byte id, CallbackInfo info) {
        LivingEntity entity = (LivingEntity)this;
        RandomSource random = entity.getRandom();
        if (id == 109) {
            ParticleUtils.spawnParticlesOnBlockFaces((Level)entity.level(), (BlockPos)BlockPos.containing((double)(entity.getX() + 0.5), (double)(entity.getY() + (double)entity.getBbHeight()), (double)(entity.getZ() + 0.5)), (ParticleOptions)((ParticleOptions)ParticleRegistry.COIN_GLINT.get()), (IntProvider)UniformInt.of((int)2, (int)3));
        } else if (id == 110) {
            ParticleUtils.spawnParticlesOnBlockFaces((Level)entity.level(), (BlockPos)BlockPos.containing((double)(entity.getX() + 0.5), (double)(entity.getY() + (double)entity.getBbHeight()), (double)(entity.getZ() + 0.5)), (ParticleOptions)((ParticleOptions)ParticleRegistry.COIN_GLINT.get()), (IntProvider)UniformInt.of((int)1, (int)1));
        } else if (id == 111) {
            this.level().addParticle((ParticleOptions)ParticleTypes.CRIT, entity.getX(), entity.getY() + (double)entity.getEyeHeight(), entity.getZ(), 0.0, 1.0, 0.0);
        } else if (id == 112) {
            ParticleUtils.spawnParticlesOnBlockFaces((Level)entity.level(), (BlockPos)this.blockPosition(), (ParticleOptions)((ParticleOptions)ParticleRegistry.GLOWING_STAR.get()), (IntProvider)UniformInt.of((int)1, (int)1));
        } else if (id == 113) {
            ParticleUtils.spawnParticlesOnBlockFaces((Level)entity.level(), (BlockPos)this.blockPosition(), (ParticleOptions)((ParticleOptions)ParticleRegistry.COIN_GLINT.get()), (IntProvider)UniformInt.of((int)1, (int)1));
        } else if (id == 119) {
            this.mv$spawnPowerUpParticles((Entity)entity, (ParticleOptions)ParticleRegistry.COIN_GLINT.get(), 15);
        } else if (id == 120) {
            for (int i = 0; i < 100; ++i) {
                this.level().addParticle((ParticleOptions)ParticleTypes.ENCHANT, entity.getRandomX(0.5), entity.getRandomY(), entity.getRandomZ(0.5), (random.nextDouble() - 0.5) * 2.0, -random.nextDouble(), (random.nextDouble() - 0.5) * 2.0);
            }
        } else if (id == 123) {
            this.mv$spawnPowerUpParticles((Entity)entity, (ParticleOptions)ParticleRegistry.FIRE_POWERED_UP.get(), 15);
        } else if (id == 124) {
            this.mv$spawnPowerUpParticles((Entity)entity, (ParticleOptions)ParticleRegistry.POWERED_UP.get(), 25);
        } else if (id == 125) {
            if (this.level().isClientSide) {
                ParticleUtils.spawnParticlesOnBlockFaces((Level)this.level(), (BlockPos)this.blockPosition().above(Math.round(this.getBbHeight())).above(), (ParticleOptions)((ParticleOptions)ParticleRegistry.COIN_GLINT.get()), (IntProvider)UniformInt.of((int)1, (int)1));
            }
        } else if (id == 126) {
            if (this.level().isClientSide) {
                this.level().addParticle((ParticleOptions)ParticleRegistry.ONE_UP.get(), entity.getX(), entity.getY() + (double)entity.getBbHeight(), entity.getZ(), 0.0, 1.0, 0.0);
            }
        } else {
            super.handleEntityEvent(id);
        }
    }

    @Unique
    public float mv$getEyeHeightScale() {
        LivingEntity entity = (LivingEntity)this;
        AttributeMap attributemap = entity.getAttributes();
        return attributemap == null ? 1.0f : this.mv$sanitizeScales((float)attributemap.getValue(AttributesRegistry.EYE_HEIGHT_SCALE));
    }

    @Unique
    public float mv$getHeightScale() {
        LivingEntity entity = (LivingEntity)this;
        AttributeMap attributemap = entity.getAttributes();
        return attributemap == null ? 1.0f : this.mv$sanitizeScales((float)attributemap.getValue(AttributesRegistry.HEIGHT_SCALE));
    }

    @Unique
    public float mv$getWidthScale() {
        LivingEntity entity = (LivingEntity)this;
        AttributeMap attributemap = entity.getAttributes();
        return attributemap == null ? 1.0f : this.mv$sanitizeScales((float)attributemap.getValue(AttributesRegistry.WIDTH_SCALE));
    }

    @Unique
    public float mv$sanitizeScales(float scale) {
        return scale;
    }

    @Unique
    public void mv$spawnPowerUpParticles(Entity entity, ParticleOptions particleType, int avgAmount) {
        if (entity.level().isClientSide) {
            float scaleFactor = entity.getBbWidth();
            int numParticles = (int)(scaleFactor * (float)avgAmount);
            double radius = entity.getBbWidth() / 2.0f;
            for (int i = 0; i < numParticles; ++i) {
                double angle = Math.PI * 2 * (double)i / (double)numParticles;
                double offsetX = Math.cos(angle) * radius;
                double offsetY = entity.getBbHeight();
                double offsetZ = Math.sin(angle) * radius;
                double x = entity.getX() + offsetX;
                double y = entity.getY();
                double z = entity.getZ() + offsetZ;
                this.level().addParticle(particleType, x, y + offsetY - 0.2, z, 0.0, 1.0, 0.0);
                this.level().addParticle(particleType, x, y + offsetY / 2.0, z, 0.0, 1.0, 0.0);
                this.level().addParticle(particleType, x, y + 0.2, z, 0.0, 1.0, 0.0);
            }
        }
    }

    @Unique
    public void mv$mushroomScale(LivingEntity entity) {
        boolean shouldReset;
        Level world = entity.level();
        AttributeInstance eyeHeightScale = entity.getAttribute(AttributesRegistry.EYE_HEIGHT_SCALE);
        AttributeInstance heightScale = entity.getAttribute(AttributesRegistry.HEIGHT_SCALE);
        AttributeInstance widthScale = entity.getAttribute(AttributesRegistry.WIDTH_SCALE);
        boolean hasSuperMushroom = this.mv$hasSuperMushroom();
        float health = entity.getHealth();
        float scalingSpeed = 0.1f;
        double targetEyeHeightScale = hasSuperMushroom ? 1.0 : 0.5;
        double targetHeightScale = hasSuperMushroom ? 1.0 : 0.5;
        double targetWidthScale = hasSuperMushroom ? 1.0 : 0.75;
        boolean isPlayer = entity instanceof Player;
        boolean shouldShrink = !hasSuperMushroom && !entity.getType().is(TagRegistry.DAMAGE_CANNOT_SHRINK) && (isPlayer && this.mv$hasSuperMushroomOverride() || isPlayer && (double)health <= (Double)ConfigRegistry.SHRINK_PLAYERS_AT_HEALTH.get() && ((Boolean)ConfigRegistry.DAMAGE_SHRINKS_PLAYERS.get() != false || world.getGameRules().getBoolean(Marioverse.DAMAGE_SHRINKS_PLAYERS)) || !isPlayer && this.mv$hasSuperMushroomOverride() || !isPlayer && (double)health <= (double)entity.getMaxHealth() * (Double)ConfigRegistry.SHRINK_MOBS_AT_HEALTH.get() && ((Boolean)ConfigRegistry.DAMAGE_SHRINKS_ALL_MOBS.get() != false || world.getGameRules().getBoolean(Marioverse.DAMAGE_SHRINKS_ALL_MOBS)));
        boolean bl = shouldReset = hasSuperMushroom && (isPlayer && this.mv$hasSuperMushroomOverride() || isPlayer && (double)health > (Double)ConfigRegistry.SHRINK_PLAYERS_AT_HEALTH.get() && ((Boolean)ConfigRegistry.DAMAGE_SHRINKS_PLAYERS.get() != false || world.getGameRules().getBoolean(Marioverse.DAMAGE_SHRINKS_PLAYERS)) || !isPlayer && this.mv$hasSuperMushroomOverride() || !isPlayer && (double)health > (double)entity.getMaxHealth() * (Double)ConfigRegistry.SHRINK_MOBS_AT_HEALTH.get() && ((Boolean)ConfigRegistry.DAMAGE_SHRINKS_ALL_MOBS.get() != false || world.getGameRules().getBoolean(Marioverse.DAMAGE_SHRINKS_ALL_MOBS)));
        if (shouldShrink && this.mv$currentEyeHeightScale != targetEyeHeightScale && this.mv$currentHeightScale != targetHeightScale && this.mv$currentWidthScale != targetWidthScale) {
            if (entity.getLastDamageSource() != null && entity.isDamageSourceBlocked(entity.getLastDamageSource())) {
                return;
            }
            this.mv$updateScale(eyeHeightScale, this.mv$currentEyeHeightScale, targetEyeHeightScale, scalingSpeed, v -> {
                this.mv$currentEyeHeightScale = v;
            });
            this.mv$updateScale(heightScale, this.mv$currentHeightScale, targetHeightScale, scalingSpeed, v -> {
                this.mv$currentHeightScale = v;
            });
            this.mv$updateScale(widthScale, this.mv$currentWidthScale, targetWidthScale, scalingSpeed, v -> {
                this.mv$currentWidthScale = v;
            });
            if (!this.mv$playedDamagedSound && !this.mv$hasSuperMushroomOverride()) {
                this.mv$playedDamagedSound = true;
                SoundSource soundSource = isPlayer ? SoundSource.PLAYERS : SoundSource.NEUTRAL;
                world.playSound(null, entity.blockPosition(), (SoundEvent)SoundRegistry.DAMAGE_TAKEN.get(), soundSource, 1.0f, 1.0f);
            }
        }
        if (shouldReset && this.mv$currentEyeHeightScale != targetEyeHeightScale && this.mv$currentHeightScale != targetHeightScale && this.mv$currentWidthScale != targetWidthScale) {
            this.mv$playedDamagedSound = false;
            if (eyeHeightScale != null && eyeHeightScale.getValue() != 1.0) {
                this.mv$updateScale(eyeHeightScale, this.mv$currentEyeHeightScale, targetEyeHeightScale, scalingSpeed, v -> {
                    this.mv$currentEyeHeightScale = v;
                });
            }
            if (heightScale != null && heightScale.getValue() != 1.0) {
                this.mv$updateScale(heightScale, this.mv$currentHeightScale, targetHeightScale, scalingSpeed, v -> {
                    this.mv$currentHeightScale = v;
                });
            }
            if (widthScale != null && widthScale.getValue() != 1.0) {
                this.mv$updateScale(widthScale, this.mv$currentWidthScale, targetWidthScale, scalingSpeed, v -> {
                    this.mv$currentWidthScale = v;
                });
            }
        }
    }

    @Unique
    private void mv$updateScale(AttributeInstance scaleAttribute, double currentScale, double targetScale, float scalingSpeed, Consumer<Double> setter) {
        ResourceLocation modifier = AttributesRegistry.DAMAGED_SCALE;
        if (scaleAttribute != null) {
            double lerpedScale = Mth.lerp((double)scalingSpeed, (double)currentScale, (double)targetScale);
            if (Math.abs(currentScale - targetScale) < 1.0E-4) {
                lerpedScale = targetScale;
            }
            if (scaleAttribute.hasModifier(modifier) && (Math.abs(lerpedScale - 1.0) < 1.0E-4 || targetScale == 1.0)) {
                scaleAttribute.removeModifier(modifier);
            }
            if (lerpedScale != targetScale) {
                scaleAttribute.removeModifier(modifier);
                scaleAttribute.addPermanentModifier(new AttributeModifier(modifier, lerpedScale - 1.0, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
                if (Math.abs(currentScale - targetScale) < 0.01) {
                    setter.accept(targetScale);
                } else {
                    setter.accept(lerpedScale);
                }
            }
        }
    }

    @Unique
    public void mv$hitQuestionBlock(Level world, BlockPos pos, QuestionBlockEntity questionBlockEntity) {
        LivingEntity entity = (LivingEntity)this;
        Block block = world.getBlockState(pos).getBlock();
        if (block instanceof QuestionBlock) {
            BlockState currentState;
            QuestionBlock questionBlock = (QuestionBlock)block;
            ItemStack storedItem = questionBlockEntity.getTheItem();
            if (!((Boolean)world.getBlockState(pos).getValue((Property)QuestionBlock.EMPTY)).booleanValue()) {
                LivingEntityMixin.mv$hitEntityAbove(pos, world, entity);
            }
            if (!storedItem.isEmpty() && !((Boolean)world.getBlockState(pos).getValue((Property)QuestionBlock.EMPTY)).booleanValue()) {
                BlockState stateAbove = world.getBlockState(pos.above());
                ItemStack coinItem = new ItemStack((ItemLike)stateAbove.getBlock().asItem());
                Block block2 = stateAbove.getBlock();
                if (block2 instanceof StarCoinBlock) {
                    StarCoinBlock starCoin = (StarCoinBlock)block2;
                    StarCoinBlock.collectCoin(starCoin, world, stateAbove, pos.above(), (Entity)entity, coinItem);
                } else if (stateAbove.getBlock() instanceof CoinBlock) {
                    CoinBlock.collectCoin(world, stateAbove, pos.above(), (Entity)entity, coinItem);
                }
                if (!world.isClientSide) {
                    questionBlock.spawnFromQuestionBlock(world, pos, storedItem, (Entity)entity, Boolean.FALSE, Boolean.TRUE);
                }
                if (world.getBlockState(pos).is(BlockTags.GUARDED_BY_PIGLINS) && entity instanceof Player) {
                    Player player = (Player)entity;
                    PiglinAi.angerNearbyPiglins((Player)player, (boolean)false);
                }
                if (world instanceof ServerLevel) {
                    ServerLevel serverWorld = (ServerLevel)world;
                    ServerParticleUtils.spawnParticlesOnBlockFace((ParticleOptions)ParticleTypes.CRIT, serverWorld, pos, Direction.DOWN, (IntProvider)UniformInt.of((int)3, (int)4), () -> ServerParticleUtils.getRandomSpeedRanges(world.getRandom()), 0.65);
                }
                QuestionBlock.playSounds(world, pos, storedItem);
                questionBlockEntity.splitTheItem(1);
                questionBlockEntity.setChanged();
            }
            if (storedItem.isEmpty() && !((Boolean)world.getBlockState(pos).getValue((Property)QuestionBlock.EMPTY)).booleanValue()) {
                currentState = world.getBlockState(pos);
                if (currentState.getBlock() instanceof QuestionBlock) {
                    world.setBlock(pos, (BlockState)currentState.setValue((Property)QuestionBlock.EMPTY, (Comparable)Boolean.TRUE), 3);
                }
                world.gameEvent((Entity)entity, (Holder)GameEvent.BLOCK_CHANGE, pos);
            }
            if (world.getBlockState(pos).getBlock() instanceof InvisibleQuestionBlock && ((Boolean)world.getBlockState(pos).getValue((Property)InvisibleQuestionBlock.INVISIBLE)).booleanValue()) {
                currentState = world.getBlockState(pos);
                world.setBlock(pos, (BlockState)currentState.setValue((Property)InvisibleQuestionBlock.INVISIBLE, (Comparable)Boolean.FALSE), 3);
                world.gameEvent((Entity)entity, (Holder)GameEvent.BLOCK_CHANGE, pos);
            }
        }
    }

    @Unique
    private void mv$smashBlock(Level world, BlockPos pos, BlockState state, LivingEntity entity) {
        BlockState stateAbove = world.getBlockState(pos.above());
        ItemStack coinItem = new ItemStack((ItemLike)stateAbove.getBlock().asItem());
        LivingEntityMixin.mv$hitEntityAbove(pos, world, entity);
        if (this.mv$hasSuperMushroom()) {
            if (state.getBlock() instanceof SlabBlock) {
                if (state.getValue((Property)SlabBlock.TYPE) == SlabType.DOUBLE) {
                    world.setBlock(pos, (BlockState)state.setValue((Property)SlabBlock.TYPE, (Comparable)SlabType.TOP), 3);
                    this.mv$setSmashedBlock(true);
                } else {
                    world.destroyBlock(pos, false);
                }
                world.levelEvent(2001, pos, Block.getId((BlockState)state));
            } else if (state.getBlock() instanceof DecoratedPotBlock) {
                world.setBlock(pos, (BlockState)state.setValue((Property)DecoratedPotBlock.CRACKED, (Comparable)Boolean.valueOf(true)), 4);
                world.destroyBlock(pos, true, (Entity)entity);
            } else {
                world.destroyBlock(pos, false);
            }
            this.mv$setSmashedBlock(true);
            world.gameEvent((Entity)this, (Holder)GameEvent.BLOCK_CHANGE, pos);
            if (state.is(BlockTags.CRYSTAL_SOUND_BLOCKS)) {
                world.playSound(null, pos, SoundType.AMETHYST.getBreakSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
            } else if (state.getBlock() instanceof DecoratedPotBlock) {
                world.playSound(null, pos, SoundType.DECORATED_POT.getBreakSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
            } else {
                world.playSound(null, pos, (SoundEvent)SoundRegistry.BLOCK_SMASH.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            Block block = stateAbove.getBlock();
            if (block instanceof StarCoinBlock) {
                StarCoinBlock starCoin = (StarCoinBlock)block;
                StarCoinBlock.collectCoin(starCoin, world, stateAbove, pos.above(), (Entity)entity, coinItem);
            } else if (stateAbove.getBlock() instanceof CoinBlock) {
                CoinBlock.collectCoin(world, stateAbove, pos.above(), (Entity)entity, coinItem);
            }
        } else {
            world.playSound(null, pos, (SoundEvent)SoundRegistry.BLOCK_SMASH_FAIL.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!(state.getBlock() instanceof QuestionBlock)) {
                Block block = stateAbove.getBlock();
                if (block instanceof StarCoinBlock) {
                    StarCoinBlock starCoin = (StarCoinBlock)block;
                    StarCoinBlock.collectCoin(starCoin, world, stateAbove, pos.above(), (Entity)entity, coinItem);
                } else if (stateAbove.getBlock() instanceof CoinBlock) {
                    CoinBlock.collectCoin(world, stateAbove, pos.above(), (Entity)entity, coinItem);
                }
            }
        }
    }

    @Unique
    private static void mv$hitEntityAbove(BlockPos pos, Level world, LivingEntity attackingEntity) {
        AABB boundingBox = new AABB(pos.above()).inflate(0.01);
        List entitiesAbove = world.getEntities(null, boundingBox);
        if (!entitiesAbove.isEmpty()) {
            for (Entity entityAbove : entitiesAbove) {
                LivingEntity livingEntity;
                if (!(entityAbove instanceof LivingEntity) || !(livingEntity = (LivingEntity)entityAbove).onGround()) continue;
                entityAbove.setDeltaMovement(entityAbove.getDeltaMovement().add(0.0, 0.5, 0.0));
                if (world.getBlockState(pos).getBlock() instanceof QuestionBlock) {
                    if (livingEntity instanceof KoopaShellEntity) {
                        livingEntity.hurt(DamageSourceRegistry.bonked((Entity)livingEntity, (Entity)attackingEntity), 0.0f);
                        continue;
                    }
                    livingEntity.hurt(DamageSourceRegistry.bonked((Entity)livingEntity, (Entity)attackingEntity), 4.0f);
                    continue;
                }
                if (livingEntity instanceof KoopaShellEntity) {
                    livingEntity.hurt(DamageSourceRegistry.shrapnel((Entity)livingEntity, (Entity)attackingEntity), 0.0f);
                    continue;
                }
                livingEntity.hurt(DamageSourceRegistry.shrapnel((Entity)livingEntity, (Entity)attackingEntity), 4.0f);
            }
        }
    }

    @Unique
    public void mv$superStarKillEntity(LivingEntity attackingEntity) {
        List nearbyEntities = attackingEntity.level().getEntities((Entity)attackingEntity, attackingEntity.getBoundingBox());
        if (!nearbyEntities.isEmpty()) {
            for (Entity collidedEntity : nearbyEntities) {
                Player player;
                LivingEntity entity;
                if (!(collidedEntity instanceof LivingEntity) || (entity = (LivingEntity)collidedEntity).getType().is(TagRegistry.SUPER_STAR_IMMUNE)) continue;
                if (entity instanceof Player && (player = (Player)entity).isCreative() || entity.isSpectator()) {
                    return;
                }
                if (((Boolean)collidedEntity.getData(DataAttachmentRegistry.HAS_SUPER_STAR)).booleanValue()) {
                    return;
                }
                Vec3 knockbackDirection = entity.position().subtract(attackingEntity.position()).normalize();
                double knockbackStrength = 5.0;
                Vec3 knockbackVelocity = knockbackDirection.scale(knockbackStrength).add(0.0, 1.0, 0.0);
                if (!((Boolean)ConfigRegistry.DISABLE_CONSECUTIVE_BOUNCING.get()).booleanValue() && entity.isAlive() && !entity.isInvulnerable()) {
                    this.mv$consecutiveReward(attackingEntity, entity);
                }
                entity.setDeltaMovement(knockbackVelocity);
                entity.hurt(DamageSourceRegistry.superStar(collidedEntity, (Entity)attackingEntity), ((Double)ConfigRegistry.SUPER_STAR_DAMAGE.get()).floatValue());
            }
        }
    }

    @Unique
    public void mv$squashEntity(LivingEntity stompingEntity) {
        List nearbyEntities = stompingEntity.level().getEntities((Entity)stompingEntity, stompingEntity.getBoundingBox().inflate(0.5, 1.25, 0.5));
        if (!nearbyEntities.isEmpty()) {
            for (Entity entity : nearbyEntities) {
                LivingEntity damagedEntity;
                if (!(entity instanceof LivingEntity) || (damagedEntity = (LivingEntity)entity).isVehicle() || !stompingEntity.getType().is(TagRegistry.CAN_STOMP_ENEMIES) && !((Boolean)ConfigRegistry.ALL_MOBS_CAN_STOMP.get()).booleanValue() && !stompingEntity.level().getGameRules().getBoolean(Marioverse.ALL_MOBS_CAN_STOMP) || damagedEntity.getType().is(TagRegistry.POWER_UP_ENTITIES) || !damagedEntity.getType().is(TagRegistry.CAN_BE_STOMPED) && !damagedEntity.getType().is(TagRegistry.CAN_BE_INSTAKILL_STOMPED) && !((Boolean)ConfigRegistry.STOMP_ALL_MOBS.get()).booleanValue() && !stompingEntity.level().getGameRules().getBoolean(Marioverse.STOMP_ALL_MOBS)) continue;
                if (stompingEntity instanceof Player) {
                    Player player = (Player)stompingEntity;
                    if (player.getAbilities().flying) {
                        return;
                    }
                }
                if (((Boolean)stompingEntity.getData(DataAttachmentRegistry.HAS_SUPER_STAR)).booleanValue() || ((Boolean)damagedEntity.getData(DataAttachmentRegistry.HAS_SUPER_STAR)).booleanValue()) {
                    return;
                }
                if (!(stompingEntity.getY() >= damagedEntity.getY() + (double)damagedEntity.getEyeHeight()) || !(stompingEntity.fallDistance > 0.0f) && !stompingEntity.isInWaterOrBubble()) continue;
                double bounceBlockHeight = ConfigRegistry.STOMP_BOUNCE_HEIGHT.getAsDouble();
                double gravity = 0.08;
                double bounceVelocity = Math.sqrt(2.0 * gravity * bounceBlockHeight);
                if (damagedEntity.isAlive()) {
                    stompingEntity.setDeltaMovement(stompingEntity.getDeltaMovement().x, bounceVelocity, stompingEntity.getDeltaMovement().z);
                    stompingEntity.hasImpulse = true;
                    if (stompingEntity instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)stompingEntity;
                        serverPlayer.connection.send((Packet)new ClientboundSetEntityMotionPacket((Entity)stompingEntity));
                    }
                }
                float scaleFactor = damagedEntity.getBbHeight() * damagedEntity.getBbWidth();
                int numParticles = (int)(scaleFactor * 20.0f);
                double radius = damagedEntity.getBbWidth() / 2.0f;
                Level level = stompingEntity.level();
                if (level instanceof ServerLevel) {
                    ServerLevel serverWorld = (ServerLevel)level;
                    ServerParticleUtils.spawnParticleRingAboveEntity((ParticleOptions)ParticleTypes.CRIT, serverWorld, (Entity)damagedEntity, radius, 0.0, numParticles);
                }
                boolean hasNoArmor = true;
                for (ItemStack armorSlot : damagedEntity.getArmorSlots()) {
                    if (armorSlot.isEmpty()) continue;
                    hasNoArmor = false;
                    break;
                }
                if (stompingEntity.level().isClientSide() || damagedEntity.isDeadOrDying()) continue;
                if (damagedEntity.getType().is(TagRegistry.CAN_BE_INSTAKILL_STOMPED) && hasNoArmor) {
                    damagedEntity.hurt(DamageSourceRegistry.stomp((Entity)damagedEntity, (Entity)stompingEntity), damagedEntity.getHealth());
                } else if (damagedEntity.getType().is(TagRegistry.CAN_BE_STOMPED) || ((Boolean)ConfigRegistry.STOMP_ALL_MOBS.get()).booleanValue() || stompingEntity.level().getGameRules().getBoolean(Marioverse.STOMP_ALL_MOBS)) {
                    if (damagedEntity instanceof KoopaTroopaEntity || damagedEntity instanceof KoopaShellEntity) {
                        damagedEntity.hurt(DamageSourceRegistry.stomp((Entity)damagedEntity, (Entity)stompingEntity), 0.0f);
                    } else {
                        damagedEntity.hurt(DamageSourceRegistry.stomp((Entity)damagedEntity, (Entity)stompingEntity), ((Double)ConfigRegistry.STOMP_DAMAGE.get()).floatValue());
                    }
                }
                if (((Boolean)ConfigRegistry.DISABLE_CONSECUTIVE_BOUNCING.get()).booleanValue()) break;
                this.mv$consecutiveReward(stompingEntity, damagedEntity);
                break;
            }
        }
    }

    @Unique
    public void mv$consecutiveReward(LivingEntity attackingEntity, LivingEntity damagedEntity) {
        int oneUpsRewarded = this.mv$getOneUpsRewarded();
        int consecutiveBounces = this.mv$getConsecutiveBounces();
        this.mv$setConsecutiveBounces(consecutiveBounces + 1);
        if (consecutiveBounces == 0) {
            if (!((Boolean)ConfigRegistry.DISABLE_REWARD_PARTICLES.get()).booleanValue()) {
                Level level = damagedEntity.level();
                if (level instanceof ServerLevel) {
                    ServerLevel serverWorld = (ServerLevel)level;
                    ServerParticleUtils.spawnRewardParticle((ParticleOptions)ParticleRegistry.GOOD.get(), serverWorld, (Entity)damagedEntity, 1.0);
                }
            } else if (attackingEntity instanceof Player) {
                Player player = (Player)attackingEntity;
                player.displayClientMessage((Component)Component.translatable((String)"display.marioverse.consecutive_bounce.good"), Boolean.TRUE.booleanValue());
            }
        } else if (consecutiveBounces == 1) {
            if (!((Boolean)ConfigRegistry.DISABLE_REWARD_PARTICLES.get()).booleanValue()) {
                Level level = damagedEntity.level();
                if (level instanceof ServerLevel) {
                    ServerLevel serverWorld = (ServerLevel)level;
                    ServerParticleUtils.spawnRewardParticle((ParticleOptions)ParticleRegistry.GREAT.get(), serverWorld, (Entity)damagedEntity, 1.0);
                }
            } else if (attackingEntity instanceof Player) {
                Player player = (Player)attackingEntity;
                player.displayClientMessage((Component)Component.translatable((String)"display.marioverse.consecutive_bounce.great"), Boolean.TRUE.booleanValue());
            }
        } else if (consecutiveBounces == 2) {
            if (!((Boolean)ConfigRegistry.DISABLE_REWARD_PARTICLES.get()).booleanValue()) {
                Level level = damagedEntity.level();
                if (level instanceof ServerLevel) {
                    ServerLevel serverWorld = (ServerLevel)level;
                    ServerParticleUtils.spawnRewardParticle((ParticleOptions)ParticleRegistry.SUPER.get(), serverWorld, (Entity)damagedEntity, 1.0);
                }
            } else if (attackingEntity instanceof Player) {
                Player player = (Player)attackingEntity;
                player.displayClientMessage((Component)Component.translatable((String)"display.marioverse.consecutive_bounce.super"), Boolean.TRUE.booleanValue());
            }
        } else if (consecutiveBounces == 3) {
            if (!((Boolean)ConfigRegistry.DISABLE_REWARD_PARTICLES.get()).booleanValue()) {
                Level level = damagedEntity.level();
                if (level instanceof ServerLevel) {
                    ServerLevel serverWorld = (ServerLevel)level;
                    ServerParticleUtils.spawnRewardParticle((ParticleOptions)ParticleRegistry.FANTASTIC.get(), serverWorld, (Entity)damagedEntity, 1.0);
                }
            } else if (attackingEntity instanceof Player) {
                Player player = (Player)attackingEntity;
                player.displayClientMessage((Component)Component.translatable((String)"display.marioverse.consecutive_bounce.fantastic"), Boolean.TRUE.booleanValue());
            }
        } else if (consecutiveBounces == 4) {
            if (!((Boolean)ConfigRegistry.DISABLE_REWARD_PARTICLES.get()).booleanValue()) {
                Level level = damagedEntity.level();
                if (level instanceof ServerLevel) {
                    ServerLevel serverWorld = (ServerLevel)level;
                    ServerParticleUtils.spawnRewardParticle((ParticleOptions)ParticleRegistry.EXCELLENT.get(), serverWorld, (Entity)damagedEntity, 1.0);
                }
            } else if (attackingEntity instanceof Player) {
                Player player = (Player)attackingEntity;
                player.displayClientMessage((Component)Component.translatable((String)"display.marioverse.consecutive_bounce.excellent"), Boolean.TRUE.booleanValue());
            }
        } else if (consecutiveBounces == 5) {
            if (!((Boolean)ConfigRegistry.DISABLE_REWARD_PARTICLES.get()).booleanValue()) {
                Level level = damagedEntity.level();
                if (level instanceof ServerLevel) {
                    ServerLevel serverWorld = (ServerLevel)level;
                    ServerParticleUtils.spawnRewardParticle((ParticleOptions)ParticleRegistry.INCREDIBLE.get(), serverWorld, (Entity)damagedEntity, 1.0);
                }
            } else if (attackingEntity instanceof Player) {
                Player player = (Player)attackingEntity;
                player.displayClientMessage((Component)Component.translatable((String)"display.marioverse.consecutive_bounce.incredible"), Boolean.TRUE.booleanValue());
            }
        } else if (consecutiveBounces == 6) {
            if (!((Boolean)ConfigRegistry.DISABLE_REWARD_PARTICLES.get()).booleanValue()) {
                Level level = damagedEntity.level();
                if (level instanceof ServerLevel) {
                    ServerLevel serverWorld = (ServerLevel)level;
                    ServerParticleUtils.spawnRewardParticle((ParticleOptions)ParticleRegistry.WONDERFUL.get(), serverWorld, (Entity)damagedEntity, 1.0);
                }
            } else if (attackingEntity instanceof Player) {
                Player player = (Player)attackingEntity;
                player.displayClientMessage((Component)Component.translatable((String)"display.marioverse.consecutive_bounce.wonderful"), Boolean.TRUE.booleanValue());
            }
        } else if (consecutiveBounces >= 7 && (Integer)ConfigRegistry.MAX_ONE_UP_BOUNCE_REWARD.get() > oneUpsRewarded) {
            this.mv$setOneUpsRewarded(oneUpsRewarded + 1);
            this.mv$bounceReward(attackingEntity);
            if (!((Boolean)ConfigRegistry.DISABLE_REWARD_PARTICLES.get()).booleanValue()) {
                Level level = damagedEntity.level();
                if (level instanceof ServerLevel) {
                    ServerLevel serverWorld = (ServerLevel)level;
                    ServerParticleUtils.spawnRewardParticle((ParticleOptions)ParticleRegistry.ONE_UP.get(), serverWorld, (Entity)damagedEntity, 1.0);
                }
            } else if (attackingEntity instanceof Player) {
                Player player = (Player)attackingEntity;
                player.displayClientMessage((Component)Component.translatable((String)"display.marioverse.consecutive_bounce.one_up"), Boolean.TRUE.booleanValue());
            }
        }
    }

    @Unique
    public void mv$bounceReward(LivingEntity entity) {
        DeferredItem<Item> item = ItemRegistry.ONE_UP_MUSHROOM;
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = entity;
            if (((Boolean)ConfigRegistry.ONE_UP_HEALS_ALL_MOBS.get()).booleanValue() || entity.getType().is(TagRegistry.CAN_CONSUME_ONE_UPS)) {
                AccessoriesCapability capability = AccessoriesCapability.get((LivingEntity)livingEntity);
                ItemStack offhandStack = livingEntity.getOffhandItem();
                if (capability != null && !capability.isEquipped((Item)ItemRegistry.ONE_UP_MUSHROOM.get())) {
                    capability.attemptToEquipAccessory(new ItemStack((ItemLike)ItemRegistry.ONE_UP_MUSHROOM.get()));
                } else if (offhandStack.isEmpty()) {
                    livingEntity.setItemSlot(EquipmentSlot.OFFHAND, new ItemStack(item));
                } else if (offhandStack.getItem() instanceof OneUpMushroomItem) {
                    offhandStack.grow(1);
                }
                this.level().playSound(null, this.blockPosition(), (SoundEvent)SoundRegistry.ONE_UP_COLLECTED.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
            }
        }
    }
}

