/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.registries;

import com.wenxin2.marioverse.Marioverse;
import com.wenxin2.marioverse.entities.FireGoombaEntity;
import com.wenxin2.marioverse.entities.GoldKoopaShellEntity;
import com.wenxin2.marioverse.entities.GoldKoopaTroopaEntity;
import com.wenxin2.marioverse.entities.GoombaEntity;
import com.wenxin2.marioverse.entities.GreenKoopaTroopaEntity;
import com.wenxin2.marioverse.entities.HeftyGoombaEntity;
import com.wenxin2.marioverse.entities.IceCubeEntity;
import com.wenxin2.marioverse.entities.KoopaShellEntity;
import com.wenxin2.marioverse.entities.KoopaTroopaEntity;
import com.wenxin2.marioverse.entities.MegaGoombaEntity;
import com.wenxin2.marioverse.entities.MiniGoombaEntity;
import com.wenxin2.marioverse.entities.PiranhaPlantEntity;
import com.wenxin2.marioverse.entities.RedKoopaShellEntity;
import com.wenxin2.marioverse.entities.RedKoopaTroopaEntity;
import com.wenxin2.marioverse.entities.power_ups.FireFlowerEntity;
import com.wenxin2.marioverse.entities.power_ups.IceFlowerEntity;
import com.wenxin2.marioverse.entities.power_ups.MushroomEntity;
import com.wenxin2.marioverse.entities.power_ups.OneUpMushroomEntity;
import com.wenxin2.marioverse.entities.power_ups.SuperStarEntity;
import com.wenxin2.marioverse.entities.projectiles.BouncingFireballProjectile;
import com.wenxin2.marioverse.entities.projectiles.BouncingIceBallProjectile;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;

@EventBusSubscriber(modid="marioverse")
public class EntityRegistry {
    public static final DeferredHolder<EntityType<?>, EntityType<BouncingFireballProjectile>> BOUNCING_FIREBALL = EntityRegistry.register("bouncing_fireball", BouncingFireballProjectile::new, MobCategory.MISC, 0.3f, 0.3f);
    public static final DeferredHolder<EntityType<?>, EntityType<BouncingIceBallProjectile>> BOUNCING_ICE_BALL = EntityRegistry.register("bouncing_ice_ball", BouncingIceBallProjectile::new, MobCategory.MISC, 0.5f, 0.5f);
    public static final DeferredHolder<EntityType<?>, EntityType<IceCubeEntity>> ICE_CUBE = Marioverse.ENTITIES.register("ice_cube", () -> EntityType.Builder.of(IceCubeEntity::new, (MobCategory)MobCategory.MISC).sized(1.0f, 1.0f).passengerAttachments(new float[]{0.5f}).build("ice_cube"));
    public static final DeferredHolder<EntityType<?>, EntityType<FireFlowerEntity>> FIRE_FLOWER = EntityRegistry.register("fire_flower", FireFlowerEntity::new, MobCategory.AMBIENT, 0.6f, 0.6f);
    public static final DeferredHolder<EntityType<?>, EntityType<IceFlowerEntity>> ICE_FLOWER = EntityRegistry.register("ice_flower", IceFlowerEntity::new, MobCategory.AMBIENT, 0.6f, 0.6f);
    public static final DeferredHolder<EntityType<?>, EntityType<MushroomEntity>> SUPER_MUSHROOM = EntityRegistry.register("super_mushroom", MushroomEntity::new, MobCategory.AMBIENT, 0.8f, 0.8f);
    public static final DeferredHolder<EntityType<?>, EntityType<OneUpMushroomEntity>> ONE_UP_MUSHROOM = EntityRegistry.register("one_up_mushroom", OneUpMushroomEntity::new, MobCategory.AMBIENT, 0.8f, 0.8f);
    public static final DeferredHolder<EntityType<?>, EntityType<SuperStarEntity>> SUPER_STAR = Marioverse.ENTITIES.register("super_star", () -> EntityType.Builder.of(SuperStarEntity::new, (MobCategory)MobCategory.AMBIENT).sized(0.8f, 0.8f).eyeHeight(0.625f).fireImmune().build("super_star"));
    public static final DeferredHolder<EntityType<?>, EntityType<FireGoombaEntity>> FIRE_GOOMBA = Marioverse.ENTITIES.register("fire_goomba", () -> EntityType.Builder.of(FireGoombaEntity::new, (MobCategory)MobCategory.MONSTER).sized(0.625f, 0.8f).eyeHeight(0.75f).ridingOffset(0.075f).fireImmune().build("fire_goomba"));
    public static final DeferredHolder<EntityType<?>, EntityType<HeftyGoombaEntity>> HEFTY_GOOMBA = Marioverse.ENTITIES.register("hefty_goomba", () -> EntityType.Builder.of(HeftyGoombaEntity::new, (MobCategory)MobCategory.MONSTER).sized(1.4375f, 1.625f).eyeHeight(1.3f).ridingOffset(0.075f).build("hefty_goomba"));
    public static final DeferredHolder<EntityType<?>, EntityType<GoombaEntity>> GOOMBA = Marioverse.ENTITIES.register("goomba", () -> EntityType.Builder.of(GoombaEntity::new, (MobCategory)MobCategory.MONSTER).sized(0.625f, 0.8f).eyeHeight(0.75f).ridingOffset(0.075f).build("goomba"));
    public static final DeferredHolder<EntityType<?>, EntityType<GoldKoopaShellEntity>> GOLD_KOOPA_SHELL = Marioverse.ENTITIES.register("gold_koopa_shell", () -> EntityType.Builder.of(GoldKoopaShellEntity::new, (MobCategory)MobCategory.AMBIENT).sized(0.7f, 0.7f).eyeHeight(0.6f).ridingOffset(-0.075f).build("gold_koopa_shell"));
    public static final DeferredHolder<EntityType<?>, EntityType<GoldKoopaTroopaEntity>> GOLD_KOOPA_TROOPA = Marioverse.ENTITIES.register("gold_koopa_troopa", () -> EntityType.Builder.of(GoldKoopaTroopaEntity::new, (MobCategory)MobCategory.MONSTER).sized(1.0f, 1.65f).eyeHeight(1.4f).ridingOffset(-0.3f).build("gold_koopa_troopa"));
    public static final DeferredHolder<EntityType<?>, EntityType<KoopaShellEntity>> GREEN_KOOPA_SHELL = Marioverse.ENTITIES.register("green_koopa_shell", () -> EntityType.Builder.of(KoopaShellEntity::new, (MobCategory)MobCategory.AMBIENT).sized(0.7f, 0.7f).eyeHeight(0.6f).ridingOffset(-0.075f).build("green_koopa_shell"));
    public static final DeferredHolder<EntityType<?>, EntityType<GreenKoopaTroopaEntity>> GREEN_KOOPA_TROOPA = Marioverse.ENTITIES.register("green_koopa_troopa", () -> EntityType.Builder.of(GreenKoopaTroopaEntity::new, (MobCategory)MobCategory.MONSTER).sized(1.0f, 1.65f).eyeHeight(1.4f).ridingOffset(-0.3f).build("green_koopa_troopa"));
    public static final DeferredHolder<EntityType<?>, EntityType<MegaGoombaEntity>> MEGA_GOOMBA = Marioverse.ENTITIES.register("mega_goomba", () -> EntityType.Builder.of(MegaGoombaEntity::new, (MobCategory)MobCategory.MONSTER).sized(2.875f, 3.25f).eyeHeight(2.625f).ridingOffset(0.125f).build("mega_goomba"));
    public static final DeferredHolder<EntityType<?>, EntityType<MiniGoombaEntity>> MINI_GOOMBA = Marioverse.ENTITIES.register("mini_goomba", () -> EntityType.Builder.of(MiniGoombaEntity::new, (MobCategory)MobCategory.MONSTER).sized(0.25f, 0.3125f).eyeHeight(0.3125f).ridingOffset(0.1f).nameTagOffset(-0.05f).build("mini_goomba"));
    public static final DeferredHolder<EntityType<?>, EntityType<PiranhaPlantEntity>> PIRANHA_PLANT = Marioverse.ENTITIES.register("piranha_plant", () -> EntityType.Builder.of(PiranhaPlantEntity::new, (MobCategory)MobCategory.MONSTER).sized(1.0f, 2.3125f).eyeHeight(2.0f).ridingOffset(0.1f).build("piranha_plant"));
    public static final DeferredHolder<EntityType<?>, EntityType<RedKoopaShellEntity>> RED_KOOPA_SHELL = Marioverse.ENTITIES.register("red_koopa_shell", () -> EntityType.Builder.of(RedKoopaShellEntity::new, (MobCategory)MobCategory.AMBIENT).sized(0.7f, 0.7f).eyeHeight(0.6f).ridingOffset(-0.075f).build("red_koopa_shell"));
    public static final DeferredHolder<EntityType<?>, EntityType<RedKoopaTroopaEntity>> RED_KOOPA_TROOPA = Marioverse.ENTITIES.register("red_koopa_troopa", () -> EntityType.Builder.of(RedKoopaTroopaEntity::new, (MobCategory)MobCategory.MONSTER).sized(1.0f, 1.65f).eyeHeight(1.4f).ridingOffset(-0.3f).build("red_koopa_troopa"));

    @SubscribeEvent
    public static void registerSpawnPlacements(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)FIRE_GOOMBA.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, FireGoombaEntity::checkFireGoombaSpawnRules, RegisterSpawnPlacementsEvent.Operation.AND);
        event.register((EntityType)GOOMBA.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, GoombaEntity::checkGoombaSpawnRules, RegisterSpawnPlacementsEvent.Operation.AND);
        event.register((EntityType)HEFTY_GOOMBA.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, GoombaEntity::checkGoombaSpawnRules, RegisterSpawnPlacementsEvent.Operation.AND);
        event.register((EntityType)MEGA_GOOMBA.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, GoombaEntity::checkGoombaSpawnRules, RegisterSpawnPlacementsEvent.Operation.AND);
        event.register((EntityType)MINI_GOOMBA.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, GoombaEntity::checkGoombaSpawnRules, RegisterSpawnPlacementsEvent.Operation.AND);
        event.register((EntityType)PIRANHA_PLANT.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING, PiranhaPlantEntity::checkPiranhaPlantSpawnRules, RegisterSpawnPlacementsEvent.Operation.AND);
        event.register((EntityType)GREEN_KOOPA_TROOPA.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, KoopaTroopaEntity::checkKoopaSpawnRules, RegisterSpawnPlacementsEvent.Operation.AND);
        event.register((EntityType)RED_KOOPA_TROOPA.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, KoopaTroopaEntity::checkKoopaSpawnRules, RegisterSpawnPlacementsEvent.Operation.AND);
        event.register((EntityType)GOLD_KOOPA_TROOPA.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, KoopaTroopaEntity::checkKoopaSpawnRules, RegisterSpawnPlacementsEvent.Operation.AND);
    }

    @SubscribeEvent
    public static void registerEntityAttributes(EntityAttributeCreationEvent event) {
        AttributeSupplier.Builder mushroomAttributes = PathfinderMob.createMobAttributes().add(Attributes.MAX_HEALTH, 1.0).add(Attributes.MOVEMENT_SPEED, (double)0.4f).add(Attributes.SAFE_FALL_DISTANCE, 10.0).add(Attributes.WATER_MOVEMENT_EFFICIENCY, (double)0.3f);
        AttributeSupplier.Builder koopaAttributes = Monster.createMobAttributes().add(Attributes.ATTACK_DAMAGE, (double)1.2f).add(Attributes.ATTACK_KNOCKBACK, 1.0).add(Attributes.ATTACK_SPEED, (double)0.6f).add(Attributes.FOLLOW_RANGE, 8.0).add(Attributes.MAX_HEALTH, 8.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.SAFE_FALL_DISTANCE, 8.0);
        AttributeSupplier.Builder koopaShellAttributes = Monster.createMobAttributes().add(Attributes.ATTACK_DAMAGE, (double)1.2f).add(Attributes.ATTACK_KNOCKBACK, 1.0).add(Attributes.ATTACK_SPEED, 1.0).add(Attributes.MOVEMENT_SPEED, 0.0).add(Attributes.GRAVITY, (double)0.08f).add(Attributes.FOLLOW_RANGE, 8.0).add(Attributes.KNOCKBACK_RESISTANCE, 1.0).add(Attributes.MAX_HEALTH, 8.0).add(Attributes.MOVEMENT_SPEED, 0.0).add(Attributes.SAFE_FALL_DISTANCE, 8.0).add(Attributes.STEP_HEIGHT, (double)0.6f);
        AttributeSupplier.Builder redKoopaShellAttributes = Monster.createMobAttributes().add(Attributes.ATTACK_DAMAGE, (double)1.2f).add(Attributes.ATTACK_KNOCKBACK, 1.0).add(Attributes.ATTACK_SPEED, 1.0).add(Attributes.GRAVITY, (double)0.08f).add(Attributes.FOLLOW_RANGE, 8.0).add(Attributes.KNOCKBACK_RESISTANCE, 1.0).add(Attributes.MAX_HEALTH, 8.0).add(Attributes.MOVEMENT_SPEED, 0.0).add(Attributes.SAFE_FALL_DISTANCE, 8.0).add(Attributes.STEP_HEIGHT, (double)1.1f);
        AttributeSupplier.Builder piranhaPlantAttributes = PathfinderMob.createMobAttributes().add(Attributes.ATTACK_DAMAGE, 5.0).add(Attributes.JUMP_STRENGTH, 0.0).add(Attributes.KNOCKBACK_RESISTANCE, 1.0).add(Attributes.MAX_HEALTH, 20.0).add(Attributes.MOVEMENT_SPEED, 0.0).add(Attributes.WATER_MOVEMENT_EFFICIENCY, 0.0);
        AttributeSupplier.Builder powerUpAttributes = PathfinderMob.createMobAttributes().add(Attributes.MAX_HEALTH, 1.0).add(Attributes.WATER_MOVEMENT_EFFICIENCY, (double)0.3f);
        AttributeSupplier.Builder starAttributes = PathfinderMob.createMobAttributes().add(Attributes.JUMP_STRENGTH, 0.5).add(Attributes.MAX_HEALTH, 1.0).add(Attributes.MOVEMENT_SPEED, (double)0.8f).add(Attributes.SAFE_FALL_DISTANCE, 10.0).add(Attributes.WATER_MOVEMENT_EFFICIENCY, (double)0.3f);
        event.put((EntityType)FIRE_FLOWER.get(), powerUpAttributes.build());
        event.put((EntityType)ICE_FLOWER.get(), powerUpAttributes.build());
        event.put((EntityType)SUPER_MUSHROOM.get(), mushroomAttributes.build());
        event.put((EntityType)ONE_UP_MUSHROOM.get(), mushroomAttributes.build());
        event.put((EntityType)SUPER_STAR.get(), starAttributes.build());
        event.put((EntityType)GOLD_KOOPA_SHELL.get(), redKoopaShellAttributes.build());
        event.put((EntityType)GOLD_KOOPA_TROOPA.get(), koopaAttributes.build());
        event.put((EntityType)GREEN_KOOPA_SHELL.get(), koopaShellAttributes.build());
        event.put((EntityType)GREEN_KOOPA_TROOPA.get(), koopaAttributes.build());
        event.put((EntityType)RED_KOOPA_SHELL.get(), redKoopaShellAttributes.build());
        event.put((EntityType)RED_KOOPA_TROOPA.get(), koopaAttributes.build());
        event.put((EntityType)PIRANHA_PLANT.get(), piranhaPlantAttributes.build());
        event.put((EntityType)FIRE_GOOMBA.get(), Monster.createMobAttributes().add(Attributes.ATTACK_DAMAGE, 1.5).add(Attributes.ATTACK_KNOCKBACK, 0.5).add(Attributes.ATTACK_SPEED, (double)0.8f).add(Attributes.FOLLOW_RANGE, 8.0).add(Attributes.MAX_HEALTH, 6.0).add(Attributes.MOVEMENT_SPEED, (double)0.4f).add(Attributes.SAFE_FALL_DISTANCE, 10.0).build());
        event.put((EntityType)HEFTY_GOOMBA.get(), Monster.createMobAttributes().add(Attributes.ATTACK_DAMAGE, 3.0).add(Attributes.ATTACK_KNOCKBACK, 0.5).add(Attributes.ATTACK_SPEED, (double)0.8f).add(Attributes.FOLLOW_RANGE, 12.0).add(Attributes.MAX_HEALTH, 12.0).add(Attributes.MOVEMENT_SPEED, (double)0.6f).add(Attributes.SAFE_FALL_DISTANCE, 9.0).build());
        event.put((EntityType)GOOMBA.get(), Monster.createMobAttributes().add(Attributes.ATTACK_DAMAGE, 1.0).add(Attributes.ATTACK_KNOCKBACK, 1.0).add(Attributes.ATTACK_SPEED, 1.0).add(Attributes.FOLLOW_RANGE, 8.0).add(Attributes.MAX_HEALTH, 4.0).add(Attributes.MOVEMENT_SPEED, (double)0.4f).add(Attributes.SAFE_FALL_DISTANCE, 10.0).build());
        event.put((EntityType)MEGA_GOOMBA.get(), Monster.createMobAttributes().add(Attributes.ATTACK_DAMAGE, 5.0).add(Attributes.ATTACK_KNOCKBACK, (double)1.2f).add(Attributes.ATTACK_SPEED, (double)0.6f).add(Attributes.FOLLOW_RANGE, 16.0).add(Attributes.MAX_HEALTH, 16.0).add(Attributes.MOVEMENT_SPEED, (double)0.8f).add(Attributes.SAFE_FALL_DISTANCE, 8.0).build());
        event.put((EntityType)MINI_GOOMBA.get(), Monster.createMobAttributes().add(Attributes.ATTACK_KNOCKBACK, 0.0).add(Attributes.ATTACK_SPEED, 0.5).add(Attributes.FOLLOW_RANGE, 8.0).add(Attributes.MAX_HEALTH, 1.0).add(Attributes.MOVEMENT_SPEED, (double)0.4f).add(Attributes.SAFE_FALL_DISTANCE, 12.0).build());
    }

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String name, EntityType.EntityFactory<T> entity, MobCategory category, float width, float height) {
        return Marioverse.ENTITIES.register(name, () -> EntityType.Builder.of((EntityType.EntityFactory)entity, (MobCategory)category).sized(width, height).build(name));
    }

    public static void init() {
    }
}

