/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.utils;

import com.wenxin2.marioverse.Marioverse;
import com.wenxin2.marioverse.entities.power_ups.AbstractPowerUpEntity;
import com.wenxin2.marioverse.entities.power_ups.MushroomEntity;
import com.wenxin2.marioverse.entities.power_ups.OneUpMushroomEntity;
import com.wenxin2.marioverse.entities.power_ups.SuperStarEntity;
import com.wenxin2.marioverse.items.OneUpMushroomItem;
import com.wenxin2.marioverse.registries.ConfigRegistry;
import com.wenxin2.marioverse.registries.DataAttachmentRegistry;
import com.wenxin2.marioverse.registries.ItemRegistry;
import com.wenxin2.marioverse.registries.ParticleRegistry;
import com.wenxin2.marioverse.registries.SoundRegistry;
import com.wenxin2.marioverse.registries.TagRegistry;
import com.wenxin2.marioverse.utils.CostumeHandler;
import com.wenxin2.marioverse.utils.ServerParticleUtils;
import io.wispforest.accessories.api.AccessoriesCapability;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface AbilitiesHandler
extends CostumeHandler {
    public void mv$clearAllPowerUps();

    public boolean mv$hasSuperMushroom();

    public void mv$setSuperMushroom(boolean var1);

    public boolean mv$hasSuperMushroomOverride();

    public void mv$setMushroomOverride(boolean var1);

    public boolean mv$hasDashMushroomBoost();

    public void mv$setDashMushroomBoost(boolean var1);

    public boolean mv$hasMegaMushroom();

    public void mv$setMegaMushroom(boolean var1);

    public boolean mv$hasFireFlower();

    public void mv$setFireFlower(boolean var1);

    public boolean mv$hasIceFlower();

    public void mv$setIceFlower(boolean var1);

    public boolean mv$hasSmashedBlock();

    public void mv$setSmashedBlock(boolean var1);

    public int mv$getFireballCooldown();

    public void mv$setFireballCooldown(int var1);

    public int mv$getFireballCount();

    public void mv$setFireballCount(int var1);

    public int mv$getIceBallCooldown();

    public void mv$setIceBallCooldown(int var1);

    public int mv$getIceBallCount();

    public void mv$setIceBallCount(int var1);

    public int mv$getCheckpointFlagCooldown();

    public void mv$setCheckpointFlagCooldown(int var1);

    public int mv$getConsecutiveBounces();

    public void mv$setConsecutiveBounces(int var1);

    public int mv$getFreezeImmunityCooldown();

    public void mv$setFreezeImmunityCooldown(int var1);

    public int mv$getFrozenCooldown();

    public void mv$setFrozenCooldown(int var1);

    public int mv$getOneUpsRewarded();

    public void mv$setOneUpsRewarded(int var1);

    @NotNull
    private static Boolean getDamageShrinksConfig(LivingEntity entity) {
        if (entity instanceof Player) {
            return (Boolean)ConfigRegistry.DAMAGE_SHRINKS_PLAYERS.get() != false || entity.level().getGameRules().getBoolean(Marioverse.DAMAGE_SHRINKS_PLAYERS);
        }
        return (Boolean)ConfigRegistry.DAMAGE_SHRINKS_ALL_MOBS.get() != false || entity.level().getGameRules().getBoolean(Marioverse.DAMAGE_SHRINKS_ALL_MOBS);
    }

    @NotNull
    private static Boolean equipCostumes(LivingEntity entity) {
        if (entity instanceof Player) {
            return (Boolean)ConfigRegistry.EQUIP_COSTUMES_PLAYERS.get();
        }
        return (Boolean)ConfigRegistry.EQUIP_COSTUMES_MOBS.get();
    }

    default public void applyMushroomPowerUp(Level world, LivingEntity entity, @Nullable MushroomEntity powerUp, float healthHealed) {
        if (!entity.isSpectator() && AbilitiesHandler.getDamageShrinksConfig(entity).booleanValue() && !entity.getType().is(TagRegistry.CANNOT_CONSUME_POWER_UPS) && (entity.getType().is(TagRegistry.CAN_CONSUME_SUPER_MUSHROOMS) || ((Boolean)ConfigRegistry.SUPER_MUSHROOM_POWERS_ALL_MOBS.get()).booleanValue())) {
            this.mv$setSuperMushroom(true);
            if (world instanceof ServerLevel) {
                ServerLevel serverWorld = (ServerLevel)world;
                ServerParticleUtils.spawnPoweredUpParticles((ParticleOptions)ParticleRegistry.POWERED_UP.get(), serverWorld, (Entity)entity, 10);
            }
            if (!world.isClientSide) {
                if (entity.getHealth() < entity.getMaxHealth()) {
                    entity.heal(healthHealed);
                }
                if (!entity.getType().is(TagRegistry.CANNOT_CONSUME_POWER_UPS)) {
                    world.playSound(null, entity.blockPosition(), (SoundEvent)SoundRegistry.POWERS_UP.get(), SoundSource.AMBIENT);
                }
            }
            if (powerUp != null) {
                powerUp.remove(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    default public void applyOneUpMushroomPowerUp(Level world, ItemStack stack, LivingEntity entity, OneUpMushroomEntity powerUp) {
        if (!entity.isSpectator() && !entity.getType().is(TagRegistry.CANNOT_CONSUME_POWER_UPS) && (entity.getType().is(TagRegistry.CAN_CONSUME_ONE_UPS) || ((Boolean)ConfigRegistry.ONE_UP_HEALS_ALL_MOBS.get()).booleanValue())) {
            AccessoriesCapability capability = AccessoriesCapability.get((LivingEntity)entity);
            ItemStack offhandStack = entity.getOffhandItem();
            if (capability != null && !capability.isEquipped((Item)ItemRegistry.ONE_UP_MUSHROOM.get())) {
                capability.attemptToEquipAccessory(new ItemStack((ItemLike)ItemRegistry.ONE_UP_MUSHROOM.get()));
            } else if (offhandStack.isEmpty()) {
                entity.setItemSlot(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)stack.getItem()));
            } else if (offhandStack.getItem() instanceof OneUpMushroomItem) {
                if (offhandStack.getCount() >= offhandStack.getMaxStackSize() && entity instanceof Player) {
                    Player player = (Player)entity;
                    player.drop(new ItemStack((ItemLike)ItemRegistry.ONE_UP_MUSHROOM.get()), Boolean.FALSE.booleanValue());
                } else {
                    offhandStack.grow(1);
                }
            }
            world.playSound(null, entity.blockPosition(), (SoundEvent)SoundRegistry.ONE_UP_COLLECTED.get(), SoundSource.AMBIENT);
            if (world instanceof ServerLevel) {
                ServerLevel serverWorld = (ServerLevel)world;
                ServerParticleUtils.spawnPoweredUpParticles((ParticleOptions)ParticleRegistry.POWERED_UP.get(), serverWorld, (Entity)entity, 10);
                ServerParticleUtils.spawnRewardParticle((ParticleOptions)ParticleRegistry.ONE_UP.get(), serverWorld, (Entity)entity, 1.0);
            }
            powerUp.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    default public void applySuperStarPowerUp(Level world, LivingEntity entity, SuperStarEntity powerUp) {
        if (!entity.isSpectator() && !entity.getType().is(TagRegistry.CANNOT_CONSUME_POWER_UPS) && (entity.getType().is(TagRegistry.CAN_CONSUME_SUPER_STARS) || ((Boolean)ConfigRegistry.SUPER_STAR_POWERS_ALL_MOBS.get()).booleanValue())) {
            entity.setData(DataAttachmentRegistry.HAS_SUPER_STAR, (Object)true);
            entity.setData(DataAttachmentRegistry.SUPER_STAR_COOLDOWN, (Object)((Integer)ConfigRegistry.SUPER_STAR_DURATION.get()));
            entity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, ((Integer)ConfigRegistry.SUPER_STAR_SPEED_DURATION.get()).intValue(), 4, true, false));
            if (world instanceof ServerLevel) {
                ServerLevel serverWorld = (ServerLevel)world;
                ServerParticleUtils.spawnPoweredUpParticles((ParticleOptions)ParticleRegistry.RAINBOW_GLINT.get(), serverWorld, (Entity)entity, 10);
            }
            world.playSound(null, entity.blockPosition(), (SoundEvent)SoundRegistry.POWERS_UP_SUPER_STAR.get(), SoundSource.AMBIENT);
            powerUp.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    default public void applyFireFlowerPowerUp(Level world, LivingEntity entity, AbstractPowerUpEntity powerUp) {
        if (!entity.isSpectator() && !entity.getType().is(TagRegistry.CANNOT_CONSUME_POWER_UPS) && (entity.getType().is(TagRegistry.CAN_CONSUME_FIRE_FLOWERS) || ((Boolean)ConfigRegistry.FIRE_FLOWER_POWERS_ALL_MOBS.get()).booleanValue())) {
            if (world instanceof ServerLevel) {
                ServerLevel serverWorld = (ServerLevel)world;
                ServerParticleUtils.spawnPoweredUpParticles((ParticleOptions)ParticleRegistry.FIRE_POWERED_UP.get(), serverWorld, (Entity)entity, 10);
            }
            if (entity.getHealth() < entity.getMaxHealth()) {
                entity.heal(((Double)ConfigRegistry.SUPER_MUSHROOM_HEALTH_HEALED.get()).floatValue());
            }
            this.mv$clearAllPowerUps();
            this.mv$setSuperMushroom(true);
            this.mv$setFireFlower(true);
            world.playSound(null, entity.blockPosition(), (SoundEvent)SoundRegistry.POWERS_UP.get(), SoundSource.AMBIENT);
            this.applyCostumeChange(entity, powerUp);
            powerUp.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    default public void applyIceFlowerPowerUp(Level world, LivingEntity entity, AbstractPowerUpEntity powerUp) {
        if (!entity.isSpectator() && !entity.getType().is(TagRegistry.CANNOT_CONSUME_POWER_UPS) && (entity.getType().is(TagRegistry.CAN_CONSUME_ICE_FLOWERS) || ((Boolean)ConfigRegistry.ICE_FLOWER_POWERS_ALL_MOBS.get()).booleanValue())) {
            if (world instanceof ServerLevel) {
                ServerLevel serverWorld = (ServerLevel)world;
                ServerParticleUtils.spawnPoweredUpParticles((ParticleOptions)ParticleRegistry.ICE_POWERED_UP.get(), serverWorld, (Entity)entity, 10);
            }
            if (entity.getHealth() < entity.getMaxHealth()) {
                entity.heal(((Double)ConfigRegistry.SUPER_MUSHROOM_HEALTH_HEALED.get()).floatValue());
            }
            this.mv$clearAllPowerUps();
            this.mv$setSuperMushroom(true);
            this.mv$setIceFlower(true);
            world.playSound(null, entity.blockPosition(), (SoundEvent)SoundRegistry.POWERS_UP.get(), SoundSource.AMBIENT);
            this.applyCostumeChange(entity, powerUp);
            powerUp.remove(Entity.RemovalReason.DISCARDED);
        }
    }
}

