/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.utils;

import com.wenxin2.marioverse.registries.AttributesRegistry;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ServerParticleUtils {
    public static void spawnParticlesOnBlockFaces(ParticleOptions particleOptions, ServerLevel serverWorld, BlockPos pos, IntProvider count) {
        for (Direction direction : Direction.values()) {
            ServerParticleUtils.spawnParticlesOnBlockFace(particleOptions, serverWorld, pos, direction, count, () -> ServerParticleUtils.getRandomSpeedRanges(serverWorld.getRandom()), 0.55);
        }
    }

    public static void spawnParticlesOnBlockFace(ParticleOptions particleOptions, ServerLevel serverWorld, BlockPos pos, Direction direction, IntProvider count, Supplier<Vec3> motionSupplier, double offset) {
        int particleAmount = count.sample(serverWorld.random);
        for (int i = 0; i < particleAmount; ++i) {
            ServerParticleUtils.spawnParticleOnFace(particleOptions, serverWorld, pos, direction, motionSupplier.get(), offset);
        }
    }

    public static void spawnParticleOnFace(ParticleOptions particleOptions, ServerLevel serverWorld, BlockPos pos, Direction face, Vec3 motion, double offset) {
        Vec3 center = Vec3.atCenterOf((Vec3i)pos);
        int xStep = face.getStepX();
        int yStep = face.getStepY();
        int zStep = face.getStepZ();
        double x = center.x + (xStep == 0 ? Mth.nextDouble((RandomSource)serverWorld.random, (double)-0.5, (double)0.5) : (double)xStep * offset);
        double y = center.y + (yStep == 0 ? Mth.nextDouble((RandomSource)serverWorld.random, (double)-0.5, (double)0.5) : (double)yStep * offset);
        double z = center.z + (zStep == 0 ? Mth.nextDouble((RandomSource)serverWorld.random, (double)-0.5, (double)0.5) : (double)zStep * offset);
        double motionX = xStep == 0 ? motion.x() : 0.0;
        double motionY = yStep == 0 ? motion.y() : 0.0;
        double motionZ = zStep == 0 ? motion.z() : 0.0;
        serverWorld.sendParticles(particleOptions, x, y, z, 1, motionX, motionY, motionZ, 0.0);
    }

    public static void spawnParticlesAboveBlock(ParticleOptions particleOptions, ServerLevel serverWorld, BlockPos pos) {
        RandomSource random = serverWorld.getRandom();
        for (int i = 0; i < 40; ++i) {
            serverWorld.sendParticles(particleOptions, (double)pos.getX() + 0.5 + 0.5 * (double)(random.nextBoolean() ? 1 : -1), (double)pos.getY() + 1.5, (double)pos.getZ() + 0.5 + 0.5 * (double)(random.nextBoolean() ? 1 : -1), 1, (random.nextDouble() - 0.5) * 2.0, -random.nextDouble(), (random.nextDouble() - 0.5) * 2.0, 1.0);
        }
    }

    public static void spawnParticleRingOnBlock(ParticleOptions particleOptions, ServerLevel serverWorld, BlockPos pos, double radius, int avgAmount) {
        float scaleFactor = 1.0f;
        int numParticles = (int)(scaleFactor * (float)avgAmount);
        for (int i = 0; i < numParticles; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)numParticles;
            double offsetX = Math.cos(angle) * radius;
            double offsetY = 0.5;
            double offsetZ = Math.sin(angle) * radius;
            double x = (double)pos.getX() + 0.5 + offsetX;
            double y = (double)pos.getY() + offsetY;
            double z = (double)pos.getZ() + 0.5 + offsetZ;
            serverWorld.sendParticles(particleOptions, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public static void spawnThreeLayerBlockParticles(ParticleOptions particleOptions, ServerLevel serverWorld, @Nullable Entity entity, BlockPos pos, int avgAmount) {
        float scaleFactor = 1.0f;
        int numParticles = (int)(scaleFactor * (float)avgAmount);
        double radius = 0.65;
        if (entity instanceof Painting) {
            Painting painting = (Painting)entity;
            radius = (double)((PaintingVariant)painting.getVariant().value()).width() / 2.0;
        }
        for (int i = 0; i < numParticles; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)numParticles;
            double offsetX = Math.cos(angle) * radius;
            double offsetZ = Math.sin(angle) * radius;
            double x = (double)pos.getX() + 0.5 + offsetX;
            double y = pos.getY();
            double z = (double)pos.getZ() + 0.5 + offsetZ;
            serverWorld.sendParticles(particleOptions, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
            serverWorld.sendParticles(particleOptions, x, y + 0.5, z, 1, 0.0, 0.0, 0.0, 0.0);
            serverWorld.sendParticles(particleOptions, x, y + 1.0, z, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public static void spawnOneLayerBlockParticles(ParticleOptions particleOptions, ServerLevel serverWorld, @Nullable Entity entity, BlockPos pos, int avgAmount) {
        float scaleFactor = 1.0f;
        int numParticles = (int)(scaleFactor * (float)avgAmount);
        double radius = 0.65;
        if (entity instanceof Painting) {
            Painting painting = (Painting)entity;
            radius = (double)((PaintingVariant)painting.getVariant().value()).width() / 2.0;
        }
        for (int i = 0; i < numParticles; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)numParticles;
            double offsetX = Math.cos(angle) * radius;
            double offsetZ = Math.sin(angle) * radius;
            double x = (double)pos.getX() + 0.5 + offsetX;
            double y = pos.getY();
            double z = (double)pos.getZ() + 0.5 + offsetZ;
            serverWorld.sendParticles(particleOptions, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public static void spawnRewardParticle(ParticleOptions particleOptions, ServerLevel serverWorld, Entity entity, double yHeight) {
        serverWorld.sendParticles(particleOptions, entity.getX(), entity.getY() + (double)entity.getBbHeight() + yHeight, entity.getZ(), 1, 0.0, 1.0, 0.0, 0.5);
    }

    public static void spawnAnimParticles(ParticleOptions particleOptions, ServerLevel serverWorld, Entity entity) {
        for (int i = 0; i < 10; ++i) {
            double dx = serverWorld.random.nextGaussian() * 0.02;
            double dy = serverWorld.random.nextGaussian() * 0.02;
            double dz = serverWorld.random.nextGaussian() * 0.02;
            serverWorld.sendParticles(particleOptions, entity.getRandomX(1.0) - dx * 10.0, entity.getRandomY() - dy * 5.0, entity.getRandomZ(1.0) - dz * 10.0, 1, dx, dy, dz, 0.02);
        }
    }

    public static void spawnSingleParticleOnEntityRandomly(ParticleOptions particleOptions, ServerLevel serverWorld, Entity entity) {
        RandomSource rand = RandomSource.create();
        double offsetX = rand.nextDouble() * (double)entity.getBbWidth() - (double)entity.getBbWidth() / 2.0;
        double offsetY = rand.nextDouble() * (double)entity.getBbHeight();
        double offsetZ = rand.nextDouble() * (double)entity.getBbWidth() - (double)entity.getBbWidth() / 2.0;
        serverWorld.sendParticles(particleOptions, entity.getX() + offsetX, entity.getY() + offsetY, entity.getZ() + offsetZ, 1, 0.0, 0.0, 0.0, 1.0);
    }

    public static void spawnParticlesOnEntityRandomly(ParticleOptions particleOptions, ServerLevel serverWorld, Entity entity, int avgAmount) {
        RandomSource rand = RandomSource.create();
        float scaleFactor = entity.getBbWidth() * entity.getBbHeight();
        int numParticles = (int)(scaleFactor * (float)avgAmount);
        for (int i = 0; i < numParticles; ++i) {
            double offsetX = rand.nextDouble() * (double)entity.getBbWidth() - (double)entity.getBbWidth() / 2.0;
            double offsetY = rand.nextDouble() * (double)entity.getBbHeight();
            double offsetZ = rand.nextDouble() * (double)entity.getBbWidth() - (double)entity.getBbWidth() / 2.0;
            if (entity instanceof Painting) {
                Painting painting = (Painting)entity;
                int width = ((PaintingVariant)painting.getVariant().value()).width();
                int height = ((PaintingVariant)painting.getVariant().value()).height();
                offsetX = rand.nextDouble() * (double)width - (double)width / 2.0;
                offsetY = rand.nextDouble() * (double)height - (double)height / 2.0;
                offsetZ = rand.nextDouble() * (double)width - (double)width / 2.0;
                switch (painting.getDirection()) {
                    case NORTH: {
                        offsetZ = -0.2;
                        break;
                    }
                    case SOUTH: {
                        offsetZ = 0.2;
                        break;
                    }
                    case EAST: {
                        offsetX = 0.2;
                        break;
                    }
                    case WEST: {
                        offsetX = -0.2;
                    }
                }
            }
            serverWorld.sendParticles(particleOptions, entity.getX() + offsetX, entity.getY() + offsetY, entity.getZ() + offsetZ, 1, 0.0, 0.0, 0.0, 0.5);
        }
    }

    public static void spawnEntityBreakParticles(ParticleOptions particleOptions, ServerLevel serverWorld, Entity entity, float height, float width) {
        RandomSource rand = RandomSource.create();
        double offsetX = rand.nextDouble() * (double)width - (double)(width / 2.0f);
        double offsetY = rand.nextDouble() * (double)height;
        double offsetZ = rand.nextDouble() * (double)width - (double)(width / 2.0f);
        serverWorld.sendParticles(particleOptions, entity.getX() + offsetX, entity.getY() + offsetY, entity.getZ() + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
    }

    public static void spawnPoweredUpParticles(ParticleOptions particleOptions, ServerLevel serverWorld, Entity entity, int avgAmount) {
        float scaleFactor = entity.getBbWidth();
        int numParticles = (int)(scaleFactor * (float)avgAmount);
        double radius = entity.getBbWidth() / 2.0f;
        if (entity instanceof Painting) {
            Painting painting = (Painting)entity;
            radius = (double)((PaintingVariant)painting.getVariant().value()).width() / 2.0;
        }
        for (int i = 0; i < numParticles; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)numParticles;
            double offsetX = Math.cos(angle) * radius;
            double offsetY = entity.getBbHeight();
            double offsetZ = Math.sin(angle) * radius;
            if (entity instanceof Painting) {
                Painting painting = (Painting)entity;
                offsetY = ((PaintingVariant)painting.getVariant().value()).height();
            }
            double x = entity.getX() + offsetX;
            double y = entity.getY();
            double z = entity.getZ() + offsetZ;
            serverWorld.sendParticles(particleOptions, x, y + offsetY - 0.2, z, 1, 0.0, 0.0, 0.0, 0.0);
            serverWorld.sendParticles(particleOptions, x, y + offsetY / 2.0, z, 1, 0.0, 0.0, 0.0, 0.0);
            serverWorld.sendParticles(particleOptions, x, y + 0.2, z, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public static void spawnParticleRingOnEntity(ParticleOptions particleOptions, ServerLevel serverWorld, Entity entity, double radius, double speed, int particleAmt) {
        for (int i = 0; i < particleAmt; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)particleAmt;
            double offsetX = Math.cos(angle) * radius;
            double offsetY = Math.sin(angle) * radius;
            double offsetZ = Math.sin(angle) * radius;
            double x = entity.getX() + offsetX;
            double y = entity.getY() + offsetY;
            double z = entity.getZ() + offsetZ;
            serverWorld.sendParticles(particleOptions, x, y, z, 1, 0.0, 0.0, 0.0, speed);
        }
    }

    public static void spawnParticleRingAboveEntity(ParticleOptions particleOptions, ServerLevel serverWorld, Entity entity, double radius, double speed, int particleAmt) {
        for (int i = 0; i < particleAmt; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)particleAmt;
            double offsetX = Math.cos(angle) * radius;
            double offsetZ = Math.sin(angle) * radius;
            double x = entity.getX() + offsetX;
            double y = entity.getY() + (double)entity.getBbHeight();
            double z = entity.getZ() + offsetZ;
            serverWorld.sendParticles(particleOptions, x, y, z, 1, 0.0, 0.0, 0.0, speed);
        }
    }

    public static void spawnParticleRingBelowEntity(ParticleOptions particleOptions, ServerLevel serverWorld, Entity entity, double radius, double speed, int particleAmt) {
        for (int i = 0; i < particleAmt; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)particleAmt;
            double offsetX = Math.cos(angle) * radius;
            double offsetZ = Math.sin(angle) * radius;
            double x = entity.getX() + offsetX;
            double y = entity.getY();
            double z = entity.getZ() + offsetZ;
            serverWorld.sendParticles(particleOptions, x, y, z, 1, 0.0, 0.0, 0.0, speed);
        }
    }

    public static void spawnParticleTrail(ParticleOptions particleOptions, ServerLevel serverWorld, Entity entity, boolean particlesInAir, int particleAmt, double particleHeight) {
        BlockPos posLegacy = entity.getOnPosLegacy();
        BlockState state = entity.level().getBlockState(posLegacy);
        RandomSource rand = RandomSource.create();
        if (state.getRenderShape() != RenderShape.INVISIBLE || particlesInAir) {
            Vec3 vec3 = entity.getDeltaMovement();
            BlockPos pos = entity.blockPosition();
            double x = entity.getX() + (entity.getRandom().nextDouble() - 0.5);
            double z = entity.getZ() + (entity.getRandom().nextDouble() - 0.5);
            double dOffset = -4.0;
            if (entity instanceof AbstractMinecart) {
                dOffset = -16.0;
            }
            double dx = vec3.x / 2.0 * dOffset;
            double dy = 0.5;
            double dz = vec3.z / 2.0 * dOffset;
            double speed = Math.sqrt(dx * dx + dy * dy + dz * dz);
            double offsetX = dx / speed;
            double offsetY = dy / speed;
            double offsetZ = dz / speed;
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                float scale = (float)livingEntity.getAttributeValue(Attributes.SCALE);
                float widthScale = (float)livingEntity.getAttributeValue(AttributesRegistry.WIDTH_SCALE);
                x = entity.getX() + (entity.getRandom().nextDouble() - 0.5) * (double)scale * (double)widthScale;
                z = entity.getZ() + (entity.getRandom().nextDouble() - 0.5) * (double)scale * (double)widthScale;
            }
            if (pos.getX() != posLegacy.getX()) {
                x = Mth.clamp((double)x, (double)posLegacy.getX(), (double)((double)posLegacy.getX() + 1.0));
            }
            if (pos.getZ() != posLegacy.getZ()) {
                z = Mth.clamp((double)z, (double)posLegacy.getZ(), (double)((double)posLegacy.getZ() + 1.0));
            }
            serverWorld.sendParticles(particleOptions, x, entity.getY() + particleHeight, z, particleAmt, offsetX, offsetY, offsetZ, speed);
        }
    }

    public static void spawnClientParticleTrail(ParticleOptions particleOptions, @NotNull Entity entity, boolean particlesInAir, int particleAmt, double particleHeight, double particleAtSpeed) {
        BlockPos posLegacy = entity.getOnPosLegacy();
        BlockState state = entity.level().getBlockState(posLegacy);
        Vec3 deltaMovement = entity.getDeltaMovement();
        if (deltaMovement.horizontalDistance() >= particleAtSpeed) {
            for (int i = 0; i < particleAmt; ++i) {
                if (state.getRenderShape() == RenderShape.INVISIBLE && !particlesInAir) continue;
                BlockPos pos = entity.blockPosition();
                double x = entity.getX() + (entity.getRandom().nextDouble() - 0.5);
                double z = entity.getZ() + (entity.getRandom().nextDouble() - 0.5);
                double dOffset = -4.0;
                if (entity instanceof AbstractMinecart) {
                    dOffset = -16.0;
                }
                if (entity instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)entity;
                    float scale = (float)livingEntity.getAttributeValue(Attributes.SCALE);
                    float widthScale = (float)livingEntity.getAttributeValue(AttributesRegistry.WIDTH_SCALE);
                    x = entity.getX() + (entity.getRandom().nextDouble() - 0.5) * (double)scale * (double)widthScale;
                    z = entity.getZ() + (entity.getRandom().nextDouble() - 0.5) * (double)scale * (double)widthScale;
                }
                if (pos.getX() != posLegacy.getX()) {
                    x = Mth.clamp((double)x, (double)posLegacy.getX(), (double)((double)posLegacy.getX() + 1.0));
                }
                if (pos.getZ() != posLegacy.getZ()) {
                    z = Mth.clamp((double)z, (double)posLegacy.getZ(), (double)((double)posLegacy.getZ() + 1.0));
                }
                entity.level().addParticle(particleOptions, x, entity.getY() + particleHeight, z, deltaMovement.x * dOffset, 0.5, deltaMovement.z * dOffset);
            }
        }
    }

    public static Vec3 getRandomSpeedRanges(RandomSource random) {
        return new Vec3(Mth.nextDouble((RandomSource)random, (double)-0.5, (double)0.5), Mth.nextDouble((RandomSource)random, (double)-0.5, (double)0.5), Mth.nextDouble((RandomSource)random, (double)-0.5, (double)0.5));
    }
}

