/*
 * Decompiled with CFR 0.152.
 */
package com.dudenduke.hudalternatives.common.graphics;

import com.dudenduke.hudalternatives.common.graphics.Sprite;
import com.dudenduke.hudalternatives.common.numerics.Dimensions;
import com.dudenduke.hudalternatives.common.numerics.Vector2;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;

public class SpriteSheetHelper {
    private final ResourceLocation SpriteSheet;
    private final Dimensions SheetDimensions;

    public SpriteSheetHelper(ResourceLocation spriteSheet, Dimensions spriteSheetDimensions) {
        this.SpriteSheet = spriteSheet;
        this.SheetDimensions = spriteSheetDimensions;
    }

    public void blitSprite(GuiGraphics guiGraphics, int screenX, int screenY, Sprite sprite) {
        int x2 = screenX + sprite.width();
        int y2 = screenY + sprite.height();
        float minU = ((float)sprite.u() + 0.0f) / (float)this.SheetDimensions.width();
        float maxU = ((float)(sprite.u() + sprite.width()) + 0.0f) / (float)this.SheetDimensions.width();
        float minV = ((float)sprite.v() + 0.0f) / (float)this.SheetDimensions.height();
        float maxV = ((float)(sprite.v() + sprite.height()) + 0.0f) / (float)this.SheetDimensions.height();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.SpriteSheet);
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        RenderSystem.enableBlend();
        Matrix4f matrix4f = guiGraphics.pose().last().pose();
        BufferBuilder bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        bufferbuilder.addVertex(matrix4f, (float)screenX, (float)screenY, -1.0f).setUv(minU, minV).setColor(-1);
        bufferbuilder.addVertex(matrix4f, (float)screenX, (float)y2, -1.0f).setUv(minU, maxV).setColor(-1);
        bufferbuilder.addVertex(matrix4f, (float)x2, (float)y2, -1.0f).setUv(maxU, maxV).setColor(-1);
        bufferbuilder.addVertex(matrix4f, (float)x2, (float)screenY, -1.0f).setUv(maxU, minV).setColor(-1);
        BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
        RenderSystem.disableBlend();
    }

    public void blitSprite(GuiGraphics guiGraphics, Vector2 point, Sprite sprite) {
        this.blitSprite(guiGraphics, point.x(), point.y(), sprite);
    }

    public void blitMeter(GuiGraphics guiGraphics, Vector2 point, Sprite sprite, float valuePercent, FillDirection fillDirection) {
        this.blitMeter(guiGraphics, point.x(), point.y(), sprite, valuePercent, fillDirection);
    }

    public void blitMeter(GuiGraphics guiGraphics, int screenX, int screenY, Sprite sprite, float valuePercent, FillDirection fillDirection) {
        switch (fillDirection.ordinal()) {
            case 0: {
                this.blitMeterLeftToRight(guiGraphics, screenX, screenY, sprite, valuePercent);
                break;
            }
            case 1: {
                this.blitMeterRightToLeft(guiGraphics, screenX, screenY, sprite, valuePercent);
                break;
            }
            case 2: {
                this.blitMeterTopToBottom(guiGraphics, screenX, screenY, sprite, valuePercent);
                break;
            }
            case 3: {
                this.blitMeterBottomToTop(guiGraphics, screenX, screenY, sprite, valuePercent);
            }
        }
    }

    private void blitMeterLeftToRight(GuiGraphics guiGraphics, int screenX, int screenY, Sprite sprite, float valuePercent) {
        int renderedWidth = (int)((float)sprite.width() * valuePercent);
        guiGraphics.blit(this.SpriteSheet, screenX, screenY, (float)sprite.u(), (float)sprite.v(), renderedWidth, sprite.height(), this.SheetDimensions.width(), this.SheetDimensions.height());
    }

    private void blitMeterRightToLeft(GuiGraphics guiGraphics, int screenX, int screenY, Sprite sprite, float valuePercent) {
        int removedSpriteWidth = sprite.width() - (int)((float)sprite.width() * valuePercent);
        int spriteStartU = removedSpriteWidth + sprite.u();
        int spriteWidthRemaining = sprite.width() - removedSpriteWidth;
        guiGraphics.blit(this.SpriteSheet, screenX + removedSpriteWidth, screenY, (float)spriteStartU, (float)sprite.v(), spriteWidthRemaining, sprite.height(), this.SheetDimensions.width(), this.SheetDimensions.height());
    }

    private void blitMeterTopToBottom(GuiGraphics guiGraphics, int screenX, int screenY, Sprite sprite, float valuePercent) {
        int renderedHeight = (int)((float)sprite.height() * valuePercent);
        guiGraphics.blit(this.SpriteSheet, screenX, screenY, (float)sprite.u(), (float)sprite.v(), sprite.width(), renderedHeight, this.SheetDimensions.width(), this.SheetDimensions.height());
    }

    private void blitMeterBottomToTop(GuiGraphics guiGraphics, int screenX, int screenY, Sprite sprite, float valuePercent) {
        int removedSpriteHeight = sprite.height() - (int)((float)sprite.height() * valuePercent);
        int spriteStartV = removedSpriteHeight + sprite.v();
        int spriteHeightRemaining = sprite.height() - removedSpriteHeight;
        guiGraphics.blit(this.SpriteSheet, screenX, screenY + removedSpriteHeight, (float)sprite.u(), (float)spriteStartV, sprite.width(), spriteHeightRemaining, this.SheetDimensions.width(), this.SheetDimensions.height());
    }

    public static enum FillDirection {
        LeftToRight,
        RightToLeft,
        TopToBottom,
        BottomToTop;

    }
}

