/*
 * Decompiled with CFR 0.152.
 */
package com.dudenduke.hudalternatives.common.player;

import com.dudenduke.hudalternatives.common.player.WeaponType;
import com.dudenduke.hudalternatives.common.player.WeaponUtils;
import java.util.List;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class HotbarHelpers {
    private HotbarHelpers() {
    }

    public static ItemStack[] getHotbar(LocalPlayer player) {
        ItemStack[] hotbar = new ItemStack[9];
        for (int i = 0; i < hotbar.length; ++i) {
            hotbar[i] = player.getInventory().getItem(i);
        }
        return hotbar;
    }

    public static int findCorrectToolInHotbar(LocalPlayer player) {
        TagKey itemTagKey;
        if (player == null) {
            return -1;
        }
        HitResult blockHit = player.pick(5.0, 0.0f, false);
        if (blockHit.getType() != HitResult.Type.BLOCK) {
            return -1;
        }
        BlockPos blockPos = ((BlockHitResult)blockHit).getBlockPos();
        BlockState blockState = player.level().getBlockState(blockPos);
        List blockStateTags = blockState.getTags().toList();
        Object object = blockStateTags.contains(BlockTags.MINEABLE_WITH_PICKAXE) ? ItemTags.PICKAXES : (blockStateTags.contains(BlockTags.MINEABLE_WITH_AXE) ? ItemTags.AXES : (blockStateTags.contains(BlockTags.MINEABLE_WITH_SHOVEL) ? ItemTags.SHOVELS : (itemTagKey = blockStateTags.contains(BlockTags.MINEABLE_WITH_HOE) ? ItemTags.HOES : null)));
        if (itemTagKey == null) {
            return -1;
        }
        ItemStack[] hotbar = HotbarHelpers.getHotbar(player);
        int toolIndex = -1;
        for (int i = 0; i < hotbar.length; ++i) {
            if (!hotbar[i].getTags().toList().contains(itemTagKey)) continue;
            toolIndex = i;
            break;
        }
        return toolIndex;
    }

    public static int findNextMeleeWeaponInHotbar(LocalPlayer player) {
        return HotbarHelpers.findNextWeaponOfTypeInHotbar(player, WeaponType.MELEE);
    }

    public static int findNextRangedWeaponInHotbar(LocalPlayer player) {
        return HotbarHelpers.findNextWeaponOfTypeInHotbar(player, WeaponType.RANGED);
    }

    private static int findNextWeaponOfTypeInHotbar(LocalPlayer player, WeaponType weaponType) {
        ItemStack[] hotbar = HotbarHelpers.getHotbar(player);
        int selectedHotbarIndex = player.getInventory().selected;
        int nextWeaponIndex = -1;
        int startingIndex = 0;
        if (weaponType == WeaponType.MELEE) {
            startingIndex = WeaponUtils.isMeleeWeapon(player.getMainHandItem()) ? selectedHotbarIndex + 1 : 0;
        } else if (weaponType == WeaponType.RANGED) {
            startingIndex = WeaponUtils.isRangedWeapon(player.getMainHandItem()) ? selectedHotbarIndex + 1 : 0;
        } else {
            return -1;
        }
        for (int i = 0; i < hotbar.length; ++i) {
            int nextIndex = Math.floorMod(startingIndex + i, 9);
            if (weaponType == WeaponType.MELEE && WeaponUtils.isMeleeWeapon(hotbar[nextIndex])) {
                nextWeaponIndex = nextIndex;
                break;
            }
            if (weaponType != WeaponType.RANGED || !WeaponUtils.isRangedWeapon(hotbar[nextIndex])) continue;
            nextWeaponIndex = nextIndex;
            break;
        }
        return nextWeaponIndex;
    }
}

