/*
 * Decompiled with CFR 0.152.
 */
package com.dudenduke.hudalternatives.common.player;

import com.dudenduke.hudalternatives.common.player.LivingVehicleType;
import java.util.Map;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class PlayerMountSnapshot {
    private final LivingEntity mount;
    private static final String _lookupKeyKey = "key='";
    private static final Map<String, LivingVehicleType> _sourceToEnumMap = Map.of("entity.minecraft.horse", LivingVehicleType.Horse, "entity.minecraft.camel", LivingVehicleType.Camel, "entity.minecraft.donkey", LivingVehicleType.Donkey, "entity.minecraft.mule", LivingVehicleType.Mule, "entity.minecraft.skeleton_horse", LivingVehicleType.Skeleton_horse, "entity.minecraft.strider", LivingVehicleType.Strider, "entity.minecraft.pig", LivingVehicleType.Pig);

    public PlayerMountSnapshot(LocalPlayer player) {
        LivingEntity mount;
        Entity entity = player.getVehicle();
        this.mount = entity instanceof LivingEntity ? (mount = (LivingEntity)entity) : null;
    }

    public boolean isPlayerMounted() {
        return this.mount != null;
    }

    public LivingVehicleType getMountType() {
        if (this.mount == null) {
            return null;
        }
        return this.getMountType(this.mount);
    }

    public float getMountHealth() {
        if (this.mount == null) {
            return -1.0f;
        }
        return this.mount.getHealth();
    }

    public float getMountMaxHealth() {
        if (this.mount == null) {
            return -1.0f;
        }
        return this.mount.getMaxHealth();
    }

    private LivingVehicleType getMountType(LivingEntity mob) {
        String componentKey = mob.getName().toString();
        int keyEqualsIndex = componentKey.indexOf(_lookupKeyKey) + _lookupKeyKey.length();
        int keyEndIndex = componentKey.indexOf("'", keyEqualsIndex);
        String translationKey = componentKey.substring(keyEqualsIndex, keyEndIndex);
        return _sourceToEnumMap.getOrDefault(translationKey, LivingVehicleType.Unknown);
    }
}

