/*
 * Decompiled with CFR 0.152.
 */
package com.dudenduke.hudalternatives.common.player;

import com.dudenduke.hudalternatives.common.player.SurvivalPlayerEvent;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.ItemStack;

public class SurvivalPlayerSnapshot {
    public final LocalPlayer localPlayer;
    public final int experienceLevel;
    public final int totalExperience;
    public final float health;
    public final float maxHealth;
    public final float absorption;
    public final float foodLevel;
    public final float maxFoodLevel;
    public final float saturation;
    public final Effect healthEffect;
    public final Effect hungerEffect;
    public final float drownPercentage;
    public final int selectedHotbarIndex;
    public final ItemStack mainHandItem;

    public SurvivalPlayerSnapshot(LocalPlayer player) {
        this.localPlayer = player;
        this.experienceLevel = player.experienceLevel;
        this.totalExperience = player.totalExperience;
        this.maxHealth = player.getMaxHealth();
        this.health = player.getHealth();
        this.absorption = player.getAbsorptionAmount();
        FoodData foodData = player.getFoodData();
        this.maxFoodLevel = 20.0f;
        this.foodLevel = foodData.getFoodLevel();
        this.saturation = foodData.getSaturationLevel();
        this.healthEffect = this.getHealthEffect(player);
        this.hungerEffect = this.getHungerEffect(player);
        this.mainHandItem = player.getMainHandItem();
        int currentlySelectedHotbarIndex = player.getInventory().selected;
        if (SurvivalPlayerEvent.lastSelectedHotbarIndex() != -1 && currentlySelectedHotbarIndex != SurvivalPlayerEvent.lastSelectedHotbarIndex()) {
            SurvivalPlayerEvent.setLastItemSlotChangedInstant();
        }
        SurvivalPlayerEvent.setLastSelectedHotbarIndex(currentlySelectedHotbarIndex);
        this.selectedHotbarIndex = currentlySelectedHotbarIndex;
        this.drownPercentage = 1.0f - (float)player.getAirSupply() / (float)player.getMaxAirSupply();
    }

    private Effect getHealthEffect(LocalPlayer player) {
        Collection effects = player.getActiveEffects();
        Optional<MobEffectInstance> poisonedOrWitheredEffect = effects.stream().filter(e -> e.getEffect().equals((Object)MobEffects.WITHER) || e.getEffect().equals((Object)MobEffects.POISON)).findFirst();
        return poisonedOrWitheredEffect.isPresent() ? (poisonedOrWitheredEffect.get().getEffect().equals((Object)MobEffects.WITHER) ? Effect.WITHERED : Effect.POISONED) : Effect.NONE;
    }

    private Effect getHungerEffect(LocalPlayer player) {
        Collection effects = player.getActiveEffects();
        Optional<MobEffectInstance> hungeredEffect = effects.stream().filter(e -> e.getEffect().equals((Object)MobEffects.HUNGER)).findFirst();
        return hungeredEffect.isPresent() ? Effect.HUNGERED : Effect.NONE;
    }

    public static enum Effect {
        NONE,
        POISONED,
        WITHERED,
        HUNGERED;

    }
}

