/*
 * Decompiled with CFR 0.152.
 */
package com.dudenduke.hudalternatives.minimalmodern;

import com.dudenduke.hudalternatives.common.graphics.MC_ResourceLocations;
import com.dudenduke.hudalternatives.common.player.SurvivalPlayerEvent;
import com.dudenduke.hudalternatives.minimalmodern.MM_KeyBindings;
import com.dudenduke.hudalternatives.minimalmodern.MM_KeyInputHandlers;
import com.dudenduke.hudalternatives.minimalmodern.MM_ResourceLocations;
import com.dudenduke.hudalternatives.minimalmodern.MinimalModernHudMod;
import com.dudenduke.hudalternatives.minimalmodern.MinimalModernOverlay;
import java.time.Duration;
import java.time.Instant;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;

@Mod(value="minimalmodern", dist={Dist.CLIENT})
@EventBusSubscriber(modid="minimalmodern", value={Dist.CLIENT})
public class ClientEvents {
    private static final Duration HotbarPreviewDuration = Duration.ofMillis(1500L);

    public ClientEvents(ModContainer container) {
        container.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
    }

    @SubscribeEvent
    static void onRegisterGuiOverlay(RegisterGuiLayersEvent event) {
        event.replaceLayer(MC_ResourceLocations.HealthGuiLayer, MinimalModernOverlay::emptyRender);
        event.replaceLayer(MC_ResourceLocations.ArmorGuiLayer, MinimalModernOverlay::emptyRender);
        event.replaceLayer(MC_ResourceLocations.FoodGuiLayer, MinimalModernOverlay::emptyRender);
        event.replaceLayer(MC_ResourceLocations.VehicleGuiLayer, MinimalModernOverlay::emptyRender);
        event.replaceLayer(MC_ResourceLocations.AirGuiLayer, MinimalModernOverlay::emptyRender);
        event.replaceLayer(MC_ResourceLocations.XPGuiLayer, MinimalModernOverlay::emptyRender);
        event.registerAbove(VanillaGuiLayers.HOTBAR, MM_ResourceLocations.MinimalModernGuiLayer, MinimalModernOverlay::render);
    }

    @SubscribeEvent
    static void onRenderGuiLayer(RenderGuiLayerEvent.Pre event) {
        if (event.getName().equals((Object)MC_ResourceLocations.HotbarGuiLayer)) {
            if (SurvivalPlayerEvent.lastItemSlotChangedInstant() == null || Instant.now().isAfter(SurvivalPlayerEvent.lastItemSlotChangedInstant().plus(HotbarPreviewDuration))) {
                event.setCanceled(true);
            }
        } else if (event.getName().equals((Object)MC_ResourceLocations.XPBarGuiLayer)) {
            LocalPlayer player = Minecraft.getInstance().player;
            if (player == null) {
                return;
            }
            boolean isPlayerMounted = player.getVehicle() instanceof LivingEntity;
            if (!isPlayerMounted) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    static void onClientSetup(FMLClientSetupEvent event) {
        MinimalModernHudMod.LOGGER.info("HELLO FROM CLIENT SETUP");
        MinimalModernHudMod.LOGGER.info("MINECRAFT NAME >> {}", (Object)Minecraft.getInstance().getUser().getName());
    }

    @SubscribeEvent
    static void onKeyRegister(RegisterKeyMappingsEvent event) {
        MM_KeyBindings.onKeyRegister(event);
    }

    @SubscribeEvent
    static void onKeyInput(InputEvent.Key event) {
        MM_KeyInputHandlers.onKeyInput(event);
    }
}

