/*
 * Decompiled with CFR 0.152.
 */
package com.dudenduke.hudalternatives.minimalmodern;

import net.neoforged.neoforge.common.ModConfigSpec;

public class MM_Configuration {
    public static final ModConfigSpec.ConfigValue<Integer> MAIN_GUI_DRAW_CORNER;
    public static final ModConfigSpec.ConfigValue<Integer> MAIN_GUI_HORIZONTAL_PADDING;
    public static final ModConfigSpec.ConfigValue<Integer> MAIN_GUI_VERTICAL_PADDING;
    public static final ModConfigSpec.ConfigValue<Boolean> SEPARATE_VALUE_BARS;
    public static final ModConfigSpec.ConfigValue<Integer> VALUE_BARS_DRAW_CORNER;
    public static final ModConfigSpec.ConfigValue<Integer> VALUE_BARS_HORIZONTAL_PADDING;
    public static final ModConfigSpec.ConfigValue<Integer> VALUE_BARS_VERTICAL_PADDING;
    public static final ModConfigSpec.Builder BUILDER;
    public static final ModConfigSpec SPEC;

    public static int MainGuiDrawCorner() {
        return (Integer)MAIN_GUI_DRAW_CORNER.get();
    }

    public static int MainGuiHorizontalPadding() {
        return (Integer)MAIN_GUI_HORIZONTAL_PADDING.get();
    }

    public static int MainGuiVerticalPadding() {
        return (Integer)MAIN_GUI_VERTICAL_PADDING.get();
    }

    public static boolean SeparateValueBars() {
        return (Boolean)SEPARATE_VALUE_BARS.get();
    }

    public static int ValueBarsDrawCorner() {
        return (Integer)VALUE_BARS_DRAW_CORNER.get();
    }

    public static int ValueBarsHorizontalPadding() {
        return (Integer)VALUE_BARS_HORIZONTAL_PADDING.get();
    }

    public static int ValueBarsVerticalPadding() {
        return (Integer)VALUE_BARS_VERTICAL_PADDING.get();
    }

    static {
        BUILDER = new ModConfigSpec.Builder();
        BUILDER.push("Configs for Minimal Modern");
        MAIN_GUI_DRAW_CORNER = BUILDER.comment("Which corner to display main GUI? 0 = TopLeft, 1 = TopRight, 2 = BottomLeft, 3 = BottomRight").defineInRange("MainGuiCorner", 2, 0, 3);
        MAIN_GUI_HORIZONTAL_PADDING = BUILDER.comment("Horizontal Padding for main GUI.").defineInRange("MainGuiHorizontalPadding", 0, 0, 50);
        MAIN_GUI_VERTICAL_PADDING = BUILDER.comment("Vertical Padding for main GUI.").defineInRange("MainGuiVerticalPadding", 0, 0, 50);
        SEPARATE_VALUE_BARS = BUILDER.comment(new String[]{"Separate the main GUI from the Value Bars.", "The following settings will only take effect if set to true", "The corner values must also be different."}).define("SeparateValueBars", false);
        VALUE_BARS_DRAW_CORNER = BUILDER.comment("Which corner to display Value Bars? 0 = TopLeft, 1 = TopRight, 2 = BottomLeft, 3 = BottomRight").defineInRange("ValueBarsCorner", 2, 0, 3);
        VALUE_BARS_HORIZONTAL_PADDING = BUILDER.comment("Horizontal Padding for Value Bars.").defineInRange("ValueBarsHorizontalPadding", 0, 0, 50);
        VALUE_BARS_VERTICAL_PADDING = BUILDER.comment("Vertical Padding for Value Bars.").defineInRange("ValueBarsVerticalPadding", 0, 0, 50);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

