/*
 * Decompiled with CFR 0.152.
 */
package com.dudenduke.hudalternatives.minimalmodern;

import com.dudenduke.hudalternatives.common.graphics.Sprite;
import com.dudenduke.hudalternatives.common.graphics.SpriteSheetHelper;
import com.dudenduke.hudalternatives.common.numerics.Dimensions;
import com.dudenduke.hudalternatives.common.numerics.Vector2;
import com.dudenduke.hudalternatives.common.player.HotbarHelpers;
import com.dudenduke.hudalternatives.common.player.LivingVehicleType;
import com.dudenduke.hudalternatives.common.player.PlayerMountEvent;
import com.dudenduke.hudalternatives.common.player.PlayerMountSnapshot;
import com.dudenduke.hudalternatives.common.player.SurvivalPlayerSnapshot;
import com.dudenduke.hudalternatives.minimalmodern.MM_Configuration;
import com.dudenduke.hudalternatives.minimalmodern.MM_ResourceLocations;
import com.dudenduke.hudalternatives.minimalmodern.MM_Sprites;
import java.awt.Color;
import java.time.Duration;
import java.time.Instant;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.item.ItemStack;

public class MinimalModernOverlay {
    private static final SpriteSheetHelper _spriteSheetHelper = new SpriteSheetHelper(MM_ResourceLocations.MinimalModernGuiLayer, MM_Sprites.FullSheet.dimensions());
    private static final Duration horseHpNumbersSolidSeconds = Duration.ofMillis(1500L);
    private static final Duration horseHpNumbersFadeSeconds = Duration.ofMillis(1500L);
    private static final Duration horseHpNumbersShowTime = horseHpNumbersSolidSeconds.plus(horseHpNumbersFadeSeconds);
    private static final Font DefaultFont = Minecraft.getInstance().font;
    private static final Color BrightGreen = new Color(0, 233, 104);
    private static final Color SteelBlue = new Color(0, 141, 184);
    private static final Color BrightOrange = new Color(214, 84, 16);
    private static final Color MediumGray = new Color(92, 92, 92);

    public static void emptyRender(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
    }

    public static void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        boolean separatedBars;
        Vector2 mainScreenAnchor;
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        int screenWidth = guiGraphics.guiWidth();
        int screenHeight = guiGraphics.guiHeight();
        Dimensions screenDims = new Dimensions(screenWidth, screenHeight);
        SurvivalPlayerSnapshot playerSnapshot = new SurvivalPlayerSnapshot(player);
        PlayerMountSnapshot mountSnapshot = new PlayerMountSnapshot(player);
        PlayerMountEvent.UpdatePlayerMountEvent(player);
        Vector2 valueBarAnchorPoint = mainScreenAnchor = MinimalModernOverlay.getMainScreenAnchorPoint(screenDims, MM_Configuration.MainGuiDrawCorner());
        boolean bl = separatedBars = MM_Configuration.SeparateValueBars() && MM_Configuration.ValueBarsDrawCorner() != MM_Configuration.MainGuiDrawCorner();
        if (separatedBars) {
            if (MM_Configuration.MainGuiDrawCorner() == 1 || MM_Configuration.MainGuiDrawCorner() == 3) {
                int adjustedX = mainScreenAnchor.x() + MM_Sprites.ValueBarsBackground.width() - MM_Sprites.SmallHex.width() / 2 - 1;
                mainScreenAnchor = new Vector2(adjustedX, mainScreenAnchor.y());
            }
            valueBarAnchorPoint = MinimalModernOverlay.getSeparatedValueBarsAnchorPoint(screenDims, MM_Configuration.ValueBarsDrawCorner());
            MinimalModernOverlay.renderValueBarsBackground(guiGraphics, valueBarAnchorPoint);
        } else {
            MinimalModernOverlay.renderValueBarsBackground(guiGraphics, mainScreenAnchor);
        }
        MinimalModernOverlay.renderMainHex(guiGraphics, mainScreenAnchor);
        MinimalModernOverlay.renderHotbarHexes(guiGraphics, mainScreenAnchor);
        MinimalModernOverlay.renderActiveItem(guiGraphics, playerSnapshot, mainScreenAnchor);
        MinimalModernOverlay.renderAdjacentItems(guiGraphics, playerSnapshot, mainScreenAnchor);
        MinimalModernOverlay.renderHealthBar(guiGraphics, valueBarAnchorPoint, playerSnapshot.health, playerSnapshot.maxHealth, playerSnapshot.healthEffect);
        MinimalModernOverlay.renderGoldenHealthBar(guiGraphics, valueBarAnchorPoint, playerSnapshot.absorption);
        MinimalModernOverlay.renderFoodBar(guiGraphics, valueBarAnchorPoint, playerSnapshot.foodLevel, playerSnapshot.maxFoodLevel, playerSnapshot.hungerEffect);
        MinimalModernOverlay.renderFoodSaturationBar(guiGraphics, valueBarAnchorPoint, playerSnapshot.saturation, playerSnapshot.maxFoodLevel);
        MinimalModernOverlay.renderDrowningBar(guiGraphics, mainScreenAnchor, playerSnapshot.drownPercentage);
        if (mountSnapshot.isPlayerMounted()) {
            MinimalModernOverlay.renderMountHex(guiGraphics, mainScreenAnchor, mountSnapshot.getMountType());
            Vector2 mountHealthBarAnchorPoint = !separatedBars ? mainScreenAnchor : MinimalModernOverlay.getSeparatedValueBarsAnchorPoint(screenDims, MM_Configuration.ValueBarsDrawCorner());
            MinimalModernOverlay.renderMountHealthBar(guiGraphics, mountHealthBarAnchorPoint, separatedBars, mountSnapshot.getMountHealth(), mountSnapshot.getMountMaxHealth());
        } else {
            MinimalModernOverlay.renderExperienceLevel(guiGraphics, mainScreenAnchor, playerSnapshot.experienceLevel);
        }
    }

    private static Vector2 getMainScreenAnchorPoint(Dimensions screen, int drawCorner) {
        int leftX = 10 + MM_Configuration.MainGuiHorizontalPadding();
        int rightX = screen.width() - MM_Sprites.LargeHex.width() - MM_Sprites.MainHealthBar.width() - 2 - MM_Configuration.MainGuiHorizontalPadding();
        int topY = 19 + MM_Configuration.MainGuiVerticalPadding();
        int bottomY = screen.height() - MM_Sprites.LargeHex.height() - 19 - MM_Configuration.MainGuiVerticalPadding();
        return switch (drawCorner) {
            case 0 -> new Vector2(leftX, topY);
            case 1 -> new Vector2(rightX, topY);
            case 2 -> new Vector2(leftX, bottomY);
            case 3 -> new Vector2(rightX, bottomY);
            default -> new Vector2(leftX, bottomY);
        };
    }

    private static Vector2 getSeparatedValueBarsAnchorPoint(Dimensions screen, int drawCorner) {
        int leftX = 4 - MM_Sprites.LargeHex.width() + MM_Configuration.ValueBarsHorizontalPadding();
        int rightX = screen.width() - MM_Sprites.LargeHex.width() - MM_Sprites.MainHealthBar.width() - 2 - MM_Configuration.ValueBarsHorizontalPadding();
        int topY = 19 - MM_Sprites.SmallHex.height() + MM_Configuration.ValueBarsVerticalPadding();
        int bottomY = screen.height() - MM_Sprites.LargeHex.height() - 19 + MM_Sprites.SmallHex.height() - MM_Configuration.ValueBarsVerticalPadding();
        return switch (drawCorner) {
            case 0 -> new Vector2(leftX, topY);
            case 1 -> new Vector2(rightX, topY);
            case 2 -> new Vector2(leftX, bottomY);
            case 3 -> new Vector2(rightX, bottomY);
            default -> new Vector2(leftX, bottomY);
        };
    }

    private static void renderMainHex(GuiGraphics guiGraphics, Vector2 anchor) {
        _spriteSheetHelper.blitSprite(guiGraphics, anchor, MM_Sprites.LargeHex);
    }

    private static void renderValueBarsBackground(GuiGraphics guiGraphics, Vector2 anchor) {
        _spriteSheetHelper.blitSprite(guiGraphics, anchor.x() + 31, anchor.y() + 11, MM_Sprites.ValueBarsBackground);
    }

    private static void renderHotbarHexes(GuiGraphics guiGraphics, Vector2 anchor) {
        _spriteSheetHelper.blitSprite(guiGraphics, anchor.x() - 9, anchor.y() - 18, MM_Sprites.SmallHex);
        _spriteSheetHelper.blitSprite(guiGraphics, anchor.x() + 20, anchor.y() + 30, MM_Sprites.SmallHex);
    }

    private static void renderExperienceLevel(GuiGraphics guiGraphics, Vector2 mainAnchor, int experienceLevel) {
        guiGraphics.drawString(DefaultFont, String.valueOf(experienceLevel), mainAnchor.x() + 26, mainAnchor.y() - 3, BrightGreen.getRGB(), true);
    }

    private static void renderActiveItem(GuiGraphics guiGraphics, SurvivalPlayerSnapshot player, Vector2 mainAnchor) {
        float scaleFactor = 1.5f;
        MinimalModernOverlay.renderItemWithScale(guiGraphics, player.mainHandItem, mainAnchor.x() + 4, mainAnchor.y() + 6, 1.5f);
        guiGraphics.renderItemDecorations(DefaultFont, player.mainHandItem, mainAnchor.x() + 8, mainAnchor.y() + 13);
        guiGraphics.drawString(DefaultFont, String.valueOf(player.selectedHotbarIndex + 1), mainAnchor.x() - 7, mainAnchor.y() + 14, SteelBlue.getRGB(), true);
    }

    private static void renderAdjacentItems(GuiGraphics guiGraphics, SurvivalPlayerSnapshot player, Vector2 mainAnchor) {
        ItemStack[] hotbar = HotbarHelpers.getHotbar(player.localPlayer);
        ItemStack leftItem = hotbar[Math.floorMod(player.selectedHotbarIndex - 1, 9)];
        ItemStack rightItem = hotbar[Math.floorMod(player.selectedHotbarIndex + 1, 9)];
        guiGraphics.renderItem(leftItem, mainAnchor.x() - 6, mainAnchor.y() - 14);
        guiGraphics.renderItem(rightItem, mainAnchor.x() + 23, mainAnchor.y() + 34);
        guiGraphics.renderItemDecorations(DefaultFont, leftItem, mainAnchor.x() - 6, mainAnchor.y() - 14);
        guiGraphics.renderItemDecorations(DefaultFont, rightItem, mainAnchor.x() + 23, mainAnchor.y() + 34);
    }

    private static void renderHealthBar(GuiGraphics guiGraphics, Vector2 mainAnchor, float health, float maxHealth, SurvivalPlayerSnapshot.Effect healthState) {
        Sprite healthBarSprite = healthState == SurvivalPlayerSnapshot.Effect.WITHERED ? MM_Sprites.WitheredHealthBar : (healthState == SurvivalPlayerSnapshot.Effect.POISONED ? MM_Sprites.PoisonedHealthBar : MM_Sprites.MainHealthBar);
        _spriteSheetHelper.blitMeter(guiGraphics, mainAnchor.x() + 32, mainAnchor.y() + 12, healthBarSprite, health / maxHealth, SpriteSheetHelper.FillDirection.LeftToRight);
    }

    private static void renderGoldenHealthBar(GuiGraphics guiGraphics, Vector2 mainAnchor, float absorption) {
        float maxAbsorption = 20.0f;
        _spriteSheetHelper.blitMeter(guiGraphics, mainAnchor.x() + 32, mainAnchor.y() + 14, MM_Sprites.GoldenHealthBar, absorption / maxAbsorption, SpriteSheetHelper.FillDirection.LeftToRight);
    }

    private static void renderFoodBar(GuiGraphics guiGraphics, Vector2 mainAnchor, float foodLevel, float maxFoodLevel, SurvivalPlayerSnapshot.Effect hungerState) {
        Sprite hungerBarSprite = hungerState == SurvivalPlayerSnapshot.Effect.HUNGERED ? MM_Sprites.PoisonedHungerBar : MM_Sprites.MainHungerBar;
        _spriteSheetHelper.blitMeter(guiGraphics, mainAnchor.x() + 32, mainAnchor.y() + 20, hungerBarSprite, foodLevel / maxFoodLevel, SpriteSheetHelper.FillDirection.LeftToRight);
    }

    private static void renderFoodSaturationBar(GuiGraphics guiGraphics, Vector2 mainAnchor, float saturation, float maxFoodLevel) {
        _spriteSheetHelper.blitMeter(guiGraphics, mainAnchor.x() + 32, mainAnchor.y() + 24, MM_Sprites.SaturationHungerBar, saturation / maxFoodLevel, SpriteSheetHelper.FillDirection.LeftToRight);
    }

    private static void renderDrowningBar(GuiGraphics guiGraphics, Vector2 mainAnchor, float drowningPercent) {
        _spriteSheetHelper.blitMeter(guiGraphics, mainAnchor.x() + 1, mainAnchor.y() + 1, MM_Sprites.DrowningHexSprite, drowningPercent, SpriteSheetHelper.FillDirection.BottomToTop);
    }

    private static void renderMountHex(GuiGraphics guiGraphics, Vector2 anchor, LivingVehicleType mountType) {
        _spriteSheetHelper.blitSprite(guiGraphics, anchor.x() + 19, anchor.y() - 18, MM_Sprites.SmallHex);
        Sprite mountSprite = switch (mountType) {
            default -> throw new MatchException(null, null);
            case LivingVehicleType.Horse -> MM_Sprites.Horse;
            case LivingVehicleType.Donkey -> MM_Sprites.Donkey;
            case LivingVehicleType.Mule -> MM_Sprites.Donkey;
            case LivingVehicleType.Pig -> MM_Sprites.Pig;
            case LivingVehicleType.Camel -> MM_Sprites.Camel;
            case LivingVehicleType.Skeleton_horse -> MM_Sprites.Skeleton_Horse;
            case LivingVehicleType.Strider -> MM_Sprites.Strider;
            case LivingVehicleType.Unknown -> MM_Sprites.Horse_Silhouette;
        };
        _spriteSheetHelper.blitSprite(guiGraphics, anchor.x() + 20, anchor.y() - 16, mountSprite);
    }

    private static void renderMountHealthBar(GuiGraphics guiGraphics, Vector2 mainAnchor, boolean separatedBars, float health, float maxHealth) {
        int xRef = mainAnchor.x() + 41;
        int yRef = mainAnchor.y() - 8;
        if (separatedBars) {
            xRef = mainAnchor.x() + 31;
            yRef = mainAnchor.y() + 26;
        }
        _spriteSheetHelper.blitSprite(guiGraphics, xRef, yRef, MM_Sprites.MountHealthBackground);
        _spriteSheetHelper.blitMeter(guiGraphics, xRef + 1, yRef + 1, MM_Sprites.MountHealthBar, health / maxHealth, SpriteSheetHelper.FillDirection.LeftToRight);
        if (MinimalModernOverlay.shouldShowHorseHpNumber()) {
            int alpha = MinimalModernOverlay.getHorseHpNumbersAlpha();
            Color orange = new Color(BrightOrange.getRed(), BrightOrange.getGreen(), BrightOrange.getBlue(), alpha);
            guiGraphics.drawString(DefaultFont, String.valueOf(health), xRef + 3, yRef + 6, orange.getRGB(), true);
            int hpWidth = DefaultFont.width(String.valueOf(health)) + 3;
            Color gray = new Color(MediumGray.getRed(), MediumGray.getGreen(), MediumGray.getBlue(), alpha);
            guiGraphics.drawString(DefaultFont, "/" + maxHealth, xRef + hpWidth, yRef + 6, gray.getRGB(), true);
        }
    }

    private static boolean shouldShowHorseHpNumber() {
        Instant now = Instant.now();
        boolean toShow = now.isBefore(PlayerMountEvent.whenPlayerMounted().plus(horseHpNumbersShowTime));
        if (toShow) {
            return true;
        }
        return PlayerMountEvent.whenMountDamagedWhileRiding() != null && now.isBefore(PlayerMountEvent.whenMountDamagedWhileRiding().plus(horseHpNumbersShowTime));
    }

    private static int getHorseHpNumbersAlpha() {
        Instant now = Instant.now();
        if (now.isBefore(PlayerMountEvent.whenPlayerMounted().plus(horseHpNumbersSolidSeconds))) {
            return 255;
        }
        if (PlayerMountEvent.whenMountDamagedWhileRiding() != null && now.isBefore(PlayerMountEvent.whenMountDamagedWhileRiding().plus(horseHpNumbersSolidSeconds))) {
            return 255;
        }
        if (now.isBefore(PlayerMountEvent.whenPlayerMounted().plus(horseHpNumbersShowTime))) {
            Duration elapsedSinceMounted = Duration.between(PlayerMountEvent.whenPlayerMounted().plus(horseHpNumbersSolidSeconds), now);
            return MinimalModernOverlay.calculateAlpha(elapsedSinceMounted, horseHpNumbersFadeSeconds);
        }
        if (PlayerMountEvent.whenMountDamagedWhileRiding() != null && now.isBefore(PlayerMountEvent.whenMountDamagedWhileRiding().plus(horseHpNumbersShowTime))) {
            Duration elapsedSinceDamaged = Duration.between(PlayerMountEvent.whenMountDamagedWhileRiding().plus(horseHpNumbersSolidSeconds), now);
            return MinimalModernOverlay.calculateAlpha(elapsedSinceDamaged, horseHpNumbersFadeSeconds);
        }
        return 255;
    }

    private static int calculateAlpha(Duration elapsedTime, Duration totalDuration) {
        double fade = (double)elapsedTime.toNanos() / (double)totalDuration.toNanos() * 255.0;
        return Math.max(255 - (int)fade, 25);
    }

    private static void renderItemWithScale(GuiGraphics guiGraphics, ItemStack itemStack, int x, int y, float scaleFactor) {
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)x, (float)y, 0.0f);
        guiGraphics.pose().scale(scaleFactor, scaleFactor, 1.0f);
        guiGraphics.renderItem(itemStack, 0, 0);
        guiGraphics.pose().popPose();
    }
}

