/*
 * Decompiled with CFR 0.152.
 */
package com.dudenduke.hudalternatives.common;

import com.dudenduke.hudalternatives.common.LivingVehicleType;
import com.mojang.datafixers.util.Pair;
import java.time.Instant;
import java.util.List;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class PlayerMountData {
    private static boolean isPlayerMounted = false;
    private static Instant whenPlayerMounted = null;
    private static LivingVehicleType mountType = null;
    private static float currentMountHealth = -1.0f;
    private static float mountLastFrameHealth = -1.0f;
    private static float mountMaxHealth = -1.0f;
    private static Instant whenMountDamagedWhileRiding = null;

    public static boolean isPlayerMounted() {
        return isPlayerMounted;
    }

    public static boolean wasPreviouslyRidingMount() {
        return whenPlayerMounted != null;
    }

    public static Instant getWhenPlayerMounted() {
        return whenPlayerMounted;
    }

    public static LivingVehicleType getMountType() {
        return mountType;
    }

    public static float getMountHealth() {
        return currentMountHealth;
    }

    public static float getMountLastFrameHealth() {
        return mountLastFrameHealth;
    }

    public static float getMountMaxHealth() {
        return mountMaxHealth;
    }

    public static Instant getWhenMountDamagedWhileRiding() {
        return whenMountDamagedWhileRiding;
    }

    public static void updateMountData(LocalPlayer player) {
        Entity vehicle = player.m_20202_();
        if (vehicle instanceof LivingEntity) {
            LivingEntity mob = (LivingEntity)vehicle;
            isPlayerMounted = true;
            mountType = PlayerMountData.getMountType(mob);
            mountLastFrameHealth = currentMountHealth;
            currentMountHealth = mob.m_21223_();
            mountMaxHealth = mob.m_21233_();
            if (!PlayerMountData.wasPreviouslyRidingMount()) {
                whenPlayerMounted = Instant.now();
            }
            if (currentMountHealth < mountLastFrameHealth) {
                whenMountDamagedWhileRiding = Instant.now();
            }
        } else {
            isPlayerMounted = false;
            mountType = null;
            mountLastFrameHealth = -1.0f;
            currentMountHealth = -1.0f;
            mountMaxHealth = -1.0f;
            whenPlayerMounted = null;
            whenMountDamagedWhileRiding = null;
        }
    }

    public static LivingVehicleType getMountType(LivingEntity mob) {
        String translationKey = mob.m_7755_().toString();
        List<Pair> sourcesToEnumMap = List.of(Pair.of((Object)"entity.minecraft.horse", (Object)((Object)LivingVehicleType.Horse)), Pair.of((Object)"entity.minecraft.camel", (Object)((Object)LivingVehicleType.Camel)), Pair.of((Object)"entity.minecraft.donkey", (Object)((Object)LivingVehicleType.Donkey)), Pair.of((Object)"entity.minecraft.mule", (Object)((Object)LivingVehicleType.Mule)), Pair.of((Object)"entity.minecraft.skeleton_horse", (Object)((Object)LivingVehicleType.Skeleton_horse)), Pair.of((Object)"entity.minecraft.strider", (Object)((Object)LivingVehicleType.Strider)), Pair.of((Object)"entity.minecraft.pig", (Object)((Object)LivingVehicleType.Pig)));
        for (Pair pair : sourcesToEnumMap) {
            if (!translationKey.contains((CharSequence)pair.getFirst())) continue;
            return (LivingVehicleType)((Object)pair.getSecond());
        }
        return LivingVehicleType.Unknown;
    }
}

