/*
 * Decompiled with CFR 0.152.
 */
package com.dudenduke.hudalternatives.common;

import com.dudenduke.hudalternatives.common.WeaponType;
import com.dudenduke.hudalternatives.common.WeaponUtils;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class SurvivalPlayerSnapshot {
    public final LocalPlayer localPlayer;
    public final int experienceLevel;
    public final int totalExperience;
    public final float health;
    public final float maxHealth;
    public final float absorption;
    public final float foodLevel;
    public final float maxFoodLevel;
    public final float saturation;
    public final Effect healthEffect;
    public final Effect hungerEffect;
    public final float drownPercentage;
    public final int selectedHotbarIndex;
    public final ItemStack mainHandItem;
    private ItemStack[] _hotbar = null;

    public SurvivalPlayerSnapshot(LocalPlayer player) {
        this.localPlayer = player;
        this.experienceLevel = player.f_36078_;
        this.totalExperience = player.f_36079_;
        this.maxHealth = player.m_21233_();
        this.health = player.m_21223_();
        this.absorption = player.m_6103_();
        FoodData foodData = player.m_36324_();
        this.maxFoodLevel = 20.0f;
        this.foodLevel = foodData.m_38702_();
        this.saturation = foodData.m_38722_();
        this.healthEffect = SurvivalPlayerSnapshot.getHealthEffect(player);
        this.hungerEffect = SurvivalPlayerSnapshot.getHungerEffect(player);
        this.mainHandItem = player.m_21205_();
        this.selectedHotbarIndex = player.m_150109_().f_35977_;
        this.drownPercentage = 1.0f - (float)player.m_20146_() / (float)player.m_6062_();
    }

    public ItemStack[] getHotbar() {
        if (this._hotbar != null) {
            return this._hotbar;
        }
        ItemStack[] hotbar = new ItemStack[9];
        for (int i = 0; i < hotbar.length; ++i) {
            hotbar[i] = this.localPlayer.m_150109_().m_8020_(i);
        }
        this._hotbar = hotbar;
        return hotbar;
    }

    private static Effect getHealthEffect(LocalPlayer player) {
        Collection effects = player.m_21220_();
        Optional<MobEffectInstance> poisonedOrWitheredEffect = effects.stream().filter(e -> e.m_19544_().equals(MobEffects.f_19615_) || e.m_19544_().equals(MobEffects.f_19614_)).findFirst();
        return poisonedOrWitheredEffect.isPresent() ? (poisonedOrWitheredEffect.get().m_19544_().equals(MobEffects.f_19615_) ? Effect.WITHERED : Effect.POISONED) : Effect.NONE;
    }

    private static Effect getHungerEffect(LocalPlayer player) {
        Collection effects = player.m_21220_();
        Optional<MobEffectInstance> hungeredEffect = effects.stream().filter(e -> e.m_19544_().equals(MobEffects.f_19612_)).findFirst();
        return hungeredEffect.isPresent() ? Effect.HUNGERED : Effect.NONE;
    }

    public int findCorrectToolInHotbar() {
        TagKey itemTagKey;
        LocalPlayer player = this.localPlayer;
        if (player == null) {
            return -1;
        }
        HitResult blockHit = player.m_19907_(5.0, 0.0f, false);
        if (blockHit.m_6662_() != HitResult.Type.BLOCK) {
            return -1;
        }
        BlockPos blockPos = ((BlockHitResult)blockHit).m_82425_();
        BlockState blockState = player.m_9236_().m_8055_(blockPos);
        List blockStateTags = blockState.m_204343_().toList();
        TagKey tagKey = blockStateTags.contains(BlockTags.f_144282_) ? ItemTags.f_271360_ : (blockStateTags.contains(BlockTags.f_144280_) ? ItemTags.f_271207_ : (blockStateTags.contains(BlockTags.f_144283_) ? ItemTags.f_271138_ : (itemTagKey = blockStateTags.contains(BlockTags.f_144281_) ? ItemTags.f_271298_ : ItemTags.f_271540_)));
        if (itemTagKey == ItemTags.f_271540_) {
            return -1;
        }
        ItemStack[] hotbar = this.getHotbar();
        int toolIndex = -1;
        for (int i = 0; i < hotbar.length; ++i) {
            if (!hotbar[i].m_204131_().toList().contains(itemTagKey)) continue;
            toolIndex = i;
            break;
        }
        return toolIndex;
    }

    public int findNextMeleeWeaponInHotbar() {
        return this.findNextWeaponOfTypeInHotbar(WeaponType.MELEE);
    }

    public int findNextRangedWeaponInHotbar() {
        return this.findNextWeaponOfTypeInHotbar(WeaponType.RANGED);
    }

    private int findNextWeaponOfTypeInHotbar(WeaponType weaponType) {
        ItemStack[] hotbar = this.getHotbar();
        int nextWeaponIndex = -1;
        int startingIndex = 0;
        if (weaponType == WeaponType.MELEE) {
            startingIndex = WeaponUtils.isMeleeWeapon(this.mainHandItem) ? this.selectedHotbarIndex + 1 : 0;
        } else if (weaponType == WeaponType.RANGED) {
            startingIndex = WeaponUtils.isRangedWeapon(this.mainHandItem) ? this.selectedHotbarIndex + 1 : 0;
        } else {
            return -1;
        }
        for (int i = 0; i < hotbar.length; ++i) {
            int nextIndex = Math.floorMod(startingIndex + i, 9);
            if (weaponType == WeaponType.MELEE && WeaponUtils.isMeleeWeapon(hotbar[nextIndex])) {
                nextWeaponIndex = nextIndex;
                break;
            }
            if (weaponType != WeaponType.RANGED || !WeaponUtils.isRangedWeapon(hotbar[nextIndex])) continue;
            nextWeaponIndex = nextIndex;
            break;
        }
        return nextWeaponIndex;
    }

    public static enum Effect {
        NONE,
        POISONED,
        WITHERED,
        HUNGERED;

    }
}

