/*
 * Decompiled with CFR 0.152.
 */
package com.dudenduke.hudalternatives.minimalmodern;

import com.dudenduke.hudalternatives.common.SurvivalPlayerSnapshot;
import com.dudenduke.hudalternatives.common.WeaponUtils;
import com.dudenduke.hudalternatives.minimalmodern.MM_KeyBindings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraftforge.client.event.InputEvent;

public class MM_KeyInputHandlers {
    public static void onKeyInput(InputEvent.Key event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (MM_KeyBindings.FIND_MELEE_WEAPON_INPUT.m_90859_()) {
            MM_KeyInputHandlers.FindMeleeWeapon(player);
        }
        if (MM_KeyBindings.FIND_RANGED_WEAPON_INPUT.m_90859_()) {
            MM_KeyInputHandlers.FindRangerWeapon(player);
        }
        if (MM_KeyBindings.FIND_TOOL_INPUT.m_90859_()) {
            MM_KeyInputHandlers.FindCorrectTool(player);
        }
    }

    public static void FindMeleeWeapon(LocalPlayer player) {
        if (player == null) {
            return;
        }
        SurvivalPlayerSnapshot playerSnapshot = new SurvivalPlayerSnapshot(player);
        int nextWeaponIndex = playerSnapshot.findNextMeleeWeaponInHotbar();
        if (nextWeaponIndex != -1 && nextWeaponIndex != playerSnapshot.selectedHotbarIndex) {
            player.m_150109_().f_35977_ = nextWeaponIndex;
            player.m_5496_(SoundEvents.f_12011_, 0.6f, 1.5f);
        } else if (!WeaponUtils.isMeleeWeapon(playerSnapshot.mainHandItem)) {
            player.m_5496_(SoundEvents.f_12015_, 0.6f, 0.5f);
        }
    }

    public static void FindRangerWeapon(LocalPlayer player) {
        if (player == null) {
            return;
        }
        SurvivalPlayerSnapshot playerSnapshot = new SurvivalPlayerSnapshot(player);
        int nextWeaponIndex = playerSnapshot.findNextRangedWeaponInHotbar();
        if (nextWeaponIndex != -1 && nextWeaponIndex != playerSnapshot.selectedHotbarIndex) {
            player.m_150109_().f_35977_ = nextWeaponIndex;
            player.m_5496_(SoundEvents.f_12639_, 0.6f, 1.5f);
        } else if (!WeaponUtils.isRangedWeapon(playerSnapshot.mainHandItem)) {
            player.m_5496_(SoundEvents.f_12015_, 0.6f, 0.5f);
        }
    }

    public static void FindCorrectTool(LocalPlayer player) {
        if (player == null) {
            return;
        }
        SurvivalPlayerSnapshot playerSnapshot = new SurvivalPlayerSnapshot(player);
        int correctToolIndex = playerSnapshot.findCorrectToolInHotbar();
        if (correctToolIndex != -1 && correctToolIndex != playerSnapshot.selectedHotbarIndex) {
            player.m_150109_().f_35977_ = correctToolIndex;
            player.m_5496_(SoundEvents.f_12639_, 0.6f, 1.5f);
        } else if (correctToolIndex == -1) {
            player.m_5496_(SoundEvents.f_12628_, 0.6f, 0.5f);
        }
    }
}

