/*
 * Decompiled with CFR 0.152.
 */
package com.dudenduke.hudalternatives.minimalmodern;

import com.dudenduke.hudalternatives.common.Dimensions;
import com.dudenduke.hudalternatives.common.LivingVehicleType;
import com.dudenduke.hudalternatives.common.PlayerMountData;
import com.dudenduke.hudalternatives.common.Sprite;
import com.dudenduke.hudalternatives.common.SurvivalPlayerSnapshot;
import com.dudenduke.hudalternatives.common.Vector2;
import com.dudenduke.hudalternatives.minimalmodern.MM_Configuration;
import com.dudenduke.hudalternatives.minimalmodern.MM_Sprites;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.time.Duration;
import java.time.Instant;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import org.joml.Matrix4f;

public class MinimalModernOverlay {
    private static final ResourceLocation MINIMAL_MODERN = new ResourceLocation("minimalmodern", "textures/minimal_modern.png");
    private static final Duration horseHpNumbersSolidSeconds = Duration.ofMillis(1500L);
    private static final Duration horseHpNumbersFadeSeconds = Duration.ofMillis(1500L);
    private static final Duration horseHpNumbersShowTime = horseHpNumbersSolidSeconds.plus(horseHpNumbersFadeSeconds);
    public static final IGuiOverlay HUD = new IGuiOverlay(){

        public void render(ForgeGui gui, GuiGraphics guiGraphics, float partialTick, int screenWidth, int screenHeight) {
            boolean separatedBars;
            Vector2 mainScreenAnchor;
            LocalPlayer player = gui.getMinecraft().f_91074_;
            if (player == null) {
                return;
            }
            Dimensions screenDims = new Dimensions(screenWidth, screenHeight);
            SurvivalPlayerSnapshot playerSnapshot = new SurvivalPlayerSnapshot(player);
            PlayerMountData.updateMountData(player);
            Vector2 valueBarAnchorPoint = mainScreenAnchor = MinimalModernOverlay.getMainScreenAnchorPoint(screenDims, MM_Configuration.MainGuiDrawCorner());
            boolean bl = separatedBars = MM_Configuration.SeparateValueBars() && MM_Configuration.ValueBarsDrawCorner() != MM_Configuration.MainGuiDrawCorner();
            if (separatedBars) {
                if (MM_Configuration.MainGuiDrawCorner() == 1 || MM_Configuration.MainGuiDrawCorner() == 3) {
                    int adjustedX = mainScreenAnchor.x() + MM_Sprites.ValueBarsBackground.width() - MM_Sprites.SmallHex.width() / 2 - 1;
                    mainScreenAnchor = new Vector2(adjustedX, mainScreenAnchor.y());
                }
                valueBarAnchorPoint = MinimalModernOverlay.getSeparatedValueBarsAnchorPoint(screenDims, MM_Configuration.ValueBarsDrawCorner());
                MinimalModernOverlay.renderValueBarsBackground(guiGraphics, valueBarAnchorPoint);
            } else {
                MinimalModernOverlay.renderValueBarsBackground(guiGraphics, mainScreenAnchor);
            }
            MinimalModernOverlay.renderMainHex(guiGraphics, mainScreenAnchor);
            MinimalModernOverlay.renderHotbarHexes(guiGraphics, mainScreenAnchor);
            MinimalModernOverlay.renderActiveItem(gui, guiGraphics, playerSnapshot, mainScreenAnchor);
            MinimalModernOverlay.renderAdjacentItems(gui, guiGraphics, playerSnapshot, mainScreenAnchor);
            MinimalModernOverlay.renderHealthBar(guiGraphics, valueBarAnchorPoint, playerSnapshot.health, playerSnapshot.maxHealth, playerSnapshot.healthEffect);
            MinimalModernOverlay.renderGoldenHealthBar(guiGraphics, valueBarAnchorPoint, playerSnapshot.absorption);
            MinimalModernOverlay.renderFoodBar(guiGraphics, valueBarAnchorPoint, playerSnapshot.foodLevel, playerSnapshot.maxFoodLevel, playerSnapshot.hungerEffect);
            MinimalModernOverlay.renderFoodSaturationBar(guiGraphics, valueBarAnchorPoint, playerSnapshot.saturation, playerSnapshot.maxFoodLevel);
            MinimalModernOverlay.renderDrowningBar(guiGraphics, mainScreenAnchor, playerSnapshot.drownPercentage);
            if (PlayerMountData.isPlayerMounted() && PlayerMountData.getMountType() != null) {
                MinimalModernOverlay.renderMountHex(guiGraphics, mainScreenAnchor, PlayerMountData.getMountType());
                Vector2 mountHealthBarAnchorPoint = !separatedBars ? mainScreenAnchor : MinimalModernOverlay.getSeparatedValueBarsAnchorPoint(screenDims, MM_Configuration.ValueBarsDrawCorner());
                MinimalModernOverlay.renderMountHealthBar(gui, guiGraphics, mountHealthBarAnchorPoint, separatedBars, PlayerMountData.getMountHealth(), PlayerMountData.getMountMaxHealth());
            } else {
                MinimalModernOverlay.renderExperienceLevel(gui, guiGraphics, mainScreenAnchor, playerSnapshot.experienceLevel);
            }
        }
    };

    private static Vector2 getMainScreenAnchorPoint(Dimensions screen, int drawCorner) {
        int leftX = 10 + MM_Configuration.MainGuiHorizontalPadding();
        int rightX = screen.width() - MM_Sprites.LargeHex.width() - MM_Sprites.MainHealthBar.width() - 2 - MM_Configuration.MainGuiHorizontalPadding();
        int topY = 19 + MM_Configuration.MainGuiVerticalPadding();
        int bottomY = screen.height() - MM_Sprites.LargeHex.height() - 19 - MM_Configuration.MainGuiVerticalPadding();
        return switch (drawCorner) {
            case 0 -> new Vector2(leftX, topY);
            case 1 -> new Vector2(rightX, topY);
            case 2 -> new Vector2(leftX, bottomY);
            case 3 -> new Vector2(rightX, bottomY);
            default -> new Vector2(leftX, bottomY);
        };
    }

    private static Vector2 getSeparatedValueBarsAnchorPoint(Dimensions screen, int drawCorner) {
        int leftX = 4 - MM_Sprites.LargeHex.width() + MM_Configuration.ValueBarsHorizontalPadding();
        int rightX = screen.width() - MM_Sprites.LargeHex.width() - MM_Sprites.MainHealthBar.width() - 2 - MM_Configuration.ValueBarsHorizontalPadding();
        int topY = 19 - MM_Sprites.SmallHex.height() + MM_Configuration.ValueBarsVerticalPadding();
        int bottomY = screen.height() - MM_Sprites.LargeHex.height() - 19 + MM_Sprites.SmallHex.height() - MM_Configuration.ValueBarsVerticalPadding();
        return switch (drawCorner) {
            case 0 -> new Vector2(leftX, topY);
            case 1 -> new Vector2(rightX, topY);
            case 2 -> new Vector2(leftX, bottomY);
            case 3 -> new Vector2(rightX, bottomY);
            default -> new Vector2(leftX, bottomY);
        };
    }

    private static void renderMainHex(GuiGraphics guiGraphics, Vector2 anchor) {
        guiGraphics.m_280163_(MINIMAL_MODERN, anchor.x(), anchor.y(), (float)MM_Sprites.LargeHex.x(), (float)MM_Sprites.LargeHex.y(), MM_Sprites.LargeHex.width(), MM_Sprites.LargeHex.height(), MM_Sprites.FullSheet.width(), MM_Sprites.FullSheet.height());
    }

    private static void renderValueBarsBackground(GuiGraphics guiGraphics, Vector2 anchor) {
        guiGraphics.m_280163_(MINIMAL_MODERN, anchor.x() + 31, anchor.y() + 11, (float)MM_Sprites.ValueBarsBackground.x(), (float)MM_Sprites.ValueBarsBackground.y(), MM_Sprites.ValueBarsBackground.width(), MM_Sprites.ValueBarsBackground.height(), MM_Sprites.FullSheet.width(), MM_Sprites.FullSheet.height());
    }

    private static void renderHotbarHexes(GuiGraphics guiGraphics, Vector2 anchor) {
        guiGraphics.m_280163_(MINIMAL_MODERN, anchor.x() - 9, anchor.y() - 18, (float)MM_Sprites.SmallHex.x(), (float)MM_Sprites.SmallHex.y(), MM_Sprites.SmallHex.width(), MM_Sprites.SmallHex.height(), MM_Sprites.FullSheet.width(), MM_Sprites.FullSheet.height());
        guiGraphics.m_280163_(MINIMAL_MODERN, anchor.x() + 20, anchor.y() + 30, (float)MM_Sprites.SmallHex.x(), (float)MM_Sprites.SmallHex.y(), MM_Sprites.SmallHex.width(), MM_Sprites.SmallHex.height(), MM_Sprites.FullSheet.width(), MM_Sprites.FullSheet.height());
    }

    private static void renderExperienceLevel(ForgeGui gui, GuiGraphics guiGraphics, Vector2 mainAnchor, int experienceLevel) {
        int green = 59752;
        guiGraphics.m_280056_(gui.m_93082_(), String.valueOf(experienceLevel), mainAnchor.x() + 26, mainAnchor.y() - 3, green, true);
    }

    private static void renderActiveItem(ForgeGui gui, GuiGraphics guiGraphics, SurvivalPlayerSnapshot player, Vector2 mainAnchor) {
        float scaleFactor = 1.5f;
        MinimalModernOverlay._renderItemWithScale(gui, guiGraphics, player.localPlayer, player.mainHandItem, mainAnchor.x() + 8, mainAnchor.y() + 11, 1.5f);
        guiGraphics.m_280370_(gui.m_93082_(), player.mainHandItem, mainAnchor.x() + 8, mainAnchor.y() + 13);
        int blue = 36280;
        guiGraphics.m_280056_(gui.m_93082_(), String.valueOf(player.selectedHotbarIndex + 1), mainAnchor.x() - 7, mainAnchor.y() + 14, blue, true);
    }

    private static void renderAdjacentItems(ForgeGui gui, GuiGraphics guiGraphics, SurvivalPlayerSnapshot player, Vector2 mainAnchor) {
        ItemStack[] hotbar = player.getHotbar();
        ItemStack leftItem = hotbar[Math.floorMod(player.selectedHotbarIndex - 1, 9)];
        ItemStack rightItem = hotbar[Math.floorMod(player.selectedHotbarIndex + 1, 9)];
        guiGraphics.m_280480_(leftItem, mainAnchor.x() - 6, mainAnchor.y() - 14);
        guiGraphics.m_280480_(rightItem, mainAnchor.x() + 23, mainAnchor.y() + 34);
        guiGraphics.m_280370_(gui.m_93082_(), leftItem, mainAnchor.x() - 6, mainAnchor.y() - 14);
        guiGraphics.m_280370_(gui.m_93082_(), rightItem, mainAnchor.x() + 23, mainAnchor.y() + 34);
    }

    private static void renderHealthBar(GuiGraphics guiGraphics, Vector2 mainAnchor, float health, float maxHealth, SurvivalPlayerSnapshot.Effect healthState) {
        Sprite healthBarSprite = healthState == SurvivalPlayerSnapshot.Effect.WITHERED ? MM_Sprites.WitheredHealthBar : (healthState == SurvivalPlayerSnapshot.Effect.POISONED ? MM_Sprites.PoisonedHealthBar : MM_Sprites.MainHealthBar);
        int renderedWidth = (int)((float)healthBarSprite.width() * (health / maxHealth));
        guiGraphics.m_280163_(MINIMAL_MODERN, mainAnchor.x() + 32, mainAnchor.y() + 12, (float)healthBarSprite.x(), (float)healthBarSprite.y(), renderedWidth, healthBarSprite.height(), MM_Sprites.FullSheet.width(), MM_Sprites.FullSheet.height());
    }

    private static void renderGoldenHealthBar(GuiGraphics guiGraphics, Vector2 mainAnchor, float absorption) {
        float maxAbsorption = 20.0f;
        int renderedWidth = (int)((float)MM_Sprites.GoldenHealthBar.width() * (absorption / maxAbsorption));
        guiGraphics.m_280163_(MINIMAL_MODERN, mainAnchor.x() + 32, mainAnchor.y() + 14, (float)MM_Sprites.GoldenHealthBar.x(), (float)MM_Sprites.GoldenHealthBar.y(), renderedWidth, MM_Sprites.GoldenHealthBar.height(), MM_Sprites.FullSheet.width(), MM_Sprites.FullSheet.height());
    }

    private static void renderFoodBar(GuiGraphics guiGraphics, Vector2 mainAnchor, float foodLevel, float maxFoodLevel, SurvivalPlayerSnapshot.Effect hungerState) {
        Sprite hungerBarSprite = hungerState == SurvivalPlayerSnapshot.Effect.HUNGERED ? MM_Sprites.PoisonedHungerBar : MM_Sprites.MainHungerBar;
        int renderedWidth = (int)((float)hungerBarSprite.width() * (foodLevel / maxFoodLevel));
        guiGraphics.m_280163_(MINIMAL_MODERN, mainAnchor.x() + 32, mainAnchor.y() + 20, (float)hungerBarSprite.x(), (float)hungerBarSprite.y(), renderedWidth, hungerBarSprite.height(), MM_Sprites.FullSheet.width(), MM_Sprites.FullSheet.height());
    }

    private static void renderFoodSaturationBar(GuiGraphics guiGraphics, Vector2 mainAnchor, float saturation, float maxFoodLevel) {
        int renderedWidth = (int)((float)MM_Sprites.SaturationHungerBar.width() * (saturation / maxFoodLevel));
        guiGraphics.m_280163_(MINIMAL_MODERN, mainAnchor.x() + 32, mainAnchor.y() + 24, (float)MM_Sprites.SaturationHungerBar.x(), (float)MM_Sprites.SaturationHungerBar.y(), renderedWidth, MM_Sprites.SaturationHungerBar.height(), MM_Sprites.FullSheet.width(), MM_Sprites.FullSheet.height());
    }

    private static void renderDrowningBar(GuiGraphics guiGraphics, Vector2 mainAnchor, float drowningPercent) {
        int removedSpriteHeight = MM_Sprites.DrowingHexSprite.height() - (int)((float)MM_Sprites.DrowingHexSprite.height() * drowningPercent);
        int spriteStartY = removedSpriteHeight + MM_Sprites.DrowingHexSprite.y();
        int spriteHeightRemaining = MM_Sprites.DrowingHexSprite.height() - removedSpriteHeight;
        guiGraphics.m_280163_(MINIMAL_MODERN, mainAnchor.x() + 1, mainAnchor.y() + 1 + removedSpriteHeight, (float)MM_Sprites.DrowingHexSprite.x(), (float)spriteStartY, MM_Sprites.DrowingHexSprite.width(), spriteHeightRemaining, MM_Sprites.FullSheet.width(), MM_Sprites.FullSheet.height());
    }

    private static void renderMountHex(GuiGraphics guiGraphics, Vector2 anchor, LivingVehicleType mountType) {
        guiGraphics.m_280163_(MINIMAL_MODERN, anchor.x() + 19, anchor.y() - 18, (float)MM_Sprites.SmallHex.x(), (float)MM_Sprites.SmallHex.y(), MM_Sprites.SmallHex.width(), MM_Sprites.SmallHex.height(), MM_Sprites.FullSheet.width(), MM_Sprites.FullSheet.height());
        Sprite mountSprite = switch (mountType) {
            case LivingVehicleType.Horse -> MM_Sprites.Horse;
            case LivingVehicleType.Donkey -> MM_Sprites.Donkey;
            case LivingVehicleType.Mule -> MM_Sprites.Donkey;
            case LivingVehicleType.Pig -> MM_Sprites.Pig;
            case LivingVehicleType.Camel -> MM_Sprites.Camel;
            case LivingVehicleType.Skeleton_horse -> MM_Sprites.Skeleton_Horse;
            case LivingVehicleType.Strider -> MM_Sprites.Strider;
            case LivingVehicleType.Unknown -> MM_Sprites.Horse_Silhouette;
            default -> MM_Sprites.Horse_Silhouette;
        };
        guiGraphics.m_280163_(MINIMAL_MODERN, anchor.x() + 20, anchor.y() - 16, (float)mountSprite.x(), (float)mountSprite.y(), mountSprite.width(), mountSprite.height(), MM_Sprites.FullSheet.width(), MM_Sprites.FullSheet.height());
    }

    private static void renderMountHealthBar(ForgeGui gui, GuiGraphics guiGraphics, Vector2 mainAnchor, boolean separatedBars, float health, float maxHealth) {
        int xRef = mainAnchor.x() + 41;
        int yRef = mainAnchor.y() - 8;
        if (separatedBars) {
            xRef = mainAnchor.x() + 31;
            yRef = mainAnchor.y() + 26;
        }
        guiGraphics.m_280163_(MINIMAL_MODERN, xRef, yRef, (float)MM_Sprites.MountHealthBackground.x(), (float)MM_Sprites.MountHealthBackground.y(), MM_Sprites.MountHealthBackground.width(), MM_Sprites.MountHealthBackground.height(), MM_Sprites.FullSheet.width(), MM_Sprites.FullSheet.height());
        int renderedWidth = (int)((float)MM_Sprites.MountHealthBar.width() * (health / maxHealth));
        guiGraphics.m_280163_(MINIMAL_MODERN, xRef + 1, yRef + 1, (float)MM_Sprites.MountHealthBar.x(), (float)MM_Sprites.MountHealthBar.y(), renderedWidth, MM_Sprites.MountHealthBar.height(), MM_Sprites.FullSheet.width(), MM_Sprites.FullSheet.height());
        if (MinimalModernOverlay.shouldShowHorseHpNumber()) {
            int alpha = MinimalModernOverlay.getHorseHpNumbersAlpha();
            int threeBytes = 24;
            int orange = alpha << 24 | 0xD65410;
            guiGraphics.m_280056_(gui.m_93082_(), String.valueOf(health), xRef + 3, yRef + 6, orange, true);
            int hpWidth = gui.m_93082_().m_92895_(String.valueOf(health)) + 3;
            int gray = alpha << 24 | 0x5C5C5C;
            guiGraphics.m_280056_(gui.m_93082_(), "/" + maxHealth, xRef + hpWidth, yRef + 6, gray, true);
        }
    }

    private static boolean shouldShowHorseHpNumber() {
        Instant now = Instant.now();
        boolean toShow = now.isBefore(PlayerMountData.getWhenPlayerMounted().plus(horseHpNumbersShowTime));
        if (toShow) {
            return true;
        }
        return PlayerMountData.getWhenMountDamagedWhileRiding() != null && now.isBefore(PlayerMountData.getWhenMountDamagedWhileRiding().plus(horseHpNumbersShowTime));
    }

    private static int getHorseHpNumbersAlpha() {
        Instant now = Instant.now();
        if (now.isBefore(PlayerMountData.getWhenPlayerMounted().plus(horseHpNumbersSolidSeconds))) {
            return 255;
        }
        if (PlayerMountData.getWhenMountDamagedWhileRiding() != null && now.isBefore(PlayerMountData.getWhenMountDamagedWhileRiding().plus(horseHpNumbersSolidSeconds))) {
            return 255;
        }
        if (now.isBefore(PlayerMountData.getWhenPlayerMounted().plus(horseHpNumbersShowTime))) {
            Duration elapsedSinceMounted = Duration.between(PlayerMountData.getWhenPlayerMounted().plus(horseHpNumbersSolidSeconds), now);
            return MinimalModernOverlay.calculateAlpha(elapsedSinceMounted, horseHpNumbersFadeSeconds);
        }
        if (PlayerMountData.getWhenMountDamagedWhileRiding() != null && now.isBefore(PlayerMountData.getWhenMountDamagedWhileRiding().plus(horseHpNumbersShowTime))) {
            Duration elapsedSinceDamaged = Duration.between(PlayerMountData.getWhenMountDamagedWhileRiding().plus(horseHpNumbersSolidSeconds), now);
            return MinimalModernOverlay.calculateAlpha(elapsedSinceDamaged, horseHpNumbersFadeSeconds);
        }
        return 255;
    }

    private static int calculateAlpha(Duration elapsedTime, Duration totalDuration) {
        double fade = (double)elapsedTime.toNanos() / (double)totalDuration.toNanos() * 255.0;
        return Math.max(255 - (int)fade, 25);
    }

    private static void _renderItemWithScale(ForgeGui gui, GuiGraphics guiGraphics, LocalPlayer player, ItemStack itemStack, int x, int y, float scaleFactor) {
        MinimalModernOverlay._renderItemWithScale(gui.getMinecraft(), guiGraphics.m_280091_(), guiGraphics.m_280168_(), (LivingEntity)player, (Level)gui.getMinecraft().f_91073_, itemStack, x, y, scaleFactor);
    }

    private static void _renderItemWithScale(Minecraft minecraft, MultiBufferSource.BufferSource bufferSource, PoseStack pose, LivingEntity pEntity, Level pLevel, ItemStack pStack, int pX, int pY, float scaleFactor) {
        if (!pStack.m_41619_()) {
            boolean flag;
            BakedModel bakedmodel = minecraft.m_91291_().m_174264_(pStack, pLevel, pEntity, 0);
            pose.m_85836_();
            pose.m_252880_((float)(pX + 8), (float)(pY + 8), 150.0f);
            pose.m_252931_(new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
            float adjustedScale = 16.0f * scaleFactor;
            pose.m_85841_(adjustedScale, adjustedScale, adjustedScale);
            boolean bl = flag = !bakedmodel.m_7547_();
            if (flag) {
                Lighting.m_84930_();
            }
            minecraft.m_91291_().m_115143_(pStack, ItemDisplayContext.GUI, false, pose, (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.f_118083_, bakedmodel);
            RenderSystem.disableDepthTest();
            bufferSource.m_109911_();
            RenderSystem.enableDepthTest();
            if (flag) {
                Lighting.m_84931_();
            }
            pose.m_85849_();
        }
    }
}

