/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.capture.task;

import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.ExposureClient;
import io.github.mortuusars.exposure.client.capture.Capture;
import io.github.mortuusars.exposure.client.capture.CaptureShader;
import io.github.mortuusars.exposure.client.image.Image;
import io.github.mortuusars.exposure.client.image.WrappedNativeImage;
import io.github.mortuusars.exposure.client.util.Minecrft;
import io.github.mortuusars.exposure.client.util.Shader;
import io.github.mortuusars.exposure.util.cycles.task.Result;
import io.github.mortuusars.exposure.util.cycles.task.Task;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_276;
import net.minecraft.class_279;
import net.minecraft.class_310;
import net.minecraft.class_318;
import net.minecraft.class_6367;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BackgroundScreenshotCaptureTask
extends Task<Result<Image>> {
    private static boolean capturing = false;
    @Nullable
    private static class_276 renderTarget = null;

    public static boolean isCapturing() {
        return capturing && renderTarget != null;
    }

    @NotNull
    public static class_276 getRenderTarget() {
        return Objects.requireNonNull(renderTarget);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Result<Image>> execute() {
        if (ExposureClient.shouldUseDirectCapture()) {
            Exposure.LOGGER.warn("BackgroundScreenshotCaptureMethod is used while incompatible mods are installed. Captured image most likely will not look as expected.");
        }
        class_310 minecraft = Minecrft.get();
        renderTarget = new class_6367(minecraft.method_22683().method_4489(), minecraft.method_22683().method_4506(), true, class_310.field_1703);
        renderTarget.method_1236(0.0f, 0.0f, 0.0f, 0.0f);
        renderTarget.method_1230(class_310.field_1703);
        try {
            capturing = true;
            minecraft.field_1773.method_35770(true);
            minecraft.field_1773.method_35769(false);
            minecraft.field_1769.method_35774();
            renderTarget.method_1235(false);
            minecraft.field_1773.method_3188(minecraft.method_60646());
            this.applyShaderEffects(renderTarget);
            WrappedNativeImage image = new WrappedNativeImage(class_318.method_1663((class_276)renderTarget));
            CompletableFuture<Result<Image>> completableFuture = CompletableFuture.completedFuture(Result.success(image));
            return completableFuture;
        }
        catch (Exception e) {
            Exposure.LOGGER.error("Couldn't capture image: ", (Throwable)e);
            CompletableFuture<Result<Image>> completableFuture = CompletableFuture.completedFuture(Result.error(Capture.ERROR_FAILED_GENERIC));
            return completableFuture;
        }
        finally {
            minecraft.field_1773.method_35770(false);
            minecraft.field_1773.method_35769(true);
            renderTarget.method_1238();
            renderTarget.method_1240();
            renderTarget = null;
            capturing = false;
            minecraft.field_1769.method_35774();
            minecraft.method_1522().method_1235(true);
        }
    }

    private void applyShaderEffects(class_276 renderTarget) {
        @Nullable class_279 effect = class_310.method_1551().field_1773.method_3183();
        if (effect != null && class_310.method_1551().field_1773.field_4013) {
            Shader.process(effect, renderTarget);
        }
        CaptureShader.process(renderTarget);
    }
}

