/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.render;

import io.github.mortuusars.exposure.ExposureClient;
import io.github.mortuusars.exposure.PlatformHelperClient;
import io.github.mortuusars.exposure.client.util.Minecrft;
import io.github.mortuusars.exposure.world.entity.CameraStandEntity;
import io.github.mortuusars.exposure.world.item.camera.CameraItem;
import net.minecraft.class_1087;
import net.minecraft.class_1091;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_776;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_897;
import org.jetbrains.annotations.NotNull;

public class CameraStandEntityRenderer<T extends CameraStandEntity>
extends class_897<T> {
    public static final class_2960 TEXTURE_LOCATION = class_2960.method_60656((String)"textures/item/camera.png");
    public static final float MOUNT_SCALE = 0.9f;
    protected final class_776 blockRenderer;

    public CameraStandEntityRenderer(class_5617.class_5618 context) {
        super(context);
        this.blockRenderer = context.method_43337();
    }

    @NotNull
    public class_2960 getTextureLocation(T entity) {
        return TEXTURE_LOCATION;
    }

    public void render(T entity, float entityYaw, float partialTick, class_4587 poseStack, class_4597 bufferSource, int packedLight) {
        super.method_3936(entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
        float hurtTime = (float)((CameraStandEntity)entity).getHurtTime() - partialTick;
        float damage = Math.max(0.0f, ((CameraStandEntity)entity).getDamage() - partialTick);
        if (hurtTime > 0.0f) {
            float rotation = class_3532.method_15374((float)hurtTime) * hurtTime * damage / 10.0f * (float)((CameraStandEntity)entity).getHurtDir();
            poseStack.method_22907(class_7833.field_40716.rotationDegrees(rotation));
            poseStack.method_22907(class_7833.field_40714.rotationDegrees(rotation));
        }
        float entityPitch = class_3532.method_16439((float)partialTick, (float)((CameraStandEntity)entity).field_6004, (float)entity.method_36455());
        this.renderStand(entity, entityYaw, entityPitch, partialTick, poseStack, bufferSource, packedLight);
        this.renderMount(entity, entityYaw, entityPitch, partialTick, poseStack, bufferSource, packedLight);
        if (!((CameraStandEntity)entity).getCamera().method_7960()) {
            this.renderCamera(entity, entityYaw, entityPitch, partialTick, poseStack, bufferSource, packedLight);
        }
    }

    private void renderStand(T entity, float entityYaw, float entityPitch, float partialTick, class_4587 poseStack, class_4597 bufferSource, int packedLight) {
        poseStack.method_22903();
        if (entity.method_5854() != null) {
            float vehicleRot = class_3532.method_16439((float)partialTick, (float)entity.method_5854().field_5982, (float)entity.method_5854().method_36454());
            poseStack.method_22907(class_7833.field_40716.rotationDegrees(-vehicleRot + 45.0f));
        }
        poseStack.method_46416(-0.5f, 0.0f, -0.5f);
        class_1091 modelLocation = ExposureClient.Models.CAMERA_STAND;
        class_1087 model = PlatformHelperClient.getModel(modelLocation);
        this.blockRenderer.method_3350().method_3367(poseStack.method_23760(), bufferSource.getBuffer(class_1921.method_23577()), null, model, 1.0f, 1.0f, 1.0f, packedLight, class_4608.field_21444);
        poseStack.method_22909();
    }

    private void renderMount(T entity, float entityYaw, float entityPitch, float partialTick, class_4587 poseStack, class_4597 bufferSource, int packedLight) {
        poseStack.method_22903();
        poseStack.method_22904(0.0, 1.125, 0.0);
        float scale = 0.9f;
        poseStack.method_22905(scale, scale, scale);
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(-entityYaw + 180.0f));
        poseStack.method_22907(class_7833.field_40714.rotationDegrees(-entityPitch));
        if (((CameraStandEntity)entity).isMalfunctioned()) {
            poseStack.method_22907(class_7833.field_40718.rotationDegrees(-50.0f));
            poseStack.method_22907(class_7833.field_40714.rotationDegrees(-10.0f));
        }
        poseStack.method_46416(-0.5f, 0.0f, -0.5f);
        class_1091 mountModelLocation = ExposureClient.Models.CAMERA_STAND_MOUNT;
        class_1087 mountModel = PlatformHelperClient.getModel(mountModelLocation);
        this.blockRenderer.method_3350().method_3367(poseStack.method_23760(), bufferSource.getBuffer(class_1921.method_23577()), null, mountModel, 1.0f, 1.0f, 1.0f, packedLight, class_4608.field_21444);
        poseStack.method_22909();
    }

    private void renderCamera(T entity, float entityYaw, float entityPitch, float partialTick, class_4587 poseStack, class_4597 bufferSource, int packedLight) {
        float f;
        class_1799 camera;
        class_1792 class_17922;
        poseStack.method_22903();
        poseStack.method_22904(0.0, 1.125, 0.0);
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(-entityYaw + 180.0f));
        poseStack.method_22907(class_7833.field_40714.rotationDegrees(-entityPitch));
        poseStack.method_22904(0.0, (double)0.1125f, 0.0);
        if (((CameraStandEntity)entity).isMalfunctioned()) {
            poseStack.method_22907(class_7833.field_40718.rotationDegrees(-50.0f));
            poseStack.method_22907(class_7833.field_40714.rotationDegrees(-15.0f));
        }
        if ((class_17922 = (camera = ((CameraStandEntity)entity).getCamera()).method_7909()) instanceof CameraItem) {
            CameraItem cameraItem = (CameraItem)class_17922;
            f = cameraItem.getScaleOnStand();
        } else {
            f = 0.9f;
        }
        float scale = f;
        poseStack.method_22905(scale, scale, scale);
        poseStack.method_22904(0.0, 0.5, 0.0);
        Minecrft.get().method_1480().method_23178(camera, class_811.field_4315, packedLight, class_4608.field_21444, poseStack, bufferSource, entity.method_37908(), 0);
        poseStack.method_22909();
    }
}

