/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.render.image;

import com.mojang.blaze3d.platform.TextureUtil;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.client.image.renderable.RenderableImage;
import io.github.mortuusars.exposure.util.color.Color;
import java.util.function.Function;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4668;
import net.minecraft.class_7368;
import net.minecraft.class_7764;
import net.minecraft.class_7771;
import org.joml.Matrix4f;

public class RenderedImageInstance
implements AutoCloseable {
    private static final Function<class_2960, class_1921> TEXT_MIPMAP = class_156.method_34866(texture -> class_1921.method_24049((String)"exposure_mipmap", (class_293)class_290.field_20888, (class_293.class_5596)class_293.class_5596.field_27382, (int)786432, (boolean)false, (boolean)true, (class_1921.class_4688)class_1921.class_4688.method_23598().method_34578(class_1921.field_29427).method_34577((class_4668.class_5939)new class_4668.class_4683(texture, false, true)).method_23615(class_1921.field_21370).method_23608(class_1921.field_21383).method_23617(false)));
    protected final class_2960 textureLocation;
    protected RenderableImage image;
    protected class_1043 texture;
    protected final class_1921 renderType;
    protected boolean requiresUpload = true;

    RenderedImageInstance(RenderableImage image) {
        this.image = image;
        this.texture = new class_1043(image.width(), image.height(), true);
        this.textureLocation = image.getIdentifier().toResourceLocation();
        class_310.method_1551().method_1531().method_4616(this.textureLocation, (class_1044)this.texture);
        int mipmapLevel = (Integer)class_310.method_1551().field_1690.method_42563().method_41753();
        this.renderType = mipmapLevel > 0 ? TEXT_MIPMAP.apply(this.textureLocation) : class_1921.method_23028((class_2960)this.textureLocation);
        this.forceUpload();
    }

    public void replaceData(RenderableImage image) {
        boolean hasChanged = !image.getIdentifier().equals(this.image.getIdentifier());
        this.image = image;
        if (hasChanged) {
            this.texture = new class_1043(image.width(), image.height(), true);
            this.forceUpload();
        }
    }

    public void forceUpload() {
        this.requiresUpload = true;
    }

    protected void updateTexture() {
        if (this.texture.method_4525() == null) {
            return;
        }
        int width = this.image.width();
        int height = this.image.height();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int ARGB = this.image.getPixelARGB(x, y);
                this.texture.method_4525().method_4305(x, y, Color.ABGRtoARGB(ARGB));
            }
        }
        int mipmapLevel = (Integer)class_310.method_1551().field_1690.method_42563().method_41753();
        if (mipmapLevel > 0 && width > 2 && height > 2) {
            this.applyMipMap(mipmapLevel, width, height);
        }
        this.texture.method_4524();
    }

    private void applyMipMap(int mipmapLevel, int width, int height) {
        if (this.texture.method_4525() == null) {
            return;
        }
        try {
            this.texture.method_4527(false, true);
            TextureUtil.prepareImage((int)this.texture.method_4624(), (int)mipmapLevel, (int)width, (int)height);
            class_7764 spriteContents = new class_7764(this.textureLocation, new class_7771(width, height), this.texture.method_4525(), class_7368.field_38688);
            spriteContents.method_45808(mipmapLevel);
            spriteContents.method_45809(0, 0);
        }
        catch (Exception e) {
            Exposure.LOGGER.error("Failed to generate mipmaps: {}", (Object)e.getMessage());
        }
    }

    public void draw(class_4587 poseStack, class_4597 bufferSource, float minX, float minY, float maxX, float maxY, float minU, float minV, float maxU, float maxV, int packedLight, int r, int g, int b, int a) {
        if (this.requiresUpload) {
            this.updateTexture();
            this.requiresUpload = false;
        }
        Matrix4f matrix4f = poseStack.method_23760().method_23761();
        class_4588 vertexConsumer = bufferSource.getBuffer(this.renderType);
        vertexConsumer.method_22918(matrix4f, minX, maxY, 0.0f).method_1336(r, g, b, a).method_22913(minU, maxV).method_60803(packedLight);
        vertexConsumer.method_22918(matrix4f, maxX, maxY, 0.0f).method_1336(r, g, b, a).method_22913(maxU, maxV).method_60803(packedLight);
        vertexConsumer.method_22918(matrix4f, maxX, minY, 0.0f).method_1336(r, g, b, a).method_22913(maxU, minV).method_60803(packedLight);
        vertexConsumer.method_22918(matrix4f, minX, minY, 0.0f).method_1336(r, g, b, a).method_22913(minU, minV).method_60803(packedLight);
    }

    @Override
    public void close() {
        class_310.method_1551().method_1531().method_4615(this.textureLocation);
        this.texture.close();
    }
}

