/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.task;

import com.mojang.logging.LogUtils;
import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.ExposureClient;
import io.github.mortuusars.exposure.client.export.ImageExporter;
import io.github.mortuusars.exposure.client.image.modifier.ImageEffect;
import io.github.mortuusars.exposure.client.util.Minecrft;
import io.github.mortuusars.exposure.data.export.ExportLook;
import io.github.mortuusars.exposure.data.export.ExportSize;
import io.github.mortuusars.exposure.util.cycles.task.Result;
import io.github.mortuusars.exposure.util.cycles.task.Task;
import io.github.mortuusars.exposure.world.level.storage.ExposureData;
import io.github.mortuusars.exposure.world.level.storage.RequestedPalettedExposure;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class ExportExposuresTask
extends Task<Result<Boolean>> {
    private static final Logger LOGGER = LogUtils.getLogger();
    @Nullable
    private static ExportExposuresTask currentTask;
    protected final List<String> ids;
    protected final ExportSize size;
    protected final ExportLook look;
    @Nullable
    protected CompletableFuture<Result<Boolean>> future;
    protected boolean stop;

    public ExportExposuresTask(List<String> ids, ExportSize size, ExportLook look) {
        this.ids = ids;
        this.size = size;
        this.look = look;
    }

    public static boolean isRunning() {
        return currentTask != null;
    }

    public static boolean start(List<String> ids, ExportSize size, ExportLook look) {
        if (ExportExposuresTask.isRunning()) {
            Minecrft.player().method_7353((class_2561)class_2561.method_43471((String)"task.exposure.export.already_running"), false);
            return false;
        }
        ExposureClient.cycles().addParallelTask(new ExportExposuresTask(ids, size, look));
        return true;
    }

    public static boolean stopCurrentTask() {
        if (currentTask != null) {
            ExportExposuresTask.currentTask.stop = true;
            return true;
        }
        return false;
    }

    @Override
    public CompletableFuture<Result<Boolean>> execute() {
        currentTask = this;
        if (this.future == null) {
            this.future = CompletableFuture.supplyAsync(() -> {
                try {
                    Result<Boolean> result = this.export();
                    return result;
                }
                finally {
                    currentTask = null;
                }
            });
            this.setStarted();
        }
        return this.future;
    }

    protected Result<Boolean> export() {
        int total = this.ids.size();
        AtomicInteger exported = new AtomicInteger();
        this.print(class_2561.method_43469((String)"task.exposure.export.started", (Object[])new Object[]{total}));
        for (String id : this.ids) {
            if (this.stop) {
                this.print(class_2561.method_43471((String)"task.exposure.export.stopped"));
                return Result.success(false);
            }
            ExposureData exposure = null;
            for (int attempt = 0; attempt < 50; ++attempt) {
                this.updateStatus(class_2561.method_43469((String)"task.exposure.export.status.requesting", (Object[])new Object[]{id, exported, total}));
                RequestedPalettedExposure request = ExposureClient.exposureStore().getOrRequest(id);
                if (request.getData().isPresent()) {
                    exposure = request.getData().get();
                    break;
                }
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (exposure == null) {
                this.print(class_2561.method_43469((String)"task.exposure.export.error.not_received", (Object[])new Object[]{id}));
                continue;
            }
            this.updateStatus(class_2561.method_43469((String)"task.exposure.export.status.exporting", (Object[])new Object[]{id, exported, total}));
            try {
                String fileName = id + this.look.getIdSuffix();
                new ImageExporter(exposure, fileName).modify(ImageEffect.chain(this.look.getModifier(), ImageEffect.Resize.multiplier(this.size.getMultiplier()))).toExposuresFolder().organizeByWorld((Boolean)Config.Client.EXPORT_ORGANIZE_BY_WORLD.get()).setCreationDate(exposure.getTag().unixTimestamp()).onExport(file -> {
                    exported.getAndIncrement();
                    this.print(class_2561.method_43471((String)"task.exposure.export.exported").method_27693("'" + fileName + "'").method_27696(class_2583.field_24360.method_30938(Boolean.valueOf(true)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"Open"))).method_10958(new class_2558(class_2558.class_2559.field_11746, file.getAbsolutePath()))));
                }).export();
            }
            catch (Exception e) {
                this.print(class_2561.method_43469((String)"task.exposure.export.error", (Object[])new Object[]{id, e.getMessage()}));
                LOGGER.error("Failed to export exposure '{}': ", (Object)id, (Object)e);
            }
        }
        if (exported.get() > 0) {
            this.print(class_2561.method_43469((String)"task.exposure.export.result", (Object[])new Object[]{total}));
        } else {
            this.print(class_2561.method_43471((String)"task.exposure.export.none_exported"));
        }
        this.updateStatus(class_2561.method_43473());
        return Result.success(true);
    }

    protected void print(class_5250 message) {
        Minecrft.execute(() -> Minecrft.player().method_7353((class_2561)message, false));
    }

    protected void updateStatus(class_5250 status) {
        Minecrft.execute(() -> Minecrft.player().method_7353((class_2561)status, true));
    }
}

