/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.util;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.mortuusars.exposure.util.Rect2f;
import java.util.Objects;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import net.minecraft.class_757;
import net.minecraft.class_9801;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class GuiUtil {
    public static void blit(class_4587 poseStack, Rect2f rect, int u, int v, int textureWidth, int textureHeight, float zOffset) {
        GuiUtil.blit(null, poseStack, rect, u, v, textureWidth, textureHeight, zOffset);
    }

    public static void blit(@Nullable class_2960 texture, class_4587 poseStack, Rect2f rect, int u, int v, int textureWidth, int textureHeight, float zOffset) {
        GuiUtil.blit(texture, poseStack, rect.x, rect.y, rect.width, rect.height, u, v, textureWidth, textureHeight, zOffset);
    }

    public static void blit(class_4587 poseStack, float x, float y, float width, float height, int u, int v, int textureWidth, int textureHeight, float zOffset) {
        GuiUtil.blit(null, poseStack, x, y, width, height, u, v, textureWidth, textureHeight, zOffset);
    }

    public static void blit(@Nullable class_2960 texture, class_4587 poseStack, float x, float y, float width, float height, int u, int v, int textureWidth, int textureHeight, float zOffset) {
        GuiUtil.blit(texture, poseStack, x, x + width, y, y + height, zOffset, (float)u / (float)textureWidth, ((float)u + width) / (float)textureWidth, (float)v / (float)textureHeight, ((float)v + height) / (float)textureHeight);
    }

    public static void blit(class_4587 poseStack, float minX, float maxX, float minY, float maxY, float zOffset, float minU, float maxU, float minV, float maxV) {
        GuiUtil.blit(null, poseStack, minX, maxX, minY, maxY, zOffset, minU, maxU, minV, maxV);
    }

    private static void blit(@Nullable class_2960 texture, class_4587 poseStack, float minX, float maxX, float minY, float maxY, float zOffset, float minU, float maxU, float minV, float maxV) {
        if (texture != null) {
            RenderSystem.setShaderTexture((int)0, (class_2960)texture);
        }
        Matrix4f matrix = poseStack.method_23760().method_23761();
        RenderSystem.setShader(class_757::method_34542);
        class_287 bufferBuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1585);
        bufferBuilder.method_22918(matrix, minX, maxY, zOffset).method_22913(minU, maxV);
        bufferBuilder.method_22918(matrix, maxX, maxY, zOffset).method_22913(maxU, maxV);
        bufferBuilder.method_22918(matrix, maxX, minY, zOffset).method_22913(maxU, minV);
        bufferBuilder.method_22918(matrix, minX, minY, zOffset).method_22913(minU, minV);
        class_286.method_43433((class_9801)bufferBuilder.method_60800());
    }

    public static void drawRect(class_332 guiGraphics, Rect2f rect, int color) {
        GuiUtil.drawRect(guiGraphics, rect.x, rect.y, rect.width, rect.height, color);
    }

    public static void drawRect(class_332 guiGraphics, float x, float y, float width, float height, int color) {
        GuiUtil.drawRect(guiGraphics.method_51448(), x, y, x + width, y + height, color);
    }

    public static void drawRect(class_4587 poseStack, float minX, float minY, float maxX, float maxY, int color) {
        float temp;
        if (minX < maxX) {
            temp = minX;
            minX = maxX;
            maxX = temp;
        }
        if (minY < maxY) {
            temp = minY;
            minY = maxY;
            maxY = temp;
        }
        Matrix4f matrix = poseStack.method_23760().method_23761();
        RenderSystem.setShader(class_757::method_34540);
        class_287 bufferBuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        bufferBuilder.method_22918(matrix, minX, maxY, 0.0f).method_39415(color);
        bufferBuilder.method_22918(matrix, maxX, maxY, 0.0f).method_39415(color);
        bufferBuilder.method_22918(matrix, maxX, minY, 0.0f).method_39415(color);
        bufferBuilder.method_22918(matrix, minX, minY, 0.0f).method_39415(color);
        class_286.method_43433((class_9801)bufferBuilder.method_60800());
    }

    public static void renderScrollingString(class_332 guiGraphics, class_327 font, class_2561 text, int x, int y, int width, int color) {
        Objects.requireNonNull(font);
        GuiUtil.renderScrollingString(guiGraphics, font, text, x, y, x + width, y + 9, color);
    }

    public static void renderScrollingString(class_332 guiGraphics, class_327 font, class_2561 text, int minX, int minY, int maxX, int maxY, int color) {
        GuiUtil.renderScrollingString(guiGraphics, font, text, (minX + maxX) / 2, minX, minY, maxX, maxY, color);
    }

    public static void renderScrollingString(class_332 guiGraphics, class_327 font, class_2561 text, int centerX, int minX, int minY, int maxX, int maxY, int color) {
        int fontWidth = font.method_27525((class_5348)text);
        int y = (minY + maxY - 9) / 2 + 1;
        int width = maxX - minX;
        if (fontWidth > width) {
            int remaining = fontWidth - width;
            double d = (double)class_156.method_658() / 400.0;
            double e = Math.max((double)remaining * 0.5, 3.0);
            double f = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * d / e)) / 2.0 + 0.5;
            double g = class_3532.method_16436((double)f, (double)0.0, (double)remaining);
            guiGraphics.method_44379(minX, minY, maxX, maxY);
            guiGraphics.method_51439(font, text, minX - (int)g, y, color, false);
            guiGraphics.method_44380();
        } else {
            int l = class_3532.method_15340((int)centerX, (int)(minX + fontWidth / 2), (int)(maxX - fontWidth / 2));
            guiGraphics.method_27534(font, text, l, y, color);
        }
    }
}

