/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.mixin.client;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import io.github.mortuusars.exposure.client.camera.CameraClient;
import io.github.mortuusars.exposure.client.camera.viewfinder.ViewfinderCameraControlsScreen;
import io.github.mortuusars.exposure.client.capture.task.BackgroundScreenshotCaptureTask;
import io.github.mortuusars.exposure.event.ClientEvents;
import io.github.mortuusars.exposure.network.Packets;
import io.github.mortuusars.exposure.network.packet.serverbound.ActiveCameraReleaseC2SP;
import io.github.mortuusars.exposure.world.camera.Camera;
import io.github.mortuusars.exposure.world.camera.CameraOnStand;
import net.minecraft.class_276;
import net.minecraft.class_310;
import net.minecraft.class_434;
import net.minecraft.class_437;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_310.class})
public abstract class MinecraftMixin {
    @Shadow
    @Nullable
    public class_746 field_1724;
    @Shadow
    @Nullable
    public class_638 field_1687;
    @Shadow
    @Nullable
    public class_437 field_1755;

    @Inject(method={"startUseItem"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/player/LocalPlayer;isHandsBusy()Z")}, cancellable=true)
    void onStartUseItem(CallbackInfo ci) {
        CameraOnStand cameraOnStand;
        if (this.field_1724 == null || this.field_1724.method_3144()) {
            return;
        }
        if (this.field_1755 instanceof ViewfinderCameraControlsScreen) {
            return;
        }
        Camera camera = this.field_1724.getActiveExposureCamera();
        if (camera instanceof CameraOnStand && (cameraOnStand = (CameraOnStand)camera).isActive()) {
            cameraOnStand.release();
            Packets.sendToServer(ActiveCameraReleaseC2SP.INSTANCE);
            ci.cancel();
        }
    }

    @Inject(method={"startAttack"}, at={@At(value="HEAD")}, cancellable=true)
    void onStartAttack(CallbackInfoReturnable<Boolean> cir) {
        if (this.field_1724 != null && this.field_1724.getActiveExposureCamera() instanceof CameraOnStand) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"setScreen"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/Screen;added()V")})
    void onSetScreen(class_437 screen, CallbackInfo ci) {
        if (this.field_1724 != null && CameraClient.isActive() && !(screen instanceof ViewfinderCameraControlsScreen)) {
            CameraClient.deactivate();
        }
    }

    @Inject(method={"setLevel"}, at={@At(value="HEAD")})
    void onLevelUnload(class_638 newLevel, class_434.class_9678 reason, CallbackInfo ci) {
        if (this.field_1687 != null) {
            ClientEvents.levelUnloaded();
        }
    }

    @Inject(method={"disconnect(Lnet/minecraft/client/gui/screens/Screen;Z)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/GameRenderer;resetData()V", shift=At.Shift.AFTER)})
    void disconnect(class_437 nextScreen, boolean keepResourcePacks, CallbackInfo ci) {
        ClientEvents.disconnect();
    }

    @ModifyReturnValue(method={"getMainRenderTarget"}, at={@At(value="RETURN")})
    class_276 onGetMainRenderTarget(class_276 original) {
        if (BackgroundScreenshotCaptureTask.isCapturing()) {
            return BackgroundScreenshotCaptureTask.getRenderTarget();
        }
        return original;
    }
}

