/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.world.camera.capture;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.mortuusars.exposure.util.Codecs;
import io.github.mortuusars.exposure.util.ExtraData;
import io.github.mortuusars.exposure.world.camera.CameraId;
import io.github.mortuusars.exposure.world.camera.ColorChannel;
import io.github.mortuusars.exposure.world.camera.capture.Projection;
import io.github.mortuusars.exposure.world.camera.component.ShutterSpeed;
import io.github.mortuusars.exposure.world.camera.film.properties.FilmProperties;
import io.github.mortuusars.exposure.world.entity.CameraHolder;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record CaptureParameters(String exposureId, Optional<CameraId> cameraId, Optional<Integer> cameraHolderId, Optional<Double> fov, float cropFactor, Optional<class_2960> filter, Optional<Projection> projection, Optional<ColorChannel> singleChannel, FilmProperties filmProperties, ExtraData extraData) {
    public static final ExtraData.Type<ShutterSpeed> SHUTTER_SPEED = ExtraData.Type.stringRepresentable("shutter_speed", ShutterSpeed::new);
    public static final ExtraData.Type<Boolean> FLASH = new ExtraData.Type<Boolean>("flash", class_2487::method_10577, class_2487::method_10556);
    public static final ExtraData.Type<Integer> LIGHT_LEVEL = new ExtraData.Type<Integer>("light_level", class_2487::method_10550, class_2487::method_10569);
    public static final Codec<CaptureParameters> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("id").forGetter(CaptureParameters::exposureId), (App)CameraId.CODEC.optionalFieldOf("camera_id").forGetter(CaptureParameters::cameraId), (App)Codec.INT.optionalFieldOf("camera_holder_id").forGetter(CaptureParameters::cameraHolderId), (App)Codecs.POSITIVE_DOUBLE.optionalFieldOf("fov").forGetter(CaptureParameters::fov), (App)Codecs.floatRange(0.001f, 1.0f).optionalFieldOf("crop_factor", (Object)Float.valueOf(1.0f)).forGetter(CaptureParameters::cropFactor), (App)class_2960.field_25139.optionalFieldOf("filter").forGetter(CaptureParameters::filter), (App)Projection.CODEC.optionalFieldOf("projection").forGetter(CaptureParameters::projection), (App)ColorChannel.CODEC.optionalFieldOf("single_channel").forGetter(CaptureParameters::singleChannel), (App)FilmProperties.CODEC.optionalFieldOf("film", (Object)FilmProperties.EMPTY).forGetter(CaptureParameters::filmProperties), (App)ExtraData.CODEC.optionalFieldOf("extra_data", (Object)ExtraData.EMPTY).forGetter(CaptureParameters::extraData)).apply((Applicative)instance, CaptureParameters::new));
    public static final class_9139<class_9129, CaptureParameters> STREAM_CODEC = new class_9139<class_9129, CaptureParameters>(){

        @NotNull
        public CaptureParameters decode(class_9129 buffer) {
            return new CaptureParameters((String)class_9135.field_48554.decode((Object)buffer), (Optional)class_9135.method_56382(CameraId.STREAM_CODEC).decode((Object)buffer), (Optional)class_9135.method_56382((class_9139)class_9135.field_48550).decode((Object)buffer), (Optional)class_9135.method_56382((class_9139)class_9135.field_48553).decode((Object)buffer), ((Float)class_9135.field_48552.decode((Object)buffer)).floatValue(), (Optional)class_9135.method_56382((class_9139)class_2960.field_48267).decode((Object)buffer), (Optional)class_9135.method_56382(Projection.STREAM_CODEC).decode((Object)buffer), (Optional)class_9135.method_56382(ColorChannel.STREAM_CODEC).decode((Object)buffer), (FilmProperties)FilmProperties.STREAM_CODEC.decode((Object)buffer), (ExtraData)((Object)ExtraData.STREAM_CODEC.decode((Object)buffer)));
        }

        public void encode(class_9129 buffer, CaptureParameters data) {
            class_9135.field_48554.encode((Object)buffer, (Object)data.exposureId());
            class_9135.method_56382(CameraId.STREAM_CODEC).encode((Object)buffer, data.cameraId());
            class_9135.method_56382((class_9139)class_9135.field_48550).encode((Object)buffer, data.cameraHolderId());
            class_9135.method_56382((class_9139)class_9135.field_48553).encode((Object)buffer, data.fov());
            class_9135.field_48552.encode((Object)buffer, (Object)Float.valueOf(data.cropFactor()));
            class_9135.method_56382((class_9139)class_2960.field_48267).encode((Object)buffer, data.filter());
            class_9135.method_56382(Projection.STREAM_CODEC).encode((Object)buffer, data.projection());
            class_9135.method_56382(ColorChannel.STREAM_CODEC).encode((Object)buffer, data.singleChannel());
            FilmProperties.STREAM_CODEC.encode((Object)buffer, (Object)data.filmProperties());
            ExtraData.STREAM_CODEC.encode((Object)buffer, (Object)data.extraData());
        }
    };

    public ShutterSpeed getShutterSpeed() {
        return this.extraData.get(SHUTTER_SPEED).orElse(ShutterSpeed.DEFAULT);
    }

    public boolean getFlash() {
        return this.extraData.get(FLASH).orElse(false);
    }

    public Optional<Integer> getLightLevel() {
        return this.extraData.get(LIGHT_LEVEL);
    }

    public Builder mutable() {
        return new Builder(this);
    }

    public static final class Builder {
        private final String exposureId;
        @Nullable
        private CameraId cameraId;
        @Nullable
        private Integer cameraHolderEntityID;
        @Nullable
        private Double fov;
        private float cropFactor = 1.0f;
        @Nullable
        private class_2960 filter = null;
        @Nullable
        private Projection projection;
        @Nullable
        private ColorChannel chromaticChannel;
        private FilmProperties filmProperties = FilmProperties.EMPTY;
        private final ExtraData extraData = new ExtraData();

        public Builder(String exposureId) {
            this.exposureId = exposureId;
        }

        public Builder(CaptureParameters params) {
            this.exposureId = params.exposureId();
            this.cameraId = params.cameraId().orElse(null);
            this.cameraHolderEntityID = params.cameraHolderId().orElse(null);
            this.fov = params.fov.orElse(null);
            this.cropFactor = params.cropFactor();
            this.filter = params.filter().orElse(null);
            this.projection = params.projection().orElse(null);
            this.chromaticChannel = params.singleChannel().orElse(null);
            this.filmProperties = params.filmProperties();
            this.extraData.merge(params.extraData());
        }

        public Builder setCameraID(@Nullable CameraId cameraId) {
            this.cameraId = cameraId;
            return this;
        }

        public Builder setCameraHolder(@Nullable CameraHolder holder) {
            this.cameraHolderEntityID = holder == null ? null : Integer.valueOf(holder.asHolderEntity().method_5628());
            return this;
        }

        public Builder setFilter(@Nullable class_2960 filter) {
            this.filter = filter;
            return this;
        }

        public Builder setFov(@Nullable Double fov) {
            this.fov = fov;
            return this;
        }

        public Builder setCropFactor(float cropFactor) {
            this.cropFactor = cropFactor;
            return this;
        }

        public Builder setProjectionInfo(@Nullable Projection projection) {
            this.projection = projection;
            return this;
        }

        public Builder setProjection(Optional<Projection> projection) {
            this.projection = projection.orElse(null);
            return this;
        }

        public Builder setChromaticChannel(@Nullable ColorChannel chromaticChannel) {
            this.chromaticChannel = chromaticChannel;
            return this;
        }

        public Builder setChromaticChannel(Optional<ColorChannel> chromaticChannel) {
            this.chromaticChannel = chromaticChannel.orElse(null);
            return this;
        }

        public Builder setFilmProperties(FilmProperties filmProperties) {
            this.filmProperties = filmProperties;
            return this;
        }

        public Builder extraData(Consumer<ExtraData> extraDataUpdater) {
            extraDataUpdater.accept(this.extraData);
            return this;
        }

        public <T> Builder extraData(ExtraData.Type<T> type, T value) {
            this.extraData.put(type, value);
            return this;
        }

        public CaptureParameters build() {
            return new CaptureParameters(this.exposureId, Optional.ofNullable(this.cameraId), Optional.ofNullable(this.cameraHolderEntityID), Optional.ofNullable(this.fov), this.cropFactor, Optional.ofNullable(this.filter), Optional.ofNullable(this.projection), Optional.ofNullable(this.chromaticChannel), this.filmProperties, this.extraData);
        }
    }
}

