/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.world.camera.film.properties;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.mortuusars.exposure.util.Codecs;
import net.minecraft.class_2540;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record HSB(float hue, float saturation, float brightness) {
    public static final HSB EMPTY = new HSB(0.0f, 0.0f, 0.0f);
    public static final Codec<HSB> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codecs.floatRange(-1.0f, 1.0f).optionalFieldOf("hue", (Object)Float.valueOf(0.0f)).forGetter(HSB::hue), (App)Codecs.floatRange(-1.0f, 1.0f).optionalFieldOf("saturation", (Object)Float.valueOf(0.0f)).forGetter(HSB::saturation), (App)Codecs.floatRange(-1.0f, 1.0f).optionalFieldOf("brightness", (Object)Float.valueOf(0.0f)).forGetter(HSB::brightness)).apply((Applicative)instance, HSB::new));
    public static final class_9139<class_2540, HSB> STREAM_CODEC = class_9139.method_56436((class_9139)class_9135.field_48552, HSB::hue, (class_9139)class_9135.field_48552, HSB::saturation, (class_9139)class_9135.field_48552, HSB::brightness, HSB::new);

    public HSB {
        Preconditions.checkArgument((hue >= -1.0f && hue <= 1.0f ? 1 : 0) != 0, (Object)"h must be in -1 to 1 range.");
        Preconditions.checkArgument((saturation >= -1.0f && saturation <= 1.0f ? 1 : 0) != 0, (Object)"s must be in -1 to 1 range.");
        Preconditions.checkArgument((brightness >= -1.0f && brightness <= 1.0f ? 1 : 0) != 0, (Object)"b must be in -1 to 1 range.");
    }

    @Override
    public String toString() {
        return "H:%s, S:%s, B:%s".formatted(Float.valueOf(this.hue), Float.valueOf(this.saturation), Float.valueOf(this.brightness));
    }
}

