/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.world.inventory;

import com.google.common.base.Preconditions;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.world.camera.CameraId;
import io.github.mortuusars.exposure.world.inventory.AbstractCameraAttachmentsMenu;
import io.github.mortuusars.exposure.world.inventory.slot.FilteredSlot;
import io.github.mortuusars.exposure.world.item.camera.CameraItem;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_9129;
import org.jetbrains.annotations.NotNull;

public class CameraInHandAttachmentsMenu
extends AbstractCameraAttachmentsMenu {
    protected final int cameraSlotIndex;
    protected final boolean openedFromGui;

    public CameraInHandAttachmentsMenu(int containerId, class_1661 playerInventory, int cameraSlotIndex, boolean openedFromGui) {
        super(Exposure.MenuTypes.CAMERA_IN_HAND.get(), containerId, playerInventory, new InventoryCameraAccess(playerInventory, cameraSlotIndex));
        this.cameraSlotIndex = cameraSlotIndex;
        this.openedFromGui = openedFromGui;
    }

    public boolean isOpenedFromGui() {
        return this.openedFromGui;
    }

    @Override
    protected void addPlayerSlots(class_1661 playerInventory) {
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                this.method_7621(new class_1735((class_1263)playerInventory, column + row * 9 + 9, column * 18 + 8, 103 + row * 18){

                    public boolean method_7674(@NotNull class_1657 player) {
                        return super.method_7674(player) && this.method_34266() != CameraInHandAttachmentsMenu.this.cameraSlotIndex;
                    }

                    public boolean method_7682() {
                        return this.method_34266() != CameraInHandAttachmentsMenu.this.cameraSlotIndex;
                    }

                    public boolean method_51306() {
                        return this.method_34266() != CameraInHandAttachmentsMenu.this.cameraSlotIndex;
                    }
                });
            }
        }
        for (int slot = 0; slot < 9; ++slot) {
            int finalSlot = slot;
            this.method_7621(new class_1735((class_1263)playerInventory, finalSlot, slot * 18 + 8, 161){

                public boolean method_7674(@NotNull class_1657 player) {
                    return super.method_7674(player) && this.method_34266() != CameraInHandAttachmentsMenu.this.cameraSlotIndex;
                }

                public boolean method_7682() {
                    return this.method_34266() != CameraInHandAttachmentsMenu.this.cameraSlotIndex;
                }

                public boolean method_51306() {
                    return this.method_34266() != CameraInHandAttachmentsMenu.this.cameraSlotIndex;
                }
            });
        }
    }

    @Override
    protected void onContainerChanged(class_1263 c) {
        super.onContainerChanged(c);
        if (!this.player.method_37908().method_8608() && this.player.method_7337()) {
            this.player.method_31548().method_5447(this.cameraSlotIndex, this.getCameraStack());
        }
    }

    @Override
    protected void onItemInSlotChanged(FilteredSlot.SlotChangedArgs args) {
        super.onItemInSlotChanged(args);
        if (!this.player.method_37908().method_8608() && this.player.method_7337()) {
            this.player.method_31548().method_5447(this.cameraSlotIndex, this.getCameraStack());
        }
    }

    @Override
    public void method_7595(class_1657 player) {
        super.method_7595(player);
        player.field_7498.method_34257();
    }

    public boolean method_7597(@NotNull class_1657 player) {
        return CameraId.ofStack(this.getCameraStack()).matches(player.method_31548().method_5438(this.cameraSlotIndex));
    }

    public static CameraInHandAttachmentsMenu fromBuffer(int containerId, class_1661 playerInventory, class_9129 buffer) {
        return new CameraInHandAttachmentsMenu(containerId, playerInventory, buffer.readInt(), buffer.readBoolean());
    }

    public static class InventoryCameraAccess
    implements AbstractCameraAttachmentsMenu.CameraAccess {
        protected final class_1661 inventory;
        protected final int slot;

        public InventoryCameraAccess(class_1661 inventory, int slot) {
            this.inventory = inventory;
            this.slot = slot;
            Preconditions.checkState((boolean)(this.getStack().method_7909() instanceof CameraItem), (Object)("Failed to open access the camera. " + String.valueOf(this.getStack()) + " is not a CameraItem."));
        }

        @Override
        public class_1799 getStack() {
            return this.inventory.method_5438(this.slot);
        }
    }
}

