/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.world.inventory;

import com.google.common.base.Preconditions;
import io.github.mortuusars.exposure.Exposure;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_3419;
import net.minecraft.class_3544;
import net.minecraft.class_9129;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemRenameMenu
extends class_1703 {
    public static final int MAX_NAME_LENGTH = 50;
    public static final int APPLY_BUTTON_ID = 0;
    protected final class_1661 playerInventory;
    protected final int slot;
    protected final class_1792 item;
    protected String itemName;

    public ItemRenameMenu(int containerId, class_1661 playerInventory, int slot) {
        super(Exposure.MenuTypes.ITEM_RENAME.get(), containerId);
        this.playerInventory = playerInventory;
        this.slot = slot;
        class_1799 itemStack = playerInventory.method_5438(slot);
        Preconditions.checkArgument((!itemStack.method_7960() ? 1 : 0) != 0, (Object)("Cannot rename empty item in slot " + slot));
        this.item = itemStack.method_7909();
        this.itemName = itemStack.method_7964().getString();
        class_1277 container = new class_1277(new class_1799[]{itemStack});
        this.method_7621(new class_1735(this, (class_1263)container, 0, 4, 16){

            public boolean method_7680(class_1799 stack) {
                return false;
            }

            public boolean method_7674(class_1657 player) {
                return false;
            }

            public boolean method_51306() {
                return false;
            }
        });
    }

    public static ItemRenameMenu fromBuffer(int containerId, class_1661 playerInventory, class_9129 buffer) {
        return new ItemRenameMenu(containerId, playerInventory, buffer.readInt());
    }

    public class_1657 getPlayer() {
        return this.playerInventory.field_7546;
    }

    @NotNull
    public class_1799 method_7601(class_1657 player, int index) {
        return class_1799.field_8037;
    }

    public boolean method_7597(class_1657 player) {
        return this.item.getClass().isAssignableFrom(player.method_31548().method_5438(this.slot).method_7909().getClass());
    }

    public void updateResult() {
        class_1799 itemStack = this.method_7611(0).method_7677();
        class_1799 itemStack2 = itemStack.method_7972();
        if (class_3544.method_57181((String)this.itemName)) {
            itemStack2.method_57381(class_9334.field_49631);
        } else if (!this.itemName.equals(itemStack.method_7964().getString())) {
            itemStack2.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)this.itemName));
        }
        this.method_7611(0).method_7673(itemStack2);
        this.method_7623();
    }

    public String getItemName() {
        return this.itemName;
    }

    public boolean setItemName(String itemName) {
        String string = this.validateName(itemName);
        if (string == null || !string.equals(itemName)) {
            return false;
        }
        this.itemName = string;
        this.updateResult();
        return true;
    }

    @Nullable
    public String validateName(String itemName) {
        String string = class_3544.method_57180((String)itemName);
        if (string.length() <= 50) {
            return string;
        }
        return null;
    }

    public boolean method_7604(class_1657 player, int id) {
        if (id == 0 && !this.method_7611(0).method_7677().method_7964().getString().equals(this.playerInventory.method_5438(this.slot).method_7964().getString())) {
            this.playerInventory.method_5447(this.slot, this.method_7611(0).method_7677());
            player.method_37908().method_43129(player, (class_1297)player, Exposure.SoundEvents.WRITE.get(), class_3419.field_15248, 0.8f, 1.0f);
        }
        return super.method_7604(player, id);
    }
}

