/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.world.item;

import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.PlatformHelper;
import io.github.mortuusars.exposure.world.inventory.AlbumMenu;
import io.github.mortuusars.exposure.world.item.component.album.AlbumContent;
import io.github.mortuusars.exposure.world.item.component.album.AlbumPage;
import io.github.mortuusars.exposure.world.item.component.album.SignedAlbumContent;
import io.github.mortuusars.exposure.world.item.component.album.SignedAlbumPage;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3468;
import net.minecraft.class_3715;
import net.minecraft.class_3908;
import org.jetbrains.annotations.NotNull;

public class AlbumItem
extends class_1792 {
    public AlbumItem(class_1792.class_1793 properties) {
        super(properties);
    }

    public AlbumContent getContent(class_1799 stack) {
        return (AlbumContent)stack.method_57825(Exposure.DataComponents.ALBUM_CONTENT, (Object)AlbumContent.EMPTY);
    }

    public void setContent(class_1799 stack, AlbumContent content) {
        stack.method_57379(Exposure.DataComponents.ALBUM_CONTENT, (Object)content);
    }

    public void updatePage(class_1799 stack, int index, Function<Optional<AlbumPage>, AlbumPage> pageUpdater) {
        AlbumPage page = pageUpdater.apply(this.getContent(stack).getPage(index));
        this.setContent(stack, this.getContent(stack).toMutable().setPage(index, page).toImmutable());
    }

    public int getPhotographsCount(class_1799 stack) {
        return this.getContent(stack).pages().stream().filter(albumPage -> !albumPage.photograph().method_7960()).toList().size();
    }

    @NotNull
    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 usedHand) {
        class_1799 itemStack = player.method_5998(usedHand);
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            int albumSlot = usedHand == class_1268.field_5810 ? 40 : player.method_31548().field_7545;
            this.open(serverPlayer, itemStack, albumSlot);
        }
        player.method_7259(class_3468.field_15372.method_14956((Object)this));
        return class_1271.method_29237((Object)itemStack, (boolean)level.method_8608());
    }

    @NotNull
    public class_1269 method_7884(class_1838 context) {
        class_2338 blockPos = context.method_8037();
        class_1937 level = context.method_8045();
        class_2680 blockState = level.method_8320(blockPos);
        if (blockState.method_27852(class_2246.field_16330)) {
            return class_3715.method_17472((class_1309)context.method_8036(), (class_1937)level, (class_2338)blockPos, (class_2680)blockState, (class_1799)context.method_8041()) ? class_1269.method_29236((boolean)level.field_9236) : class_1269.field_5811;
        }
        return class_1269.field_5811;
    }

    public void open(class_3222 player, final class_1799 albumStack, final int albumSlot) {
        class_3908 menuProvider = new class_3908(){

            @NotNull
            public class_2561 method_5476() {
                return albumStack.method_7964();
            }

            @NotNull
            public class_1703 createMenu(int containerId, @NotNull class_1661 playerInventory, @NotNull class_1657 player) {
                return new AlbumMenu(containerId, playerInventory, albumSlot);
            }
        };
        PlatformHelper.openMenu(player, menuProvider, buffer -> buffer.method_10804(albumSlot));
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltipComponents, class_1836 tooltipFlag) {
        int photographsCount;
        if (((Boolean)Config.Client.ALBUM_PHOTOS_COUNT_TOOLTIP.get()).booleanValue() && (photographsCount = this.getPhotographsCount(stack)) > 0) {
            tooltipComponents.add((class_2561)class_2561.method_43469((String)"item.exposure.album.tooltip.photos_count", (Object[])new Object[]{photographsCount}));
        }
    }

    public boolean shouldPlayEquipAnimation(class_1799 oldStack, class_1799 newStack) {
        return oldStack.method_7909() != newStack.method_7909();
    }

    public class_1799 sign(class_1799 albumStack, String title, String author) {
        class_1799 signedAlbumStack = new class_1799((class_1935)Exposure.Items.SIGNED_ALBUM.get());
        List<SignedAlbumPage> signedPages = this.getContent(albumStack).removeTrailingPages().pages().stream().map(AlbumPage::convertToSigned).toList();
        SignedAlbumContent signedAlbumContent = new SignedAlbumContent(title, author, signedPages);
        signedAlbumStack.method_57379(Exposure.DataComponents.SIGNED_ALBUM_CONTENT, (Object)signedAlbumContent);
        return signedAlbumStack;
    }
}

