/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.world.item;

import com.google.common.base.Preconditions;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.client.gui.ClientGUI;
import io.github.mortuusars.exposure.world.inventory.tooltip.PhotographTooltip;
import io.github.mortuusars.exposure.world.item.PhotographItem;
import io.github.mortuusars.exposure.world.item.util.ItemAndStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_3419;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import net.minecraft.class_5632;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

public class StackedPhotographsItem
extends class_1792 {
    public static final Codec<ItemAndStack<PhotographItem>> PHOTOGRAPH_ITEM_AND_STACK_CODEC = class_1799.field_24671.comapFlatMap(stack -> {
        if (stack.method_7909() instanceof PhotographItem) {
            return DataResult.success(new ItemAndStack((class_1799)stack));
        }
        return DataResult.error(() -> "'stacked_photographs' can only hold items of type PhotographItem.");
    }, ItemAndStack::getItemStack);
    public static final class_9139<class_9129, ItemAndStack<PhotographItem>> PHOTOGRAPH_ITEM_AND_STACK_STREAM_CODEC = class_1799.field_48349.method_56432(ItemAndStack::new, ItemAndStack::getItemStack);

    public StackedPhotographsItem(class_1792.class_1793 properties) {
        super(properties);
    }

    public int getStackLimit() {
        return (Integer)Config.Server.STACKED_PHOTOGRAPHS_MAX_SIZE.get();
    }

    public List<ItemAndStack<PhotographItem>> getPhotographs(class_1799 stack) {
        return (List)stack.method_57825(Exposure.DataComponents.STACKED_PHOTOGRAPHS, Collections.emptyList());
    }

    public void setPhotographs(class_1799 stack, List<ItemAndStack<PhotographItem>> photographs) {
        stack.method_57379(Exposure.DataComponents.STACKED_PHOTOGRAPHS, photographs);
    }

    public boolean canAddPhotograph(class_1799 stack) {
        return this.getPhotographs(stack).size() < this.getStackLimit();
    }

    public void addPhotograph(class_1799 stack, class_1799 photographStack, int index) {
        Preconditions.checkElementIndex((int)index, (int)(this.getPhotographs(stack).size() + 1));
        Preconditions.checkState((boolean)this.canAddPhotograph(stack), (Object)("Cannot add more photographs than this photo can store. Max count: " + this.getStackLimit()));
        Preconditions.checkArgument((boolean)(photographStack.method_7909() instanceof PhotographItem), (Object)"Only PhotographItem can be stacked.");
        ArrayList<ItemAndStack<PhotographItem>> photographs = new ArrayList<ItemAndStack<PhotographItem>>(this.getPhotographs(stack));
        photographs.add(index, new ItemAndStack(photographStack));
        this.setPhotographs(stack, photographs);
    }

    public void addPhotographOnTop(class_1799 stack, class_1799 photographStack) {
        this.addPhotograph(stack, photographStack, 0);
    }

    public void addPhotographToBottom(class_1799 stack, class_1799 photographStack) {
        this.addPhotograph(stack, photographStack, this.getPhotographs(stack).size());
    }

    public ItemAndStack<PhotographItem> removePhotograph(class_1799 stack, int index) {
        Preconditions.checkElementIndex((int)index, (int)this.getPhotographs(stack).size());
        ArrayList<ItemAndStack<PhotographItem>> photographs = new ArrayList<ItemAndStack<PhotographItem>>(this.getPhotographs(stack));
        ItemAndStack<PhotographItem> removedPhotograph = photographs.remove(index);
        this.setPhotographs(stack, photographs);
        return removedPhotograph;
    }

    public ItemAndStack<PhotographItem> removeTopPhotograph(class_1799 stack) {
        return this.removePhotograph(stack, 0);
    }

    public ItemAndStack<PhotographItem> removeBottomPhotograph(class_1799 stack) {
        return this.removePhotograph(stack, this.getPhotographs(stack).size() - 1);
    }

    @NotNull
    public Optional<class_5632> method_32346(@NotNull class_1799 stack) {
        List<ItemAndStack<PhotographItem>> photographs = this.getPhotographs(stack);
        if (photographs.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new PhotographTooltip(photographs));
    }

    public boolean method_31565(@NotNull class_1799 stack, @NotNull class_1735 slot, @NotNull class_5536 action, @NotNull class_1657 player) {
        if (action != class_5536.field_27014 || this.getPhotographs(stack).isEmpty() || !slot.method_7680(new class_1799((class_1935)Exposure.Items.PHOTOGRAPH.get()))) {
            return false;
        }
        class_1799 slotItem = slot.method_7677();
        if (slotItem.method_7960()) {
            ItemAndStack<PhotographItem> photograph = this.removeBottomPhotograph(stack);
            slot.method_7673(photograph.getItemStack());
            if (this.getPhotographs(stack).size() == 1) {
                player.field_7512.method_34254(this.removeTopPhotograph(stack).getItemStack());
            }
            StackedPhotographsItem.playRemoveSoundClientside(player);
            return true;
        }
        if (slotItem.method_7909() instanceof PhotographItem && this.canAddPhotograph(stack)) {
            this.addPhotographToBottom(stack, slotItem);
            slot.method_7673(class_1799.field_8037);
            StackedPhotographsItem.playAddSoundClientside(player);
            return true;
        }
        return false;
    }

    public boolean method_31566(@NotNull class_1799 stack, @NotNull class_1799 other, @NotNull class_1735 slot, @NotNull class_5536 action, @NotNull class_1657 player, @NotNull class_5630 access) {
        if (action != class_5536.field_27014 || !slot.method_7680(new class_1799((class_1935)Exposure.Items.PHOTOGRAPH.get()))) {
            return false;
        }
        if (!this.getPhotographs(stack).isEmpty() && other.method_7960()) {
            ItemAndStack<PhotographItem> photograph = this.removeTopPhotograph(stack);
            access.method_32332(photograph.getItemStack());
            if (this.getPhotographs(stack).size() == 1) {
                ItemAndStack<PhotographItem> lastPhotograph = this.removeTopPhotograph(stack);
                slot.method_7673(lastPhotograph.getItemStack());
            }
            StackedPhotographsItem.playRemoveSoundClientside(player);
            return true;
        }
        if (other.method_7909() instanceof PhotographItem) {
            if (this.canAddPhotograph(stack)) {
                this.addPhotographOnTop(stack, other);
                access.method_32332(class_1799.field_8037);
                StackedPhotographsItem.playAddSoundClientside(player);
                return true;
            }
            return false;
        }
        class_1792 lastPhotograph = other.method_7909();
        if (lastPhotograph instanceof StackedPhotographsItem) {
            StackedPhotographsItem otherStackedItem = (StackedPhotographsItem)lastPhotograph;
            int otherCount = otherStackedItem.getPhotographs(other).size();
            int addedCount = 0;
            for (int i = 0; i < otherCount; ++i) {
                if (!this.canAddPhotograph(stack)) continue;
                ItemAndStack<PhotographItem> photograph = otherStackedItem.removeBottomPhotograph(other);
                this.addPhotographOnTop(stack, photograph.getItemStack());
                ++addedCount;
            }
            if (otherStackedItem.getPhotographs(other).isEmpty()) {
                access.method_32332(class_1799.field_8037);
            } else if (otherStackedItem.getPhotographs(other).size() == 1) {
                access.method_32332(otherStackedItem.removeTopPhotograph(other).getItemStack());
            }
            if (addedCount > 0) {
                StackedPhotographsItem.playAddSoundClientside(player);
            }
            return true;
        }
        return false;
    }

    @NotNull
    public class_1271<class_1799> method_7836(@NotNull class_1937 level, class_1657 player, @NotNull class_1268 hand) {
        class_1799 itemInHand = player.method_5998(hand);
        if (player.method_21823() && this.cyclePhotographs(itemInHand)) {
            player.method_37908().method_43129(player, (class_1297)player, Exposure.SoundEvents.PHOTOGRAPH_RUSTLE.get(), class_3419.field_15248, 0.6f, player.method_37908().method_8409().method_43057() * 0.2f + 1.2f);
            player.method_32876((class_6880)class_5712.field_28146);
            return class_1271.method_22427((Object)itemInHand);
        }
        List<ItemAndStack<PhotographItem>> photographs = this.getPhotographs(itemInHand);
        if (!photographs.isEmpty()) {
            if (level.field_9236) {
                int slot = hand == class_1268.field_5810 ? 40 : player.method_31548().field_7545;
                ClientGUI.openPhotographsScreenFromItem(slot);
                player.method_5783(Exposure.SoundEvents.PHOTOGRAPH_RUSTLE.get(), 0.6f, 1.1f);
            }
            return class_1271.method_22427((Object)itemInHand);
        }
        return class_1271.method_22431((Object)itemInHand);
    }

    public boolean cyclePhotographs(class_1799 stack) {
        if (this.getPhotographs(stack).size() < 2) {
            return false;
        }
        ItemAndStack<PhotographItem> topPhotograph = this.removeTopPhotograph(stack);
        this.addPhotographToBottom(stack, topPhotograph.getItemStack());
        return true;
    }

    public static void playAddSoundClientside(class_1657 player) {
        if (player.method_37908().field_9236) {
            player.method_5783(Exposure.SoundEvents.PHOTOGRAPH_RUSTLE.get(), 0.6f, player.method_37908().method_8409().method_43057() * 0.2f + 1.2f);
        }
    }

    public static void playRemoveSoundClientside(class_1657 player) {
        if (player.method_37908().field_9236) {
            player.method_5783(Exposure.SoundEvents.PHOTOGRAPH_RUSTLE.get(), 0.75f, player.method_37908().method_8409().method_43057() * 0.2f + 0.75f);
        }
    }
}

