/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.world.item.camera;

import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.world.entity.CameraHolder;
import io.github.mortuusars.exposure.world.item.camera.CameraItem;
import io.github.mortuusars.exposure.world.sound.Sound;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_3218;
import net.minecraft.class_3419;

public class Timer {
    public void set(CameraHolder holder, class_1799 stack, int ticks) {
        long gameTime = holder.asHolderEntity().method_37908().method_8510();
        this.setStartTick(stack, gameTime);
        this.setEndTick(stack, gameTime + (long)ticks);
    }

    public void stop(class_1799 stack) {
        this.setStartTick(stack, -1L);
        this.setEndTick(stack, -1L);
    }

    public boolean isTicking(CameraHolder holder, class_1799 stack) {
        return this.getEndTick(stack) > holder.asHolderEntity().method_37908().method_8510();
    }

    public int getRemainingTicks(CameraHolder holder, class_1799 stack) {
        return (int)Math.max(-1L, this.getEndTick(stack) - holder.asHolderEntity().method_37908().method_8510());
    }

    public long getTicksSinceLastRelease(CameraHolder holder, class_1799 stack) {
        return holder.asHolderEntity().method_37908().method_8510() - this.getLastReleaseTick(stack);
    }

    public long getStartTick(class_1799 stack) {
        return (Long)stack.method_57825(Exposure.DataComponents.TIMER_START_TICK, (Object)-1L);
    }

    public void setStartTick(class_1799 stack, long tick) {
        stack.method_57379(Exposure.DataComponents.TIMER_START_TICK, (Object)tick);
    }

    public long getEndTick(class_1799 stack) {
        return (Long)stack.method_57825(Exposure.DataComponents.TIMER_END_TICK, (Object)-1L);
    }

    public void setEndTick(class_1799 stack, long tick) {
        stack.method_57379(Exposure.DataComponents.TIMER_END_TICK, (Object)tick);
    }

    public long getLastReleaseTick(class_1799 stack) {
        return (Long)stack.method_57825(Exposure.DataComponents.TIMER_LAST_RELEASE_TICK, (Object)-1L);
    }

    public void setLastReleaseTick(class_1799 stack, long tick) {
        stack.method_57379(Exposure.DataComponents.TIMER_LAST_RELEASE_TICK, (Object)tick);
    }

    public boolean tick(CameraHolder holder, class_3218 level, class_1799 stack) {
        long releaseTick = this.getEndTick(stack);
        if (releaseTick <= -1L) {
            return false;
        }
        long currentTick = level.method_8510();
        long remainingTicks = releaseTick - currentTick;
        if (remainingTicks < -5L) {
            this.stop(stack);
            return true;
        }
        if (remainingTicks == 0L) {
            this.setEndTick(stack, currentTick);
            this.setLastReleaseTick(stack, currentTick);
            class_1792 class_17922 = stack.method_7909();
            if (class_17922 instanceof CameraItem) {
                CameraItem cameraItem = (CameraItem)class_17922;
                cameraItem.release(holder, stack);
            }
            this.stop(stack);
            return true;
        }
        if (remainingTicks % (long)this.getTickingInterval(remainingTicks) == 0L) {
            this.playTickSound(holder);
        }
        return false;
    }

    protected void playTickSound(CameraHolder holder) {
        Sound.play(holder.asHolderEntity(), Exposure.SoundEvents.CAMERA_TIMER_TICK.get(), class_3419.field_15248, 1.0f, 0.8f);
    }

    protected int getTickingInterval(long remainingTicks) {
        if (remainingTicks > 100L) {
            return 10;
        }
        if (remainingTicks > 50L) {
            return 6;
        }
        if (remainingTicks > 25L) {
            return 4;
        }
        return 2;
    }
}

