/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.world.lightroom;

import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.world.camera.ExposureType;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_1767;

public enum PrintingProcess {
    BLACK_AND_WHITE((Supplier<List<? extends String>>)Config.Server.LIGHTROOM_BW_DYES, (Supplier<Integer>)Config.Server.LIGHTROOM_BW_PRINT_TIME, (Supplier<Integer>)Config.Server.LIGHTROOM_BW_EXPERIENCE),
    COLOR((Supplier<List<? extends String>>)Config.Server.LIGHTROOM_COLOR_DYES, (Supplier<Integer>)Config.Server.LIGHTROOM_COLOR_PRINT_TIME, (Supplier<Integer>)Config.Server.LIGHTROOM_COLOR_EXPERIENCE),
    CHROMATIC_R((Supplier<List<? extends String>>)Config.Server.LIGHTROOM_CHROMATIC_RED_DYES, (Supplier<Integer>)Config.Server.LIGHTROOM_CHROMATIC_PRINT_TIME, () -> 0),
    CHROMATIC_G((Supplier<List<? extends String>>)Config.Server.LIGHTROOM_CHROMATIC_GREEN_DYES, (Supplier<Integer>)Config.Server.LIGHTROOM_CHROMATIC_PRINT_TIME, () -> 0),
    CHROMATIC_B((Supplier<List<? extends String>>)Config.Server.LIGHTROOM_CHROMATIC_BLUE_DYES, (Supplier<Integer>)Config.Server.LIGHTROOM_CHROMATIC_PRINT_TIME, (Supplier<Integer>)Config.Server.LIGHTROOM_CHROMATIC_EXPERIENCE);

    private final Supplier<List<? extends String>> requiredDyes;
    private final Supplier<Integer> printTime;
    private final Supplier<Integer> xpPerPrint;

    private PrintingProcess(Supplier<List<? extends String>> requiredDyes, Supplier<Integer> printTime, Supplier<Integer> xpPerPrint) {
        this.requiredDyes = requiredDyes;
        this.printTime = printTime;
        this.xpPerPrint = xpPerPrint;
    }

    public List<class_1767> getRequiredDyes() {
        return this.requiredDyes.get().stream().map(name -> class_1767.method_7793((String)name.toLowerCase(), (class_1767)class_1767.field_7963)).toList();
    }

    public int getPrintTime() {
        return this.printTime.get();
    }

    public int getExperiencePerPrint() {
        return this.xpPerPrint.get();
    }

    public boolean isRegular() {
        return this == BLACK_AND_WHITE || this == COLOR;
    }

    public boolean isChromatic() {
        return this == CHROMATIC_R || this == CHROMATIC_G || this == CHROMATIC_B;
    }

    public static PrintingProcess fromExposureType(ExposureType type) {
        return type == ExposureType.COLOR ? COLOR : BLACK_AND_WHITE;
    }

    public static PrintingProcess fromChromaticStep(int step) {
        return switch (step) {
            case 0 -> CHROMATIC_R;
            case 1 -> CHROMATIC_G;
            case 2 -> CHROMATIC_B;
            default -> throw new IllegalStateException("Unexpected step value: " + step + ", 0|1|2 corresponding to R|G|B is expected.");
        };
    }
}

