/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.platform.InputConstants;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.data.storage.ClientsideExposureStorage;
import io.github.mortuusars.exposure.data.storage.IClientsideExposureStorage;
import io.github.mortuusars.exposure.data.transfer.ExposureReceiver;
import io.github.mortuusars.exposure.data.transfer.ExposureSender;
import io.github.mortuusars.exposure.data.transfer.IExposureReceiver;
import io.github.mortuusars.exposure.data.transfer.IExposureSender;
import io.github.mortuusars.exposure.item.AlbumItem;
import io.github.mortuusars.exposure.item.CameraItemClientExtensions;
import io.github.mortuusars.exposure.item.ChromaticSheetItem;
import io.github.mortuusars.exposure.item.StackedPhotographsItem;
import io.github.mortuusars.exposure.network.Packets;
import io.github.mortuusars.exposure.render.ExposureRenderer;
import java.util.function.Function;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.Nullable;

public class ExposureClient {
    private static final IClientsideExposureStorage exposureStorage = new ClientsideExposureStorage();
    private static final ExposureRenderer exposureRenderer = new ExposureRenderer();
    private static IExposureSender exposureSender;
    private static IExposureReceiver exposureReceiver;
    @Nullable
    private static KeyMapping openCameraControlsKey;

    public static void init() {
        exposureSender = new ExposureSender((packet, player) -> Packets.sendToServer(packet), 28000);
        exposureReceiver = new ExposureReceiver(exposureStorage);
        ExposureClient.registerItemModelProperties();
    }

    public static IClientsideExposureStorage getExposureStorage() {
        return exposureStorage;
    }

    public static IExposureSender getExposureSender() {
        return exposureSender;
    }

    public static IExposureReceiver getExposureReceiver() {
        return exposureReceiver;
    }

    public static ExposureRenderer getExposureRenderer() {
        return exposureRenderer;
    }

    public static void registerKeymappings(Function<KeyMapping, KeyMapping> registerFunction) {
        KeyMapping keyMapping = new KeyMapping("key.exposure.camera_controls", InputConstants.f_84822_.m_84873_(), "category.exposure");
        openCameraControlsKey = registerFunction.apply(keyMapping);
    }

    private static void registerItemModelProperties() {
        ItemProperties.m_174570_((Item)Exposure.Items.CAMERA.get(), (ResourceLocation)new ResourceLocation("camera_state"), CameraItemClientExtensions::itemPropertyFunction);
        ItemProperties.m_174570_((Item)Exposure.Items.CAMERA.get(), (ResourceLocation)new ResourceLocation("camera_gold"), (stack, level, entity, seed) -> stack.m_41783_() != null && stack.m_41783_().m_128471_("GoldenCamera") ? 1.0f : 0.0f);
        ItemProperties.m_174570_((Item)Exposure.Items.CHROMATIC_SHEET.get(), (ResourceLocation)new ResourceLocation("channels"), (stack, clientLevel, livingEntity, seed) -> {
            float f;
            Item patt0$temp = stack.m_41720_();
            if (patt0$temp instanceof ChromaticSheetItem) {
                ChromaticSheetItem chromaticSheet = (ChromaticSheetItem)patt0$temp;
                f = (float)chromaticSheet.getExposures(stack).size() / 10.0f;
            } else {
                f = 0.0f;
            }
            return f;
        });
        ItemProperties.m_174570_((Item)Exposure.Items.STACKED_PHOTOGRAPHS.get(), (ResourceLocation)new ResourceLocation("count"), (stack, clientLevel, livingEntity, seed) -> {
            float f;
            Item patt0$temp = stack.m_41720_();
            if (patt0$temp instanceof StackedPhotographsItem) {
                StackedPhotographsItem stackedPhotographsItem = (StackedPhotographsItem)patt0$temp;
                f = (float)stackedPhotographsItem.getPhotographsCount(stack) / 100.0f;
            } else {
                f = 0.0f;
            }
            return f;
        });
        ItemProperties.m_174570_((Item)Exposure.Items.ALBUM.get(), (ResourceLocation)new ResourceLocation("photos"), (stack, clientLevel, livingEntity, seed) -> {
            float f;
            Item patt0$temp = stack.m_41720_();
            if (patt0$temp instanceof AlbumItem) {
                AlbumItem albumItem = (AlbumItem)patt0$temp;
                f = (float)albumItem.getPhotographsCount(stack) / 100.0f;
            } else {
                f = 0.0f;
            }
            return f;
        });
        ItemProperties.m_174570_((Item)Exposure.Items.INTERPLANAR_PROJECTOR.get(), (ResourceLocation)new ResourceLocation("active"), (stack, clientLevel, livingEntity, seed) -> stack.m_41788_() ? 1.0f : 0.0f);
    }

    public static void onScreenAdded(Screen screen) {
    }

    public static KeyMapping getCameraControlsKey() {
        Preconditions.checkState((openCameraControlsKey != null ? 1 : 0) != 0, (Object)"Viewfinder Controls key mapping was not registered");
        return openCameraControlsKey.m_90862_() ? Minecraft.m_91087_().f_91066_.f_92090_ : openCameraControlsKey;
    }

    public static boolean isShaderActive() {
        return Minecraft.m_91087_().f_91063_.m_109149_() != null && Minecraft.m_91087_().f_91063_.f_109053_;
    }

    static {
        openCameraControlsKey = null;
    }

    public static class Models {
        public static final ModelResourceLocation CAMERA_GUI = new ModelResourceLocation("exposure", "camera_gui", "inventory");
        public static final ModelResourceLocation PHOTOGRAPH_FRAME_SMALL = new ModelResourceLocation("exposure", "photograph_frame_small", "");
        public static final ModelResourceLocation PHOTOGRAPH_FRAME_SMALL_STRIPPED = new ModelResourceLocation("exposure", "photograph_frame_small_stripped", "");
        public static final ModelResourceLocation PHOTOGRAPH_FRAME_MEDIUM = new ModelResourceLocation("exposure", "photograph_frame_medium", "");
        public static final ModelResourceLocation PHOTOGRAPH_FRAME_MEDIUM_STRIPPED = new ModelResourceLocation("exposure", "photograph_frame_medium_stripped", "");
        public static final ModelResourceLocation PHOTOGRAPH_FRAME_LARGE = new ModelResourceLocation("exposure", "photograph_frame_large", "");
        public static final ModelResourceLocation PHOTOGRAPH_FRAME_LARGE_STRIPPED = new ModelResourceLocation("exposure", "photograph_frame_large_stripped", "");
    }
}

