/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.item;

import io.github.mortuusars.exposure.PlatformHelper;
import io.github.mortuusars.exposure.item.CameraItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class CameraItemClientExtensions {
    public static void applyDefaultHoldingPose(HumanoidModel<?> model, LivingEntity entity, HumanoidArm arm) {
        if (PlatformHelper.isModLoaded("realcamera")) {
            return;
        }
        model.f_102808_.f_104203_ += 0.4f;
        if (arm == HumanoidArm.RIGHT) {
            AnimationUtils.m_102097_((ModelPart)model.f_102811_, (ModelPart)model.f_102812_, (ModelPart)model.f_102808_, (boolean)true);
        } else if (arm == HumanoidArm.LEFT) {
            AnimationUtils.m_102097_((ModelPart)model.f_102811_, (ModelPart)model.f_102812_, (ModelPart)model.f_102808_, (boolean)false);
        }
        model.f_102808_.f_104203_ += 0.3f;
    }

    public static void applySelfieHoldingPose(HumanoidModel<?> model, LivingEntity entity, HumanoidArm arm, boolean undoArmBobbing) {
        ModelPart cameraArm = arm == HumanoidArm.RIGHT ? model.f_102811_ : model.f_102812_;
        cameraArm.f_104203_ = model.f_102808_.f_104203_ + Math.abs(model.f_102808_.f_104203_ * 0.13f) + -1.5707964f;
        cameraArm.f_104204_ = model.f_102808_.f_104204_ + (arm == HumanoidArm.RIGHT ? -0.25f : 0.25f);
        cameraArm.f_104205_ = model.f_102808_.f_104203_ <= 0.0f ? -(model.f_102808_.f_104203_ * 0.15f) : -(model.f_102808_.f_104203_ * 0.22f);
        if (undoArmBobbing) {
            AnimationUtils.m_170341_((ModelPart)cameraArm, (float)((float)entity.f_19797_ + Minecraft.m_91087_().m_91296_()), (float)(arm == HumanoidArm.LEFT ? 1.0f : -1.0f));
        }
    }

    public static float itemPropertyFunction(ItemStack stack, ClientLevel clientLevel, LivingEntity livingEntity, int seed) {
        CameraItem cameraItem;
        Item item = stack.m_41720_();
        if (item instanceof CameraItem && (cameraItem = (CameraItem)item).isActive(stack)) {
            if (cameraItem.isInSelfieMode(stack)) {
                return livingEntity == Minecraft.m_91087_().f_91074_ ? 0.2f : 0.3f;
            }
            return 0.1f;
        }
        return 0.0f;
    }

    public static void releaseUseButton() {
        Minecraft.m_91087_().f_91066_.f_92095_.m_7249_(false);
    }
}

