/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.integration.jei.category;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.camera.infrastructure.FilmType;
import io.github.mortuusars.exposure.integration.jei.ExposureJeiPlugin;
import io.github.mortuusars.exposure.integration.jei.recipe.PhotographPrintingJeiRecipe;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public class PhotographPrintingCategory
implements IRecipeCategory<PhotographPrintingJeiRecipe> {
    private static final class_2960 TEXTURE = Exposure.resource("textures/gui/jei/photograph_printing.png");
    private final class_2561 title = class_2561.method_43471((String)"jei.exposure.photograph_printing.title");
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawableStatic filmDrawable;

    public PhotographPrintingCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(TEXTURE, 0, 0, 170, 80);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new class_1799((class_1935)Exposure.Items.LIGHTROOM.get()));
        this.filmDrawable = guiHelper.createDrawable(TEXTURE, 0, 80, 170, 80);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, @NotNull PhotographPrintingJeiRecipe recipe, @NotNull IFocusGroup focuses) {
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 78, 17).addItemStack(new class_1799(recipe.getFilmType() == FilmType.COLOR ? (class_1935)Exposure.Items.DEVELOPED_COLOR_FILM.get() : (class_1935)Exposure.Items.DEVELOPED_BLACK_AND_WHITE_FILM.get()))).setSlotName("Film");
        List papers = class_7923.field_41178.method_40266(Exposure.Tags.Items.PHOTO_PAPERS).map(holders -> holders.method_40239().map(itemHolder -> new class_1799((class_1935)itemHolder.comp_349())).collect(Collectors.toList())).orElse(Collections.emptyList());
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.CATALYST, 6, 55).addItemStacks(papers)).setSlotName("Paper");
        if (recipe.getFilmType() == FilmType.COLOR) {
            List cyanDyes = class_7923.field_41178.method_40266(Exposure.Tags.Items.CYAN_PRINTING_DYES).map(holders -> holders.method_40239().map(itemHolder -> new class_1799((class_1935)itemHolder.comp_349())).collect(Collectors.toList())).orElse(Collections.emptyList());
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.CATALYST, 40, 55).addItemStacks(cyanDyes)).setSlotName("Cyan");
            List magentaDyes = class_7923.field_41178.method_40266(Exposure.Tags.Items.MAGENTA_PRINTING_DYES).map(holders -> holders.method_40239().map(itemHolder -> new class_1799((class_1935)itemHolder.comp_349())).collect(Collectors.toList())).orElse(Collections.emptyList());
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.CATALYST, 58, 55).addItemStacks(magentaDyes)).setSlotName("Magenta");
            List yellowDyes = class_7923.field_41178.method_40266(Exposure.Tags.Items.YELLOW_PRINTING_DYES).map(holders -> holders.method_40239().map(itemHolder -> new class_1799((class_1935)itemHolder.comp_349())).collect(Collectors.toList())).orElse(Collections.emptyList());
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.CATALYST, 76, 55).addItemStacks(yellowDyes)).setSlotName("Yellow");
        }
        List blackDyes = class_7923.field_41178.method_40266(Exposure.Tags.Items.BLACK_PRINTING_DYES).map(holders -> holders.method_40239().map(itemHolder -> new class_1799((class_1935)itemHolder.comp_349())).collect(Collectors.toList())).orElse(Collections.emptyList());
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.CATALYST, 94, 55).addItemStacks(blackDyes)).setSlotName("Black");
        builder.addSlot(RecipeIngredientRole.OUTPUT, 144, 55).addItemStack(new class_1799((class_1935)Exposure.Items.PHOTOGRAPH.get()));
    }

    public void draw(PhotographPrintingJeiRecipe recipe, @NotNull IRecipeSlotsView recipeSlotsView, @NotNull class_332 guiGraphics, double mouseX, double mouseY) {
        if (recipe.getFilmType() == FilmType.COLOR) {
            RenderSystem.setShaderColor((float)1.1f, (float)0.86f, (float)0.66f, (float)1.0f);
        }
        this.filmDrawable.draw(guiGraphics);
    }

    @NotNull
    public RecipeType<PhotographPrintingJeiRecipe> getRecipeType() {
        return ExposureJeiPlugin.PHOTOGRAPH_PRINTING_RECIPE_TYPE;
    }

    @NotNull
    public class_2561 getTitle() {
        return this.title;
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }
}

