/*
 * Decompiled with CFR 0.152.
 */
package mod.linguardium.linkedportals.blocks.blockentity;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.attachment.ChunkAttachment;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import mod.linguardium.linkedportals.blocks.PortalControlBlock;
import mod.linguardium.linkedportals.interfaces.ElementHolderHolder;
import mod.linguardium.linkedportals.interfaces.PortalStructurePart;
import mod.linguardium.linkedportals.interfaces.ReportsToController;
import mod.linguardium.linkedportals.interfaces.Tickable;
import mod.linguardium.linkedportals.misc.FloatingItemInventorySlotElement;
import mod.linguardium.linkedportals.misc.LinkedPortalsUtil;
import mod.linguardium.linkedportals.portal.LinkedPortalManager;
import mod.linguardium.linkedportals.portal.PortalBuilder;
import mod.linguardium.linkedportals.portal.PortalStructure;
import mod.linguardium.linkedportals.registry.LinkedPortalBlockEntities;
import mod.linguardium.linkedportals.registry.LinkedPortalBlocks;
import mod.linguardium.linkedportals.registry.LinkedPortalRegistries;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1277;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_4208;
import net.minecraft.class_5321;
import net.minecraft.class_7871;
import net.minecraft.class_7923;
import net.minecraft.class_811;
import net.minecraft.class_8181;
import org.jetbrains.annotations.Nullable;

public class PortalControlBlockEntity
extends class_2586
implements PortalStructurePart,
ElementHolderHolder,
class_8181,
Tickable {
    private PortalStructure structure;
    private class_1799 keyStack = class_1799.field_8037;
    private ElementHolder keyItemElementHolder = new ElementHolder();
    private FloatingItemInventorySlotElement keyItemDisplay;
    private UUID portalGroupID = class_156.field_25140;
    private class_4208 globalPos;
    private boolean structureDirty = true;
    private boolean firstTick = true;
    private class_2680 baseBlock = class_2246.field_10124.method_9564();

    public PortalControlBlockEntity(class_2338 pos, class_2680 state) {
        super(LinkedPortalBlockEntities.PORTAL_CONTROL_BLOCKENTITY_TYPE, pos, state);
    }

    public void setBaseBlock(class_2680 state) {
        this.baseBlock = state;
        this.method_5431();
    }

    public class_2680 getBaseBlock() {
        return this.baseBlock;
    }

    public Optional<PortalStructure> getPortalStructure() {
        return Optional.ofNullable(this.structure);
    }

    public Optional<UUID> getPortalGroupId() {
        if (this.portalGroupID == null || this.portalGroupID.equals(class_156.field_25140)) {
            return Optional.empty();
        }
        return Optional.of(this.portalGroupID);
    }

    public class_1799 getKeyStackCopy() {
        return this.keyStack.method_7972();
    }

    public boolean setPortalKey(class_1799 portalKey) {
        class_1937 class_19372 = this.method_10997();
        if (!(class_19372 instanceof class_3218)) {
            return false;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        this.destroy(false);
        if (!portalKey.method_7960()) {
            class_1799 newStack = portalKey.method_46651(1);
            Optional<PortalStructure> maybeStructure = PortalBuilder.findPortal((class_1937)serverWorld, this.method_11016(), LinkedPortalRegistries.portalTypes().method_40270().collect(Collectors.toList()));
            if (maybeStructure.isEmpty()) {
                return false;
            }
            UUID portalId = LinkedPortalsUtil.getUUIDfromItemStack(newStack);
            this.setPortal(serverWorld, portalId, maybeStructure.get());
            this.setKeyStack(newStack);
            portalKey.method_7934(1);
            if (!portalKey.method_7960()) {
                class_1264.method_5451((class_1937)serverWorld, (class_2338)this.method_11016(), (class_1263)new class_1277(new class_1799[]{portalKey}));
            }
        }
        serverWorld.method_8501(this.method_11016(), (class_2680)this.method_11010().method_11657((class_2769)PortalControlBlock.ACTIVE, (Comparable)Boolean.valueOf(this.getPortalGroupId().isPresent())));
        this.method_5431();
        return true;
    }

    public void setPortal(class_3218 serverWorld, UUID portalId, PortalStructure structure) {
        this.setPortalGroupID(portalId);
        this.setPortalStructure(structure);
        if (this.getPortalGroupId().isPresent() && this.getPortalStructure().isPresent()) {
            LinkedPortalManager.activateController(portalId, serverWorld, this.method_11016());
            this.fillTeleportationBlocks(serverWorld);
        }
        this.method_5431();
    }

    private void fillTeleportationBlocks(class_3218 serverWorld) {
        Optional<PortalStructure> maybePortalStructure = this.getPortalStructure();
        if (maybePortalStructure.isEmpty()) {
            return;
        }
        maybePortalStructure.get().teleporters().forEach(blockPos -> {
            serverWorld.method_8501(blockPos, (class_2680)LinkedPortalBlocks.PORTAL_FILL_BLOCK.method_9564().method_11657((class_2769)class_2741.field_12525, (Comparable)this.method_11010().method_28500((class_2769)class_2741.field_12525).orElse(class_2350.field_11043)));
            class_2586 patt6386$temp = serverWorld.method_8321(blockPos);
            if (patt6386$temp instanceof ReportsToController) {
                ReportsToController reporter = (ReportsToController)patt6386$temp;
                reporter.setControllerPos(this.method_11016());
            }
        });
    }

    public void setPortalStructure(PortalStructure structure) {
        this.structure = structure;
        this.method_5431();
    }

    public void setKeyStack(class_1799 key) {
        this.keyStack = key;
        this.setKeyItemDisplay(key);
        this.method_5431();
    }

    public void setKeyItemDisplay(class_1799 key) {
        this.keyItemElementHolder.removeElement((VirtualElement)this.keyItemDisplay);
        this.createKeyItemDisplay(key.method_46651(1));
        this.keyItemElementHolder.addElement((VirtualElement)this.keyItemDisplay);
    }

    public void setPortalGroupID(UUID id) {
        this.portalGroupID = id;
        this.method_5431();
    }

    public void validateOrDestroy() {
        if (this.getKeyStackCopy().method_7960()) {
            this.destroy(false);
            return;
        }
        if (!this.getPortalStructure().map(portalStructure -> portalStructure.validate((class_1936)this.method_10997())).orElse(true).booleanValue()) {
            this.destroy(false);
        }
    }

    public void markStructureDirty() {
        this.structureDirty = true;
    }

    public void destroyStructure(class_3218 serverWorld) {
        this.getPortalStructure().ifPresent(portalStructure -> portalStructure.teleporters().forEach(pos -> serverWorld.method_22352(pos, false)));
        this.setPortalStructure(null);
    }

    public void method_31662(class_1937 world) {
        super.method_31662(world);
        if (world instanceof class_3218) {
            this.getElementHolder().destroy();
            if (this.keyItemDisplay == null) {
                this.createKeyItemDisplay(this.method_54079());
            }
            this.getElementHolder().addElement((VirtualElement)this.keyItemDisplay);
            this.globalPos = class_4208.method_19443((class_5321)world.method_27983(), (class_2338)this.method_11016());
        }
    }

    private void createKeyItemDisplay(class_1799 stack) {
        if (stack == null) {
            return;
        }
        this.keyItemDisplay = new FloatingItemInventorySlotElement(stack, this.method_11010().method_28500((class_2769)class_2741.field_12525).orElse(class_2350.field_11043));
        this.keyItemDisplay.setOffset(class_243.field_1353);
        this.keyItemDisplay.setModelTransformation(class_811.field_4319);
        this.keyItemDisplay.setShadowRadius(0.0f);
        this.keyItemDisplay.setShadowStrength(0.0f);
    }

    @Override
    public void tick(class_1937 world, class_2338 pos, class_2680 state) {
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            if (this.keyItemElementHolder.getAttachment() == null) {
                ChunkAttachment.of((ElementHolder)this.getElementHolder(), (class_3218)serverWorld, (class_2338)this.method_11016());
            }
        }
        if (this.structureDirty || world.method_8510() % 100L == 0L) {
            this.validateOrDestroy();
            this.structureDirty = false;
        }
        this.keyItemElementHolder.tick();
    }

    public void destroy(boolean removal) {
        class_1937 class_19372 = this.method_10997();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        this.dropKeyItem(serverWorld);
        this.destroyStructure(serverWorld);
        this.setPortalGroupID(class_156.field_25140);
        if (removal && this.keyItemElementHolder != null) {
            this.keyItemElementHolder.destroy();
        }
        LinkedPortalManager.deactivateController(serverWorld, this.method_11016());
    }

    private void dropKeyItem(class_3218 serverWorld) {
        if (!this.keyStack.method_7960()) {
            class_1264.method_5451((class_1937)serverWorld, (class_2338)this.method_11016().method_10093(this.method_11010().method_28500((class_2769)class_2741.field_12525).orElse(class_2350.field_11036)), (class_1263)new class_1277(new class_1799[]{this.keyStack}));
            this.keyStack = class_1799.field_8037;
            this.setKeyItemDisplay(this.keyStack);
        }
        this.method_5431();
    }

    @Override
    @Nullable
    public class_2338 getControllerPos() {
        return this.method_11016();
    }

    @Override
    public ElementHolder getElementHolder() {
        return this.keyItemElementHolder;
    }

    @Override
    public void setElementHolder(ElementHolder holder) {
        class_1937 class_19372 = this.method_10997();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        if (holder != null) {
            if (this.keyItemElementHolder != null) {
                this.keyItemElementHolder.destroy();
            }
            this.keyItemElementHolder = holder;
            holder.addElement((VirtualElement)this.keyItemDisplay);
            ChunkAttachment.of((ElementHolder)holder, (class_3218)serverWorld, (class_2338)this.method_11016());
        }
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.keyStack = class_1799.field_8037;
        this.portalGroupID = class_156.field_25140;
        this.structure = null;
        this.baseBlock = class_2246.field_10124.method_9564();
        if (nbt.method_10573("KeyItem", 10)) {
            this.keyStack = class_1799.method_7915((class_2487)nbt.method_10562("KeyItem"));
        }
        this.setKeyItemDisplay(this.keyStack);
        if (nbt.method_10573("PortalStructure", 10)) {
            try {
                this.structure = (PortalStructure)class_156.method_47526((DataResult)PortalStructure.CODEC.parse((DynamicOps)class_2509.field_11560, (Object)nbt.method_10562("PortalStructure")), RuntimeException::new);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        if (nbt.method_10573("PortalGroupId", 11)) {
            try {
                this.portalGroupID = nbt.method_25926("PortalGroupId");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (nbt.method_10545("BaseBlock")) {
            this.baseBlock = class_2512.method_10681((class_7871)class_7923.field_41175.method_46771(), (class_2487)nbt.method_10562("BaseBlock"));
        }
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10566("KeyItem", (class_2520)this.method_54079().method_7953(new class_2487()));
        this.getPortalStructure().ifPresent(portalStructure -> {
            try {
                nbt.method_10566("PortalStructure", (class_2520)class_156.method_47526((DataResult)PortalStructure.CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)this.structure), RuntimeException::new));
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        });
        this.getPortalGroupId().ifPresent(portalId -> nbt.method_25927("PortalGroupId", portalId));
        if (!this.baseBlock.method_27852(class_2246.field_10124)) {
            nbt.method_10566("BaseBlock", (class_2520)class_2512.method_10686((class_2680)this.baseBlock));
        }
    }

    public class_1799 method_54079() {
        return this.keyStack;
    }

    public class_1799 method_54078(int count) {
        class_1799 oldStack = this.keyStack.method_7972();
        class_1799 returnedStack = oldStack.method_7971(count);
        this.method_54077(oldStack);
        return returnedStack;
    }

    public void method_54077(class_1799 stack) {
        class_1799 droppedStack = stack.method_7972();
        this.setPortalKey(droppedStack.method_7971(1));
        if (this.method_54079().method_7960()) {
            droppedStack = stack;
        }
        class_1264.method_5451((class_1937)this.method_10997(), (class_2338)this.method_11016(), (class_1263)new class_1277(new class_1799[]{droppedStack}));
    }

    public class_2586 method_54080() {
        return this;
    }
}

