/*
 * Decompiled with CFR 0.152.
 */
package mod.linguardium.linkedportals.events;

import java.util.Optional;
import mod.linguardium.linkedportals.blocks.base.AbstractPortalStructureBlock;
import mod.linguardium.linkedportals.blocks.blockentity.PortalControlBlockEntity;
import mod.linguardium.linkedportals.interfaces.PortalUser;
import mod.linguardium.linkedportals.portal.LinkedPortalManager;
import mod.linguardium.linkedportals.portal.PortalStructure;
import mod.linguardium.linkedportals.registry.LinkedPortalBlocks;
import net.fabricmc.fabric.api.dimension.v1.FabricDimensions;
import net.minecraft.class_1297;
import net.minecraft.class_1684;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_4208;
import net.minecraft.class_5454;

public class PortalEvents {
    public static void entityEnteredPortal(class_1297 entity) {
        class_1937 class_19372 = entity.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        if (entity instanceof class_1684) {
            class_1684 enderPearl = (class_1684)entity;
            if (enderPearl.method_24921() != null) {
                PortalEvents.handleEnderPearl(serverWorld, enderPearl);
            }
            return;
        }
        if (!(entity instanceof PortalUser)) {
            return;
        }
        PortalUser portalUser = (PortalUser)entity;
        portalUser.linkedportals$setIsInPortal(true);
    }

    public static void handleEnderPearl(class_3218 serverWorld, class_1684 enderPearl) {
        PortalEvents.getControllerFromPositionOrEmpty(serverWorld, (class_1297)enderPearl).ifPresent(controller -> PortalEvents.handleTeleportationHandler(serverWorld, controller, enderPearl.method_24921()));
    }

    public static Optional<PortalControlBlockEntity> getControllerFromPositionOrEmpty(class_3218 serverWorld, class_1297 entity) {
        Optional<class_2338> maybePos = class_2338.method_29715((class_238)entity.method_5829()).filter(pos -> serverWorld.method_8320(pos).method_27852(LinkedPortalBlocks.PORTAL_FILL_BLOCK)).findAny();
        if (maybePos.isEmpty()) {
            return Optional.empty();
        }
        class_2338 pos2 = maybePos.get();
        return ((AbstractPortalStructureBlock)serverWorld.method_8320(pos2).method_26204()).getControllerBlockEntity((class_1936)serverWorld, pos2);
    }

    public static void tickPortalTime(class_1297 entity, PortalUser portalUser) {
        class_1937 class_19372 = entity.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        Optional<class_2338> maybePos = class_2338.method_29715((class_238)entity.method_5829()).filter(pos -> serverWorld.method_8320(pos).method_27852(LinkedPortalBlocks.PORTAL_FILL_BLOCK)).findAny();
        PortalControlBlockEntity controller = PortalEvents.getControllerFromPositionOrEmpty(serverWorld, entity).orElse(null);
        boolean inPortal = maybePos.isPresent();
        if (inPortal && entity instanceof class_1684) {
            class_1684 enderPearl = (class_1684)entity;
            PortalEvents.handleEnderPearl(serverWorld, enderPearl);
            return;
        }
        if (inPortal != portalUser.linkedportals$isInPortal()) {
            portalUser.linkedportals$setIsInPortal(inPortal);
        }
        if (!(inPortal || portalUser.linkedportals$getPortalDamageTimer() <= 0L && portalUser.linkedportals$getPortalDamageIterations() <= 0)) {
            portalUser.linkedportals$setPortalDamageTimer(0L);
            portalUser.linkedportals$setPortalDamageIterations(0);
        }
        if (portalUser.linkedportals$hasPortalCooldown()) {
            if (!inPortal) {
                portalUser.linkedportals$decrementPortalCooldown();
            } else {
                portalUser.linkedportals$resetPortalCooldown();
            }
            return;
        }
        if (inPortal && controller != null && portalUser.linkedportals$incrementTimeInPortal()) {
            PortalEvents.handleTeleportationHandler(serverWorld, controller, entity);
        }
    }

    public static Optional<class_4208> getNextControllerLocation(class_3218 serverWorld, PortalControlBlockEntity controller) {
        return controller.getPortalGroupId().flatMap(portalId -> LinkedPortalManager.getNextPortal(portalId, serverWorld, controller.method_11016()));
    }

    public static void handleTeleportationHandler(class_3218 serverWorld, PortalControlBlockEntity controller, class_1297 entity) {
        Optional<class_4208> nextPortalControllerLocation = PortalEvents.getNextControllerLocation(serverWorld, controller);
        nextPortalControllerLocation.ifPresentOrElse(nextPortal -> PortalEvents.attemptTeleport(serverWorld, entity, nextPortal), () -> PortalEvents.handleMissingOutputPortal(serverWorld, entity));
    }

    public static void handleMissingOutputPortal(class_3218 serverWorld, class_1297 entity) {
        if (entity instanceof class_3222) {
            class_3222 serverPlayerEntity = (class_3222)entity;
            PortalUser user = (PortalUser)entity;
            if (serverPlayerEntity.method_7337() || serverPlayerEntity.method_7325()) {
                user.linkedportals$setPortalDamageTimer(0L);
                user.linkedportals$setPortalDamageIterations(0);
                return;
            }
            if (user.linkedportals$decrementPortalDamageTimer()) {
                int iterations = user.linkedportals$getPortalDamageIterations();
                float screamVolume = 1.0f + (float)Math.floor(0.3f * (float)iterations);
                class_3417.field_14564.comp_349();
                class_3414 soundEvent = switch (iterations) {
                    case 2 -> class_3417.field_14713;
                    case 3 -> class_3417.field_14967;
                    default -> (class_3414)class_3417.field_14564.comp_349();
                };
                serverWorld.method_43129(null, entity, soundEvent, class_3419.field_15248, screamVolume, 1.0f);
                serverPlayerEntity.method_7353((class_2561)class_2561.method_43470((String)("The void calls..." + (3 - iterations))), true);
                if (iterations > 0) {
                    float damageDivisor = 3.0f / (float)iterations;
                    serverPlayerEntity.method_5643(serverWorld.method_48963().method_48829(), serverPlayerEntity.method_6032() / damageDivisor);
                }
                user.linkedportals$setPortalDamageTimer(Math.max(entity.method_5741(), 60));
                user.linkedportals$setPortalDamageIterations(iterations + 1);
                user.linkedportals$setTimeInPortal(0L);
            }
        }
    }

    public static void attemptTeleport(class_3218 serverWorld, class_1297 entity, class_4208 targetControllerPos) {
        PortalControlBlockEntity controller;
        Optional<PortalStructure> maybeStructure;
        class_2586 class_25862;
        class_3218 targetWorld = serverWorld.method_8503().method_3847(targetControllerPos.method_19442());
        ((PortalUser)entity).linkedportals$resetPortalCooldown();
        if (targetWorld != null && (class_25862 = targetWorld.method_8321(targetControllerPos.method_19446())) instanceof PortalControlBlockEntity && (maybeStructure = (controller = (PortalControlBlockEntity)class_25862).getPortalStructure()).isPresent()) {
            class_243 lowestBlockPos = maybeStructure.get().getLowestTeleportPos();
            if (lowestBlockPos == null) {
                return;
            }
            FabricDimensions.teleport((class_1297)entity, (class_3218)targetWorld, (class_5454)new class_5454(lowestBlockPos, class_243.field_1353, maybeStructure.get().facing().method_10144(), 0.0f));
        }
    }
}

