/*
 * Decompiled with CFR 0.152.
 */
package mod.linguardium.linkedportals.portal;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import mod.linguardium.linkedportals.LinkedPortals;
import net.minecraft.class_156;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_4208;
import net.minecraft.class_4844;
import net.minecraft.class_5218;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;

public class LinkedPortalManager {
    private static final String PORTALS_KEY = "Portals";
    private static LinkedPortalManager instance;
    public static final Codec<Map.Entry<UUID, class_4208>> PORTAL_ENTRY_CODEC;
    public static final Codec<LinkedListMultimap<UUID, class_4208>> PORTAL_LIST_CODEC;
    LinkedListMultimap<UUID, class_4208> activatedControllers = LinkedListMultimap.create();
    private final MinecraftServer server;
    private final Path portalSavePath;
    private boolean dirty = false;

    private static List<Map.Entry<UUID, class_4208>> toList(LinkedListMultimap<UUID, class_4208> map) {
        return map.entries();
    }

    private static LinkedListMultimap<UUID, class_4208> toMap(List<Map.Entry<UUID, class_4208>> pairs) {
        LinkedListMultimap map = LinkedListMultimap.create();
        pairs.forEach(entry -> map.put((Object)((UUID)entry.getKey()), (Object)((class_4208)entry.getValue())));
        return map;
    }

    public static void activateController(UUID portalId, class_3218 world, class_2338 pos) {
        MinecraftServer server = world.method_8503();
        class_4208 controllerPosition = class_4208.method_19443((class_5321)world.method_27983(), (class_2338)pos);
        LinkedPortalManager.getInstance((MinecraftServer)server).activatedControllers.values().remove(controllerPosition);
        LinkedPortalManager.getInstance((MinecraftServer)server).activatedControllers.put((Object)portalId, (Object)controllerPosition);
        LinkedPortalManager.getInstance(server).markDirty();
    }

    public static void deactivateController(class_3218 world, class_2338 pos) {
        MinecraftServer server = world.method_8503();
        class_4208 controllerPosition = class_4208.method_19443((class_5321)world.method_27983(), (class_2338)pos);
        LinkedPortalManager.getInstance((MinecraftServer)server).activatedControllers.values().remove(controllerPosition);
        LinkedPortalManager.getInstance(server).markDirty();
    }

    public static Optional<class_4208> getNextPortal(UUID portalId, class_3218 world, class_2338 pos) {
        MinecraftServer server = world.method_8503();
        class_4208 controllerPosition = class_4208.method_19443((class_5321)world.method_27983(), (class_2338)pos);
        List portals = LinkedPortalManager.getInstance((MinecraftServer)server).activatedControllers.get((Object)portalId);
        if (portals.size() < 2) {
            return Optional.empty();
        }
        Iterator portalIter = portals.iterator();
        boolean found = false;
        while (portalIter.hasNext() && !found) {
            class_4208 portal = (class_4208)portalIter.next();
            if (!portal.equals((Object)controllerPosition)) continue;
            found = true;
        }
        if (!found) {
            return Optional.empty();
        }
        if (!portalIter.hasNext()) {
            return Optional.of((class_4208)portals.get(0));
        }
        return Optional.of((class_4208)portalIter.next());
    }

    public static LinkedPortalManager getInstance(MinecraftServer server) {
        if (instance == null) {
            LinkedPortalManager.load(server);
        }
        return instance;
    }

    private Path getSavePath() {
        return this.server.method_27050(class_5218.field_24188).resolve("data").resolve("linkedportals.nbt");
    }

    public static void load(MinecraftServer server) {
        instance = new LinkedPortalManager(server);
    }

    public LinkedPortalManager(MinecraftServer server) {
        this.server = server;
        this.portalSavePath = this.getSavePath();
        try {
            this.load();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void load() throws IOException {
        if (!Files.exists(this.portalSavePath.getParent(), new LinkOption[0])) {
            Files.createDirectories(this.portalSavePath.getParent(), new FileAttribute[0]);
        }
        if (Files.exists(this.portalSavePath, new LinkOption[0])) {
            class_2487 nbt = class_2507.method_10629((InputStream)Files.newInputStream(this.portalSavePath, StandardOpenOption.READ), (class_2505)class_2505.method_53898());
            class_2520 element = nbt.method_10580(PORTALS_KEY);
            try {
                LinkedListMultimap map = (LinkedListMultimap)class_156.method_47526((DataResult)PORTAL_LIST_CODEC.parse((DynamicOps)class_2509.field_11560, (Object)element), RuntimeException::new);
                this.activatedControllers.putAll((Multimap)map);
            }
            catch (RuntimeException exception) {
                LinkedPortals.LOGGER.error(exception.getMessage(), (Throwable)exception);
            }
        }
    }

    public void save() throws IOException {
        if (!this.isDirty()) {
            return;
        }
        class_2487 saveData = new class_2487();
        try {
            class_2520 nbtElement = (class_2520)class_156.method_47526((DataResult)PORTAL_LIST_CODEC.encodeStart((DynamicOps)class_2509.field_11560, this.activatedControllers), RuntimeException::new);
            saveData.method_10566(PORTALS_KEY, nbtElement);
        }
        catch (RuntimeException exception) {
            LinkedPortals.LOGGER.error(exception.getMessage(), (Throwable)exception);
        }
        Path savePath = this.getSavePath();
        if (!Files.exists(savePath.getParent(), new LinkOption[0])) {
            Files.createDirectories(savePath.getParent(), new FileAttribute[0]);
        }
        class_2507.method_30614((class_2487)saveData, (Path)savePath);
        this.markDirty(false);
    }

    public void markDirty() {
        this.markDirty(true);
    }

    public void markDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    static {
        PORTAL_ENTRY_CODEC = RecordCodecBuilder.create(entryInstance -> entryInstance.group((App)class_4844.field_40825.fieldOf("PortalId").forGetter(Map.Entry::getKey), (App)class_4208.field_25066.fieldOf("ControllerPos").forGetter(Map.Entry::getValue)).apply((Applicative)entryInstance, Map::entry));
        PORTAL_LIST_CODEC = Codec.list(PORTAL_ENTRY_CODEC).xmap(LinkedPortalManager::toMap, LinkedPortalManager::toList);
    }
}

