/*
 * Decompiled with CFR 0.152.
 */
package mod.linguardium.linkedportals.portal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import mod.linguardium.linkedportals.config.LinkedPortalType;
import mod.linguardium.linkedportals.portal.PortalStructure;
import mod.linguardium.linkedportals.registry.LinkedPortalBlocks;
import mod.linguardium.linkedportals.registry.LinkedPortalRegistries;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.class_3825;
import net.minecraft.class_6880;

public class PortalBuilder {
    class_3825 edgeValidator;
    class_3825 interiorValidator;
    class_2338 startPos;
    int limit;
    class_2350 projectionDirection;
    class_2350.class_2351 spanAxis;
    class_2350 portalFacing;
    List<class_3545<class_2338, class_2338>> layers;
    class_2960 portalType;
    Collection<class_6880<LinkedPortalType>> validPortalTypes;
    class_2338 foundController = null;

    public static Optional<PortalStructure> findPortal(class_1937 world, class_2338 startPos, Collection<class_6880<LinkedPortalType>> validPortalTypes) {
        PortalBuilder builder = new PortalBuilder(validPortalTypes);
        if (!builder.iteratePortalTypesToFind(world, startPos)) {
            return Optional.empty();
        }
        return Optional.of(builder.getStructure());
    }

    private PortalBuilder(Collection<class_6880<LinkedPortalType>> validPortalTypes) {
        this.validPortalTypes = validPortalTypes;
    }

    private boolean iteratePortalTypesToFind(class_1937 world, class_2338 startFramePos) {
        this.startPos = startFramePos;
        for (class_6880<LinkedPortalType> registryEntry : this.validPortalTypes) {
            LinkedPortalType type = (LinkedPortalType)registryEntry.comp_349();
            this.portalType = registryEntry.method_40230().orElse(LinkedPortalRegistries.ENTRY_LINKED_PORTAL_TYPE_DEFAULT_KEY).method_29177();
            this.interiorValidator = type.innerBlockStateValidator();
            this.edgeValidator = type.frameBlockStateValidator();
            this.limit = type.limit();
            if (!this.findPortalOfType(world)) continue;
            return true;
        }
        this.portalType = null;
        this.edgeValidator = null;
        this.interiorValidator = null;
        this.startPos = null;
        this.foundController = null;
        return false;
    }

    private boolean findPortalOfType(class_1937 world) {
        Predicate<class_2338> interiorPosValidator = this.getPosValidator(world, this.interiorValidator);
        Predicate<class_2338> framePosValidator = this.getEdgePosValidator(world, this.edgeValidator);
        if (!framePosValidator.test(this.startPos)) {
            return false;
        }
        class_2350[] class_2350Array = class_2350.values();
        int n = class_2350Array.length;
        for (int i = 0; i < n; ++i) {
            class_2350 projectionDirectionTry;
            this.projectionDirection = projectionDirectionTry = class_2350Array[i];
            this.foundController = null;
            for (class_2350.class_2351 spanAxisTry : class_2350.class_2351.values()) {
                this.layers = new ArrayList<class_3545<class_2338, class_2338>>();
                this.spanAxis = spanAxisTry;
                if (this.spanAxis.equals((Object)this.projectionDirection.method_10166())) continue;
                this.portalFacing = this.projectionDirection.method_35833(this.spanAxis);
                if (!this.getPortalLayers(interiorPosValidator, framePosValidator)) continue;
                return true;
            }
        }
        this.layers = new ArrayList<class_3545<class_2338, class_2338>>();
        return false;
    }

    private boolean getPortalLayers(Predicate<class_2338> interiorPosValidator, Predicate<class_2338> framePosValidator) {
        Optional<class_3545<class_2338, class_2338>> maybeLayer;
        while (this.layers.size() < this.limit - 2 && !(maybeLayer = this.getNextLayer(interiorPosValidator, framePosValidator)).isEmpty()) {
            class_3545<class_2338, class_2338> layer = maybeLayer.get();
            if (this.layers.isEmpty() && !this.addFrameLayer(layer, this.projectionDirection, framePosValidator)) {
                return false;
            }
            this.layers.add(layer);
        }
        if (this.layers.size() < 2) {
            return false;
        }
        class_3545<class_2338, class_2338> lastLayer = this.layers.get(this.layers.size() - 1);
        if (!this.addFrameLayer(lastLayer, this.projectionDirection.method_10153(), framePosValidator)) {
            return false;
        }
        return this.checkLayerBounds();
    }

    private boolean checkLayerBounds() {
        if (this.layers.size() < 3) {
            return false;
        }
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        for (int i = 1; i < this.layers.size(); ++i) {
            class_3545<class_2338, class_2338> prevLayer;
            class_3545<class_2338, class_2338> thisLayer = this.layers.get(i);
            if (!this.leftAndRightEdgesWithinRange(thisLayer, prevLayer = this.layers.get(i - 1))) {
                return false;
            }
            int leftAxisValue = ((class_2338)thisLayer.method_15442()).method_30558(this.spanAxis);
            int rightAxisValue = ((class_2338)thisLayer.method_15441()).method_30558(this.spanAxis);
            min = Math.min(min, Math.min(leftAxisValue, rightAxisValue));
            max = Math.max(max, Math.max(leftAxisValue, rightAxisValue));
        }
        return max - min < this.limit && max - min >= 0;
    }

    private boolean leftAndRightEdgesWithinRange(class_3545<class_2338, class_2338> pos1, class_3545<class_2338, class_2338> pos2) {
        return ((class_2338)pos1.method_15442()).method_19455((class_2382)pos2.method_15442()) <= 2 && ((class_2338)pos1.method_15441()).method_19455((class_2382)pos2.method_15441()) <= 2;
    }

    private boolean addFrameLayer(class_3545<class_2338, class_2338> comparisonLayer, class_2350 offsetDirection, Predicate<class_2338> frameValidator) {
        class_3545 frameLayer = new class_3545(null, null);
        int distance = ((class_2338)comparisonLayer.method_15441()).method_30558(this.spanAxis) - ((class_2338)comparisonLayer.method_15442()).method_30558(this.spanAxis);
        --distance;
        frameLayer.method_34964((Object)((class_2338)comparisonLayer.method_15442()).method_10093(offsetDirection.method_10153()).method_30513(this.spanAxis, 1));
        if (!frameValidator.test((class_2338)frameLayer.method_15442())) {
            return false;
        }
        Optional<class_2338> foundPos = this.moveAlong((class_2338)frameLayer.method_15442(), class_2350.method_10169((class_2350.class_2351)this.spanAxis, (class_2350.class_2352)class_2350.class_2352.field_11056), distance, frameValidator, pos -> true);
        if (foundPos.isEmpty()) {
            return false;
        }
        frameLayer.method_34965((Object)foundPos.get());
        this.layers.add((class_3545<class_2338, class_2338>)frameLayer);
        return true;
    }

    private Predicate<class_2338> getPosValidator(class_1937 world, class_3825 validationRuleTest) {
        return blockPos -> validationRuleTest.method_16768(world.method_8320(blockPos), world.method_8409());
    }

    private Predicate<class_2338> getEdgePosValidator(class_1937 world, class_3825 validationRuleTest) {
        return pos -> {
            class_2680 state = world.method_8320(pos);
            if (state.method_27852(LinkedPortalBlocks.PORTAL_CONTROL_BLOCK) && (this.foundController == null || pos.equals((Object)this.foundController))) {
                this.foundController = pos.method_10062();
                return true;
            }
            return validationRuleTest.method_16768(state, world.method_8409());
        };
    }

    private int getFirstEdgeDistanceFromCenter() {
        if (this.layers.isEmpty()) {
            return this.limit;
        }
        return 2;
    }

    private int getNextSecondEdgeDistanceFromFirstEdge() {
        if (this.layers.isEmpty()) {
            return this.limit;
        }
        class_3545<class_2338, class_2338> lastLayer = this.layers.get(this.layers.size() - 1);
        return 2 + ((class_2338)lastLayer.method_15441()).method_30558(this.spanAxis) - ((class_2338)lastLayer.method_15442()).method_30558(this.spanAxis);
    }

    private class_2338 getNextCenterPos(class_2350 projectionDirection, class_2350.class_2351 spanAxis) {
        if (this.layers.isEmpty()) {
            return this.startPos.method_10093(projectionDirection);
        }
        return ((class_2338)this.layers.get(this.layers.size() - 1).method_15442()).method_10093(projectionDirection).method_30513(spanAxis, 1);
    }

    private Optional<class_3545<class_2338, class_2338>> getNextLayer(Predicate<class_2338> interiorValidator, Predicate<class_2338> frameValidator) {
        class_3545 foundPair = new class_3545(null, null);
        Optional<class_2338> foundPos = this.moveAlong(this.getNextCenterPos(this.projectionDirection, this.spanAxis), class_2350.method_10169((class_2350.class_2351)this.spanAxis, (class_2350.class_2352)class_2350.class_2352.field_11060), this.getFirstEdgeDistanceFromCenter(), interiorValidator, frameValidator);
        if (foundPos.isEmpty()) {
            return Optional.empty();
        }
        foundPair.method_34964((Object)foundPos.get().method_30513(this.spanAxis, -1));
        foundPos = this.moveAlong(foundPos.get(), class_2350.method_10169((class_2350.class_2351)this.spanAxis, (class_2350.class_2352)class_2350.class_2352.field_11056), this.getNextSecondEdgeDistanceFromFirstEdge(), interiorValidator, frameValidator);
        if (foundPos.isPresent()) {
            foundPair.method_34965((Object)foundPos.get().method_30513(this.spanAxis, 1));
            int width = Math.abs(((class_2338)foundPair.method_15442()).method_10059((class_2382)foundPair.method_15441()).method_30558(this.spanAxis));
            if (width < 2 || width > this.limit) {
                return Optional.empty();
            }
            return Optional.of(foundPair);
        }
        return Optional.empty();
    }

    private Optional<class_2338> moveAlong(class_2338 startFromPos, class_2350 travelDirection, int limit, Predicate<class_2338> continueMatcher, Predicate<class_2338> edgeMatcher) {
        int distance = 0;
        class_2338.class_2339 pos = startFromPos.method_25503();
        while (++distance <= limit && continueMatcher.test((class_2338)pos)) {
            pos.method_10098(travelDirection);
        }
        if (edgeMatcher.test((class_2338)pos)) {
            return Optional.of(pos.method_10098(travelDirection.method_10153()).method_10062());
        }
        return Optional.empty();
    }

    private PortalStructure getStructure() {
        int layerCount = this.layers.size();
        if (layerCount < 3) {
            throw new RuntimeException("Tried to get structure from an incomplete portal builder!");
        }
        HashSet<class_2338> frames = new HashSet<class_2338>();
        HashSet teleporters = new HashSet();
        int lastLayerIndex = layerCount - 1;
        for (int i = 0; i < layerCount; ++i) {
            class_3545<class_2338, class_2338> layer = this.layers.get(i);
            if (i == 0 || i == lastLayerIndex) {
                class_2338.method_10097((class_2338)((class_2338)layer.method_15442()), (class_2338)((class_2338)layer.method_15441())).forEach(mutablePos -> frames.add(mutablePos.method_10062()));
                continue;
            }
            frames.add((class_2338)layer.method_15442());
            frames.add((class_2338)layer.method_15441());
            class_2338.method_10097((class_2338)((class_2338)layer.method_15442()).method_30513(this.spanAxis, 1), (class_2338)((class_2338)layer.method_15441()).method_30513(this.spanAxis, -1)).forEach(mutablePos -> teleporters.add(mutablePos.method_10062()));
        }
        frames.removeIf(pos -> pos.equals((Object)this.foundController));
        return new PortalStructure(List.copyOf(frames), List.copyOf(teleporters), this.portalFacing, this.portalType);
    }
}

