/*
 * Decompiled with CFR 0.152.
 */
package mod.linguardium.linkedportals.portal;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import mod.linguardium.linkedportals.LinkedPortals;
import mod.linguardium.linkedportals.config.LinkedPortalType;
import mod.linguardium.linkedportals.registry.LinkedPortalBlocks;
import mod.linguardium.linkedportals.registry.LinkedPortalRegistries;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3341;

public record PortalStructure(List<class_2338> frames, List<class_2338> teleporters, class_2350 facing, class_2960 portalType) {
    public static final PortalStructure EMPTY = new PortalStructure(List.of(), List.of(), class_2350.field_11043, LinkedPortals.id("default"));
    public static Codec<PortalStructure> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.list((Codec)class_2338.field_25064).fieldOf("FramePositions").forGetter(PortalStructure::frames), (App)Codec.list((Codec)class_2338.field_25064).fieldOf("TeleporterPositions").forGetter(PortalStructure::teleporters), (App)class_2350.field_29502.fieldOf("Facing").forGetter(PortalStructure::facing), (App)class_2960.field_25139.fieldOf("PortalType").forGetter(PortalStructure::portalType)).apply((Applicative)instance, PortalStructure::new));

    public boolean isEmpty() {
        return this.frames.isEmpty() && this.teleporters.isEmpty();
    }

    public boolean validate(class_1936 world) {
        LinkedPortalType type = LinkedPortalRegistries.portalTypes().method_17966(this.portalType()).orElse(null);
        if (type == null) {
            return false;
        }
        return this.frames.stream().allMatch(pos -> type.isValidFrameAtPosition(world, (class_2338)pos)) && this.teleporters.stream().allMatch(pos -> world.method_8320(pos).method_27852(LinkedPortalBlocks.PORTAL_FILL_BLOCK));
    }

    public class_243 getLowestTeleportPos() {
        class_243 center;
        if (this.facing().method_10166().equals((Object)class_2350.class_2351.field_11052) && (center = (class_243)class_3341.method_35411(this.teleporters()).map(box -> class_238.method_19316((class_3341)box).method_1005()).orElse(null)) != null) {
            return center;
        }
        class_2338 lowestBlockPos = null;
        for (class_2338 checkPos : this.teleporters()) {
            if (lowestBlockPos != null && checkPos.method_10264() >= lowestBlockPos.method_10264()) continue;
            lowestBlockPos = checkPos;
        }
        if (lowestBlockPos == null) {
            return null;
        }
        return lowestBlockPos.method_46558().method_38499(class_2350.class_2351.field_11052, (double)lowestBlockPos.method_10264());
    }
}

