/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.statement.api;

import com.google.common.collect.ImmutableSortedMap;
import java.util.Collections;
import java.util.Map;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import virtuoel.statement.util.StatementPropertyExtensions;

public interface MutableStateManager {
    default public Map<String, Property<?>> statement_getProperties() {
        return Collections.emptyMap();
    }

    default public void statement_setProperties(Map<String, Property<?>> properties) {
    }

    @Nullable
    default public <V extends Comparable<V>> Property<?> statement_addProperty(Property<V> property, V defaultValue) {
        return this.statement_addProperty(property);
    }

    @Nullable
    default public Property<?> statement_addProperty(Property<?> property) {
        String name;
        Map<String, Property<?>> properties = this.statement_getProperties();
        Property<?> ret = properties.get(name = ((StatementPropertyExtensions)property).statement_getName());
        if (ret != property) {
            ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
            builder.put((Object)name, property);
            if (ret != null) {
                for (Map.Entry<String, Property<?>> e : properties.entrySet()) {
                    Property<?> value = e.getValue();
                    if (value == ret) continue;
                    builder.put((Object)e.getKey(), value);
                }
            } else {
                builder.putAll(properties);
            }
            this.statement_setProperties((Map<String, Property<?>>)builder.build());
        }
        return ret;
    }

    @Nullable
    default public Property<?> statement_removeProperty(String propertyName) {
        Map<String, Property<?>> properties = this.statement_getProperties();
        Property<?> ret = properties.get(propertyName);
        if (ret != null) {
            ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
            for (Map.Entry<String, Property<?>> e : properties.entrySet()) {
                Property<?> value = e.getValue();
                if (value == ret) continue;
                builder.put((Object)e.getKey(), value);
            }
            this.statement_setProperties((Map<String, Property<?>>)builder.build());
        }
        return ret;
    }

    default public boolean statement_removeProperty(Property<?> property) {
        String name = ((StatementPropertyExtensions)property).statement_getName();
        return this.statement_removeProperty(name) != null;
    }
}

