/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.statement.api;

import java.util.Collection;
import java.util.Collections;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.IdMapper;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import virtuoel.statement.util.RegistryUtils;
import virtuoel.statement.util.StateRefresherImpl;

public interface StateRefresher {
    public static final StateRefresher INSTANCE = new StateRefresherImpl();

    default public <V extends Comparable<V>> Collection<BlockState> addBlockProperty(Block owner, Property<V> property, V defaultValue) {
        return this.addProperty(() -> ((Block)owner).m_49965_(), Block.f_49791_, property, defaultValue);
    }

    default public <V extends Comparable<V>> Collection<FluidState> addFluidProperty(Fluid owner, Property<V> property, V defaultValue) {
        return this.addProperty(() -> ((Fluid)owner).m_76144_(), Fluid.f_76104_, property, defaultValue);
    }

    default public <O, S extends StateHolder<O, S>, V extends Comparable<V>> Collection<S> addProperty(Supplier<StateDefinition<O, S>> stateManagerGetter, IdMapper<S> idList, Property<V> property, V defaultValue) {
        return Collections.emptyList();
    }

    default public <V extends Comparable<V>> Collection<BlockState> removeBlockProperty(Block owner, Property<V> property) {
        return this.removeProperty(() -> ((Block)owner).m_49965_(), () -> ((Block)owner).m_49966_(), property);
    }

    default public <V extends Comparable<V>> Collection<FluidState> removeFluidProperty(Fluid owner, Property<V> property) {
        return this.removeProperty(() -> ((Fluid)owner).m_76144_(), () -> ((Fluid)owner).m_76145_(), property);
    }

    default public <O, S extends StateHolder<O, S>, V extends Comparable<V>> Collection<S> removeProperty(Supplier<StateDefinition<O, S>> stateManagerGetter, Supplier<S> defaultStateGetter, Property<V> property) {
        return Collections.emptyList();
    }

    default public <V extends Comparable<V>> void refreshBlockStates(Property<V> property, Collection<V> addedValues, Collection<V> removedValues) {
    }

    default public <V extends Comparable<V>> void refreshFluidStates(Property<V> property, Collection<V> addedValues, Collection<V> removedValues) {
    }

    default public <O, V extends Comparable<V>, S extends StateHolder<O, S>> void refreshStates(Iterable<O> registry, IdMapper<S> stateIdList, Property<V> property, Collection<V> addedValues, Collection<V> removedValues, Function<O, S> defaultStateGetter, Function<O, StateDefinition<O, S>> managerGetter, Consumer<S> newStateConsumer) {
    }

    default public void reorderBlockStates() {
        this.reorderStates((Iterable)RegistryUtils.BLOCK_REGISTRY, (IdMapper)Block.f_49791_, (Function)Block::m_49965_);
    }

    default public void reorderFluidStates() {
        this.reorderStates((Iterable)RegistryUtils.FLUID_REGISTRY, (IdMapper)Fluid.f_76104_, (Function)Fluid::m_76144_);
    }

    default public <O, V extends Comparable<V>, S extends StateHolder<O, S>> void reorderStates(Iterable<O> registry, IdMapper<S> stateIdList, Function<O, StateDefinition<O, S>> managerGetter) {
    }

    default public boolean isParallel() {
        return false;
    }
}

