/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.statement.mixin;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import java.util.Map;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import virtuoel.statement.api.RefreshableStateManager;
import virtuoel.statement.util.StatementStateExtensions;

@Mixin(value={StateDefinition.class})
public class StateManagerMixin<O, S extends StateHolder<O, S>>
implements RefreshableStateManager<O, S> {
    @Shadow
    @Final
    @Mutable
    ImmutableSortedMap<String, Property<?>> f_61048_;
    @Shadow
    @Final
    @Mutable
    ImmutableList<S> f_61049_;

    @Override
    public void statement_setStateList(ImmutableList<S> states) {
        this.f_61049_ = states;
    }

    @Override
    public Map<String, Property<?>> statement_getProperties() {
        return this.f_61048_;
    }

    @Override
    public void statement_setProperties(Map<String, Property<?>> properties) {
        if (properties instanceof ImmutableSortedMap) {
            this.f_61048_ = (ImmutableSortedMap)properties;
        }
    }

    @Override
    public <V extends Comparable<V>> Property<?> statement_addProperty(Property<V> property, V defaultValue) {
        Property<?> ret = RefreshableStateManager.super.statement_addProperty(property, defaultValue);
        if (ret == null) {
            for (StateHolder state : this.f_61049_) {
                StatementStateExtensions.statement_cast(state).statement_addEntry(property, defaultValue);
            }
        }
        return ret;
    }

    @Override
    public Property<?> statement_removeProperty(String propertyName) {
        Property<?> ret = RefreshableStateManager.super.statement_removeProperty(propertyName);
        if (ret != null) {
            for (StateHolder state : this.f_61049_) {
                StatementStateExtensions.statement_cast(state).statement_removeEntry(ret);
            }
        }
        return ret;
    }
}

