/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.statement.mixin.compat116plus;

import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import virtuoel.statement.Statement;
import virtuoel.statement.util.StatementBlockStateExtensions;

@Mixin(value={BlockBehaviour.BlockStateBase.class})
public abstract class AbstractBlockStateMixin
implements StatementBlockStateExtensions {
    @Unique
    boolean firstOutlineLog = true;
    @Unique
    boolean firstCollisionLog = true;

    @Inject(at={@At(value="RETURN")}, cancellable=true, method={"getOutlineShape(Lnet/minecraft/world/BlockView;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/ShapeContext;)Lnet/minecraft/util/shape/VoxelShape;"})
    private void onGetOutlineShape(BlockGetter world, BlockPos pos, CollisionContext context, CallbackInfoReturnable<VoxelShape> info) {
        if (info.getReturnValue() == null) {
            if (this.firstOutlineLog) {
                this.firstOutlineLog = false;
                Statement.LOGGER.warn("BlockState {} returned a null outline shape! This should never happen!", new Object[]{this});
            }
            info.setReturnValue((Object)Shapes.m_83144_());
        }
    }

    @Inject(at={@At(value="RETURN")}, cancellable=true, method={"getCollisionShape(Lnet/minecraft/world/BlockView;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/ShapeContext;)Lnet/minecraft/util/shape/VoxelShape;"})
    private void onGetCollisionShape(BlockGetter world, BlockPos pos, CollisionContext context, CallbackInfoReturnable<VoxelShape> info) {
        if (info.getReturnValue() == null) {
            if (this.firstCollisionLog) {
                this.firstCollisionLog = false;
                Statement.LOGGER.warn("BlockState {} returned a null collsion shape! This should never happen!", new Object[]{this});
            }
            info.setReturnValue((Object)Shapes.m_83040_());
        }
    }

    @Shadow
    abstract Block m_60734_();

    @Override
    public Block statement_getBlock() {
        return this.m_60734_();
    }
}

