/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.statement.mixin.compat116plus;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Table;
import com.mojang.serialization.MapCodec;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import virtuoel.statement.Statement;
import virtuoel.statement.util.HydrogenCompatibility;
import virtuoel.statement.util.StatementStateExtensions;

@Mixin(value={StateHolder.class})
public abstract class StateMixin<O, S>
implements StatementStateExtensions<S> {
    @Shadow
    @Final
    @Mutable
    protected O f_61112_;
    @Shadow
    @Final
    @Mutable
    private ImmutableMap<Property<?>, Comparable<?>> f_61111_;
    @Shadow
    private Table<Property<?>, Comparable<?>, S> f_61114_;
    @Shadow
    @Final
    @Mutable
    MapCodec<S> f_61113_;
    @Unique
    String getMissingOwner = "";
    @Unique
    String withMissingOwner = "";
    @Unique
    String withDisallowedOwner = "";
    @Unique
    final Map<Property<?>, Comparable<?>> cachedFallbacks = new HashMap();

    @Inject(method={"get"}, cancellable=true, at={@At(value="INVOKE", target="Ljava/lang/IllegalArgumentException;<init>(Ljava/lang/String;)V")})
    private <T extends Comparable<T>> void onGet(Property<T> property, CallbackInfoReturnable<T> info) {
        String ownerString = this.f_61112_.toString();
        if (!this.getMissingOwner.equals(ownerString)) {
            Statement.LOGGER.info("Cannot get property {} as it does not exist in {}", new Object[]{property, this.f_61112_});
            this.getMissingOwner = ownerString;
        }
        info.setReturnValue((Object)(this.cachedFallbacks.containsKey(property) ? (Comparable)property.m_61709_().cast(this.cachedFallbacks.get(property)) : (Comparable)property.m_6908_().iterator().next()));
    }

    @Inject(method={"with"}, cancellable=true, at={@At(value="INVOKE", target="Ljava/lang/IllegalArgumentException;<init>(Ljava/lang/String;)V")})
    private <T extends Comparable<T>, V extends T> void onWith(Property<T> property, V value, CallbackInfoReturnable<Object> info) {
        String ownerString = this.f_61112_.toString();
        if (this.f_61111_.get(property) == null) {
            if (!this.withMissingOwner.equals(ownerString)) {
                Statement.LOGGER.info("Cannot set property {} as it does not exist in {}", new Object[]{property, this.f_61112_});
                this.withMissingOwner = ownerString;
            }
        } else if (!this.withDisallowedOwner.equals(ownerString)) {
            Statement.LOGGER.info("Cannot set property {} to {} on {}, it is not an allowed value", new Object[]{property, value, this.f_61112_});
            this.withDisallowedOwner = ownerString;
        }
        info.setReturnValue((Object)this);
    }

    @Inject(at={@At(value="HEAD")}, method={"createWithTable"})
    private void onCreateWithTable(Map<Map<Property<?>, Comparable<?>>, S> map, CallbackInfo info) {
        this.f_61114_ = null;
    }

    @Shadow
    abstract void m_61133_(Map<Map<Property<?>, Comparable<?>>, ?> var1);

    @Override
    public void statement_createWithTable(Map<Map<Property<?>, Comparable<?>>, ?> states) {
        this.m_61133_(states);
    }

    @Shadow
    abstract ImmutableMap<Property<?>, Comparable<?>> m_61148_();

    @Override
    public ImmutableMap<Property<?>, Comparable<?>> statement_getEntries() {
        return this.m_61148_();
    }

    @Shadow
    abstract <T extends Comparable<T>, V extends T> S m_61124_(Property<T> var1, V var2);

    @Override
    public <T extends Comparable<T>, V extends T> S statement_with(Property<T> property, V value) {
        return this.m_61124_(property, value);
    }

    @Override
    public <V extends Comparable<V>> boolean statement_addEntry(Property<V> property, V value) {
        if (!this.f_61111_.containsKey(property)) {
            this.statement_setEntries(ImmutableMap.builder().putAll(this.f_61111_).put(property, value).build());
            return true;
        }
        return false;
    }

    @Override
    public <V extends Comparable<V>> boolean statement_removeEntry(Property<V> property) {
        if (this.f_61111_.containsKey(property)) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Map.Entry entry : this.f_61111_.entrySet()) {
                Property key = (Property)entry.getKey();
                if (key == property) continue;
                builder.put((Object)key, (Object)((Comparable)entry.getValue()));
            }
            this.cachedFallbacks.put(property, (Comparable)this.f_61111_.get(property));
            this.statement_setEntries(builder.build());
            return true;
        }
        return false;
    }

    @Override
    public void statement_setEntries(ImmutableMap<Property<?>, Comparable<?>> entries) {
        this.f_61111_ = HydrogenCompatibility.INSTANCE.wrapEntries(entries);
    }

    @Override
    public Object statement_getCodec() {
        return this.f_61113_;
    }

    @Override
    public void statement_setCodec(Object codec) {
        this.f_61113_ = (MapCodec)codec;
    }
}

