/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.statement.network;

import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class StateValidationPacket {
    private UUID uuid;
    private int rate;
    private int[] ids;

    public StateValidationPacket(Player executor, int rate, int initialId) {
        this.uuid = executor.m_20148_();
        this.rate = rate;
        this.ids = new int[rate];
        for (int i = 0; i < rate; ++i) {
            this.ids[i] = initialId + i;
        }
    }

    protected StateValidationPacket(FriendlyByteBuf buf) {
        this.uuid = buf.m_130259_();
        this.rate = buf.m_130242_();
        this.ids = new int[this.rate];
        for (int i = 0; i < this.rate; ++i) {
            this.ids[i] = buf.m_130242_();
        }
    }

    public static void handle(StateValidationPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunForDist(() -> () -> "client", () -> () -> "server"));
        ctx.get().setPacketHandled(true);
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130077_(this.uuid).m_130130_(this.rate);
        for (int i = 0; i < this.rate; ++i) {
            buf.m_130130_(this.ids[i]);
        }
    }
}

