/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.statement.util;

import com.google.common.collect.ImmutableMap;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import virtuoel.statement.util.ModLoaderUtils;
import virtuoel.statement.util.ReflectionUtils;

public class HydrogenCompatibility {
    private static final boolean HYDROGEN_LOADED = ModLoaderUtils.isModLoaded("hydrogen");
    public static final HydrogenCompatibility INSTANCE = new HydrogenCompatibility();
    private final Optional<Class<?>> classConstructorsClass;
    private final Optional<Method> createFastImmutableMap;
    private boolean enabled = HYDROGEN_LOADED;

    public HydrogenCompatibility() {
        if (this.enabled) {
            this.classConstructorsClass = ReflectionUtils.getClass("me.jellysquid.mods.hydrogen.common.jvm.ClassConstructors");
            this.createFastImmutableMap = ReflectionUtils.getMethod(this.classConstructorsClass, "createFastImmutableMap", new Class[0]);
        } else {
            this.classConstructorsClass = Optional.empty();
            this.createFastImmutableMap = Optional.empty();
        }
    }

    public <K, V> ImmutableMap<K, V> wrapEntries(ImmutableMap<K, V> entries) {
        if (this.enabled) {
            return this.createFastImmutableMap.map(m -> {
                try {
                    return (ImmutableMap)m.invoke(null, entries);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    return null;
                }
            }).orElse(entries);
        }
        return entries;
    }
}

