/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.statement.util;

import it.unimi.dsi.fastutil.ints.Int2ObjectRBTreeMap;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.IdMapper;
import net.minecraft.core.Registry;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import org.spongepowered.asm.logging.ILogger;
import org.spongepowered.asm.service.MixinService;
import virtuoel.statement.Statement;
import virtuoel.statement.api.ClearableIdList;
import virtuoel.statement.api.RefreshableStateManager;
import virtuoel.statement.api.StateRefresher;
import virtuoel.statement.api.StatementConfig;
import virtuoel.statement.api.compatibility.FoamFixCompatibility;
import virtuoel.statement.api.property.MutableProperty;
import virtuoel.statement.util.ModLoaderUtils;
import virtuoel.statement.util.NetworkUtils;
import virtuoel.statement.util.PolymerCompatibility;
import virtuoel.statement.util.RegistryUtils;
import virtuoel.statement.util.StatementBlockStateExtensions;
import virtuoel.statement.util.StatementPropertyExtensions;
import virtuoel.statement.util.StatementStateExtensions;

public class StateRefresherImpl
implements StateRefresher {
    private static final ILogger LOGGER = MixinService.getService().getLogger("statement");
    private static final ExecutorService EXECUTOR = Executors.newCachedThreadPool();
    private Boolean parallel = null;

    @Override
    public <O, S extends StateHolder<O, S>, V extends Comparable<V>> Collection<S> addProperty(Supplier<StateDefinition<O, S>> stateManagerGetter, IdMapper<S> idList, Property<V> property, V defaultValue) {
        RefreshableStateManager manager = (RefreshableStateManager)stateManagerGetter.get();
        manager.statement_addProperty(property, defaultValue);
        StatementPropertyExtensions p = (StatementPropertyExtensions)property;
        List nonDefaultValues = p.statement_getValues().stream().filter(v -> v != defaultValue).collect(Collectors.toList());
        Collection states = manager.statement_reconstructStateList(Collections.singletonMap(property, nonDefaultValues));
        for (StateHolder s : states) {
            idList.m_122667_((Object)s);
            ((StatementStateExtensions)s).statement_initShapeCache();
        }
        return states;
    }

    @Override
    public <O, S extends StateHolder<O, S>, V extends Comparable<V>> Collection<S> removeProperty(Supplier<StateDefinition<O, S>> stateManagerGetter, Supplier<S> defaultStateGetter, Property<V> property) {
        StateHolder defaultState;
        StateDefinition<O, S> stateManager = stateManagerGetter.get();
        RefreshableStateManager manager = (RefreshableStateManager)stateManager;
        Property named = stateManager.m_61081_(((StatementPropertyExtensions)property).statement_getName());
        if (named != null && (defaultState = (StateHolder)defaultStateGetter.get()).m_61148_().containsKey((Object)named)) {
            Comparable defaultValue = defaultState.m_61143_(named);
            Collection states = stateManager.m_61056_().stream().filter(s -> s.m_61143_(named) != defaultValue).collect(Collectors.toList());
            if (manager.statement_removeProperty(named)) {
                manager.statement_reconstructStateList(Collections.emptyMap());
            }
            return states;
        }
        return Collections.emptyList();
    }

    @Override
    public <V extends Comparable<V>> void refreshBlockStates(Property<V> property, Collection<V> addedValues, Collection<V> removedValues) {
        this.refreshStates((Iterable)RegistryUtils.BLOCK_REGISTRY, (IdMapper)Block.f_49791_, property, addedValues, removedValues, (Function)Block::m_49966_, (Function)Block::m_49965_, (Consumer)s -> ((StatementBlockStateExtensions)s).statement_initShapeCache());
        Statement.markRegistryAsModded(RegistryUtils.BLOCK_REGISTRY);
    }

    @Override
    public <V extends Comparable<V>> void refreshFluidStates(Property<V> property, Collection<V> addedValues, Collection<V> removedValues) {
        this.refreshStates((Iterable)RegistryUtils.FLUID_REGISTRY, (IdMapper)Fluid.f_76104_, property, addedValues, removedValues, (Function)Fluid::m_76145_, (Function)Fluid::m_76144_, (Consumer)f -> {});
        Statement.markRegistryAsModded(RegistryUtils.FLUID_REGISTRY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <O, V extends Comparable<V>, S extends StateHolder<O, S>> void refreshStates(Iterable<O> registry, IdMapper<S> stateIdList, Property<V> property, Collection<V> addedValues, Collection<V> removedValues, Function<O, S> defaultStateGetter, Function<O, StateDefinition<O, S>> stateManagerGetter, Consumer<S> newStateConsumer) {
        boolean noRemovedValues;
        Statement.invalidateCustomStateData(stateIdList);
        long startTime = System.nanoTime();
        LinkedList<RefreshableStateManager> managersToRefresh = new LinkedList<RefreshableStateManager>();
        for (O entry : registry) {
            if (!((StatementStateExtensions)defaultStateGetter.apply(entry)).statement_getEntries().containsKey(property)) continue;
            RefreshableStateManager manager = (RefreshableStateManager)stateManagerGetter.apply(entry);
            managersToRefresh.add(manager);
        }
        HashMap addedValueMap = new HashMap();
        ConcurrentLinkedQueue addedStates = new ConcurrentLinkedQueue();
        ConcurrentLinkedQueue removedStates = new ConcurrentLinkedQueue();
        LinkedList<CompletionStage> allFutures = new LinkedList<CompletionStage>();
        int entryQuantity = managersToRefresh.size();
        int addedValueQuantity = addedValues.size();
        int removedValueQuantity = removedValues.size();
        boolean noAddedValues = addedValueQuantity == 0;
        boolean bl = noRemovedValues = removedValueQuantity == 0;
        if (noAddedValues && noRemovedValues) {
            LOGGER.debug("Refreshing states of {} entries after {} ns of setup.", new Object[]{entryQuantity, System.nanoTime() - startTime});
        } else if (noAddedValues || noRemovedValues) {
            LOGGER.debug("Refreshing states of {} entries for {} values(s) {} after {} ns of setup.", new Object[]{entryQuantity, noRemovedValues ? "new" : "removed", noRemovedValues ? addedValues : removedValues, System.nanoTime() - startTime});
        } else {
            LOGGER.debug("Refreshing states of {} entries for new values(s) {} and removed value(s) {} after {} ns of setup.", new Object[]{entryQuantity, addedValues, removedValues, System.nanoTime() - startTime});
        }
        Property property2 = property;
        synchronized (property2) {
            MutableProperty.of(property).ifPresent(mutableProperty -> {
                addedValueMap.put(property, addedValues);
                StatementPropertyExtensions p = (StatementPropertyExtensions)((Object)mutableProperty);
                Collection values = p.statement_getValues();
                values.addAll(addedValues);
                values.removeAll(removedValues);
                FoamFixCompatibility.INSTANCE.removePropertyFromEntryMap(property);
            });
        }
        property2 = stateIdList;
        synchronized (property2) {
            for (RefreshableStateManager manager : managersToRefresh) {
                allFutures.add(CompletableFuture.supplyAsync(() -> {
                    if (!noRemovedValues) {
                        StateDefinition f = (StateDefinition)manager;
                        f.m_61056_().parallelStream().filter(state -> state.m_61148_().containsKey((Object)property) && removedValues.contains(state.m_61143_(property))).forEach(removedStates::add);
                    }
                    return manager.statement_reconstructStateList(addedValueMap);
                }, EXECUTOR).thenAccept(addedStates::addAll));
            }
            ((CompletableFuture)CompletableFuture.allOf((CompletableFuture[])allFutures.stream().toArray(CompletableFuture[]::new)).thenAccept(v -> {
                boolean noRemovals;
                addedStates.forEach(state -> {
                    newStateConsumer.accept(state);
                    stateIdList.m_122667_(state);
                });
                int addedStateQuantity = addedStates.size();
                int removedStateQuantity = removedStates.size();
                boolean noAdditions = addedStateQuantity == 0;
                boolean bl = noRemovals = removedStateQuantity == 0;
                if (noAdditions && noRemovals) {
                    LOGGER.debug("Refreshed states with no additions or removals after {} ms.", new Object[]{System.nanoTime() - startTime});
                } else if (noAdditions || noRemovals) {
                    LOGGER.debug("{} {} state(s) for {} values(s) {} after {} ms.", new Object[]{noRemovals ? "Added" : "Removed", noRemovals ? addedStateQuantity : removedStateQuantity, noRemovals ? "new" : "old", noRemovals ? addedValues : removedValues, (System.nanoTime() - startTime) / 1000000L});
                } else {
                    LOGGER.debug("Added {} state(s) for new values(s) {} and removed {} states for old value(s) {} after {} ms.", new Object[]{addedStateQuantity, addedValues, removedStateQuantity, removedValues, (System.nanoTime() - startTime) / 1000000L});
                }
            })).join();
        }
    }

    @Override
    public <O, V extends Comparable<V>, S extends StateHolder<O, S>> void reorderStates(Iterable<O> registry, IdMapper<S> stateIdList, Function<O, StateDefinition<O, S>> stateManagerGetter) {
        ObjectCollection entries;
        boolean lastAutoRead = NetworkUtils.setAutoRead(false);
        if (registry instanceof Registry) {
            Int2ObjectRBTreeMap sortedEntries = new Int2ObjectRBTreeMap();
            for (O entry : registry) {
                sortedEntries.put(RegistryUtils.getRawId((Registry)registry, entry), entry);
            }
            entries = sortedEntries.values();
        } else {
            entries = registry;
        }
        LinkedList<StateHolder> initialStates = new LinkedList<StateHolder>();
        LinkedList<StateHolder> deferredStates = new LinkedList<StateHolder>();
        for (O entry : entries) {
            for (StateHolder state : stateManagerGetter.apply(entry).m_61056_()) {
                if (Statement.shouldStateBeDeferred(stateIdList, state)) {
                    deferredStates.add(state);
                    continue;
                }
                initialStates.add(state);
            }
        }
        PolymerCompatibility.preRecalculation(stateIdList);
        ((ClearableIdList)stateIdList).statement_clear();
        initialStates.forEach(arg_0 -> stateIdList.m_122667_(arg_0));
        deferredStates.forEach(arg_0 -> stateIdList.m_122667_(arg_0));
        PolymerCompatibility.postRecalculation(stateIdList);
        NetworkUtils.setAutoRead(lastAutoRead);
    }

    @Override
    public boolean isParallel() {
        if (this.parallel == null) {
            boolean forceParallelMode = StatementConfig.COMMON.forceParallelMode.get();
            boolean ferriteCoreLoaded = ModLoaderUtils.isModLoaded("ferritecore");
            this.parallel = forceParallelMode || !ferriteCoreLoaded;
        }
        return this.parallel;
    }
}

