/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.statement.util;

import com.google.common.collect.ImmutableMap;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public interface StatementStateManagerFactoryExtensions<O, S extends StateHolder<O, S>> {
    @Nullable
    public static final Method CREATE_METHOD = StatementStateManagerFactoryExtensions.getCreateMethod();

    @Nullable
    public static Method getCreateMethod() {
        try {
            return StateDefinition.Factory.class.getMethod("create", Object.class, ImmutableMap.class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            return null;
        }
    }

    default public S statement_create(O owner, ImmutableMap<Property<?>, Comparable<?>> entries) {
        if (CREATE_METHOD != null) {
            try {
                return (S)((StateHolder)CREATE_METHOD.invoke((Object)this, owner, entries));
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                // empty catch block
            }
        }
        return null;
    }
}

