/*
 * Decompiled with CFR 0.152.
 */
package com.davigj.whiffowisp.common.block.scented_candles;

import com.davigj.whiffowisp.common.block.scented_candles.ScentedCandleBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class DistantSongCandleBlock
extends ScentedCandleBlock {
    public DistantSongCandleBlock(BlockBehaviour.Properties p_152801_) {
        super(p_152801_);
    }

    @Override
    public void affect(Level level, BlockPos pos, BlockState state, Entity entity) {
        super.affect(level, pos, state, entity);
        if (entity instanceof LivingEntity) {
            Player player;
            LivingEntity living = (LivingEntity)entity;
            if (entity instanceof Player && (player = (Player)entity).m_6047_()) {
                return;
            }
            switch ((Integer)state.m_61143_((Property)f_152790_)) {
                case 1: {
                    DistantSongCandleBlock.teleport(living, level, 0, -6);
                    break;
                }
                case 2: {
                    DistantSongCandleBlock.teleport(living, level, -6, 0);
                    break;
                }
                case 3: {
                    DistantSongCandleBlock.teleport(living, level, 6, 0);
                    break;
                }
                case 4: {
                    DistantSongCandleBlock.teleport(living, level, 0, 6);
                }
            }
        }
    }

    public static void teleport(LivingEntity living, Level level, int xOffset, int zOffset) {
        BlockPos playerPos = living.m_20183_();
        BlockPos targetPos = DistantSongCandleBlock.findPos(playerPos, level, xOffset, zOffset);
        if (targetPos != null) {
            double x = (double)targetPos.m_123341_() + 0.5;
            double y = targetPos.m_123342_();
            double z = (double)targetPos.m_123343_() + 0.5;
            int i = 0;
            while (!level.m_8055_(new BlockPos(x, y, z)).m_60795_() && i < 5) {
                ++i;
                y += 1.0;
            }
            if (i != 4) {
                if (living.m_20159_() || living.m_20160_()) {
                    DistantSongCandleBlock.failTeleport(living, level);
                    return;
                }
                if (!level.f_46443_) {
                    living.m_6021_(x, y, z);
                    living.m_183634_();
                    if (!(living instanceof Player)) {
                        living.m_5496_(SoundEvents.f_11852_, 0.12f, 1.3f + living.m_217043_().m_188501_());
                    }
                } else {
                    for (int j = 0; j < 4; ++j) {
                        RandomSource random = level.m_213780_();
                        level.m_7106_((ParticleOptions)ParticleTypes.f_123810_, living.m_20185_() + random.m_188500_() - 0.5, living.m_20186_(), living.m_20189_() + random.m_188500_() - 0.5, 0.0, 0.0, 0.0);
                    }
                    living.m_5496_(SoundEvents.f_11757_, 0.12f, 1.3f + living.m_217043_().m_188501_());
                }
            } else {
                DistantSongCandleBlock.failTeleport(living, level);
            }
        }
    }

    private static void failTeleport(LivingEntity living, Level level) {
        if (living.f_19797_ % 20 == 0) {
            if (level.f_46443_) {
                for (int i = 0; i < 5; ++i) {
                    RandomSource random = level.m_213780_();
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, living.m_20185_() + random.m_188500_() - 0.5, living.m_20186_(), living.m_20189_() + random.m_188500_() - 0.5, 0.0, 0.0, 0.0);
                }
                living.m_5496_(SoundEvents.f_11874_, 0.3f, 4.0f);
            } else {
                living.m_6469_(DamageSource.f_19319_, 1.0f);
            }
        }
    }

    private static BlockPos findPos(BlockPos startPos, Level level, int xOffset, int zOffset) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos(startPos.m_123341_() + xOffset, startPos.m_123342_(), startPos.m_123343_() + zOffset);
        if (mutablePos.m_123342_() >= level.m_141937_() && mutablePos.m_123342_() <= level.m_151558_()) {
            return mutablePos;
        }
        return null;
    }
}

