/*
 * Decompiled with CFR 0.152.
 */
package com.davigj.whiffowisp.common.block.scented_candles;

import com.davigj.whiffowisp.common.block.entity.ScentedCandleBlockEntity;
import com.davigj.whiffowisp.core.WOWConfig;
import com.davigj.whiffowisp.core.other.WOWBlockStatements;
import com.davigj.whiffowisp.core.registry.WOWBlockEntityTypes;
import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScentedCandleBlock
extends CandleBlock
implements EntityBlock {
    private static final Int2ObjectMap<List<Vec3>> PARTICLE_OFFSETS = (Int2ObjectMap)Util.m_137537_(() -> {
        Int2ObjectOpenHashMap int2objectmap = new Int2ObjectOpenHashMap();
        int2objectmap.defaultReturnValue((Object)ImmutableList.of());
        int2objectmap.put(1, (Object)ImmutableList.of((Object)new Vec3(0.5, 0.5, 0.5)));
        int2objectmap.put(2, (Object)ImmutableList.of((Object)new Vec3(0.5, 0.688, 0.5)));
        int2objectmap.put(3, (Object)ImmutableList.of((Object)new Vec3(0.5, 0.875, 0.5)));
        int2objectmap.put(4, (Object)ImmutableList.of((Object)new Vec3(0.5, 1.05, 0.5)));
        return Int2ObjectMaps.unmodifiable((Int2ObjectMap)int2objectmap);
    });
    private static final VoxelShape ONE_AABB = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0);
    private static final VoxelShape TWO_AABB = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)9.0, (double)10.0);
    private static final VoxelShape THREE_AABB = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)12.0, (double)11.0);
    private static final VoxelShape FOUR_AABB = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)14.0, (double)12.0);

    public ScentedCandleBlock(BlockBehaviour.Properties p_152801_) {
        super(p_152801_);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WOWBlockStatements.TRIMMED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_152790_, (Comparable)Integer.valueOf(1))).m_61124_((Property)f_152791_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_152792_, (Comparable)Boolean.valueOf(false)));
    }

    public void m_141947_(Level level, BlockPos pos, BlockState state, Entity entity) {
        if (((Boolean)state.m_61143_((Property)f_152791_)).booleanValue()) {
            this.affect(level, pos, state, entity);
        }
        super.m_141947_(level, pos, state, entity);
    }

    public void affect(Level level, BlockPos pos, BlockState state, Entity entity) {
        if (!((Boolean)WOWConfig.COMMON.scentFX.get()).booleanValue()) {
            return;
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WOWBlockStatements.TRIMMED, f_152791_, f_152790_, f_152792_});
    }

    public VoxelShape m_5940_(BlockState state, @NotNull BlockGetter block, @NotNull BlockPos pos, @NotNull CollisionContext collision) {
        return switch ((Integer)state.m_61143_((Property)f_152790_)) {
            default -> ONE_AABB;
            case 2 -> TWO_AABB;
            case 3 -> THREE_AABB;
            case 4 -> FOUR_AABB;
        };
    }

    protected Iterable<Vec3> m_142199_(BlockState state) {
        return (Iterable)PARTICLE_OFFSETS.get(((Integer)state.m_61143_((Property)f_152790_)).intValue());
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return new ScentedCandleBlockEntity(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@NotNull Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> blockEntity) {
        return ScentedCandleBlock.createTickerHelper(blockEntity, (BlockEntityType)WOWBlockEntityTypes.SCENTED_CANDLE.get(), ScentedCandleBlockEntity::tick);
    }

    @javax.annotation.Nullable
    protected static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> entityType, BlockEntityType<E> otherEntity, BlockEntityTicker<? super E> ticker) {
        return otherEntity == entityType ? ticker : null;
    }
}

